/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars.tileentity;

import cpw.mods.compactsolars.CompactSolars;
import cpw.mods.compactsolars.common.CompactSolarType;
import ic2.api.energy.prefab.BasicSource;
import ic2.api.item.IElectricItem;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TileEntityCompactSolar
extends TileEntity
implements ITickable,
IInventory,
IWrenchable {
    private BasicSource energyBuffer;
    private static Random random = new Random();
    private CompactSolarType type;
    private ItemStack[] inventory;
    private boolean initialized;
    public boolean theSunIsVisible;
    private int tick;
    private boolean canRain;
    private boolean noSunlight;

    public TileEntityCompactSolar() {
        this(CompactSolarType.LOW_VOLTAGE);
    }

    public TileEntityCompactSolar(CompactSolarType type) {
        this.type = type;
        this.inventory = new ItemStack[1];
        this.tick = random.nextInt(64);
        this.energyBuffer = new BasicSource((TileEntity)this, (double)type.maxStorage, type.ordinal() + 1);
    }

    public void onLoad() {
        this.energyBuffer.onLoad();
    }

    public void func_73660_a() {
        this.energyBuffer.func_73660_a();
        if (!this.initialized && this.field_145850_b != null) {
            this.canRain = this.field_145850_b.func_175726_f(this.field_174879_c).func_177411_a(this.field_174879_c, this.field_145850_b.func_72959_q()).func_76727_i() > 0.0f;
            this.noSunlight = this.field_145850_b.field_73011_w.func_177495_o();
            this.initialized = true;
        }
        if (this.noSunlight) {
            return;
        }
        if (this.tick-- == 0) {
            this.updateSunState();
            this.tick = 64;
        }
        int energyProduction = 0;
        if (this.theSunIsVisible && (CompactSolars.productionRate == 1 || random.nextInt(CompactSolars.productionRate) == 0)) {
            energyProduction = this.generateEnergy();
        }
        this.energyBuffer.addEnergy((double)energyProduction);
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IElectricItem) {
            this.energyBuffer.charge(this.inventory[0]);
        }
    }

    private void updateSunState() {
        boolean isRaining = this.canRain && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I());
        this.theSunIsVisible = this.field_145850_b.func_72935_r() && !isRaining && this.field_145850_b.func_175678_i(this.field_174879_c.func_177984_a());
    }

    private int generateEnergy() {
        return this.type.getOutput();
    }

    public ItemStack[] getContents() {
        return this.inventory;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != null) {
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack stack = this.inventory[index];
                this.inventory[index] = null;
                this.func_70296_d();
                return stack;
            }
            ItemStack stack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.inventory[index] = null;
            }
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.type.name();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public EnumFacing getFacing(World world, BlockPos pos) {
        return EnumFacing.field_82609_l[0];
    }

    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }

    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(itemCompound);
            tagList.func_74742_a((NBTBase)itemCompound);
        }
        compound.func_74782_a("Items", (NBTBase)tagList);
        return this.energyBuffer.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energyBuffer.func_145839_a(compound);
        NBTTagList tagList = compound.func_150295_c("Items", 9);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int itemCount = 0; itemCount < tagList.func_74745_c(); ++itemCount) {
            NBTTagCompound itemCompound = tagList.func_150305_b(itemCount);
            int slot = itemCompound.func_74771_c("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }

    public CompactSolarType getType() {
        return this.type;
    }

    public void onChunkUnload() {
        this.energyBuffer.onChunkUnload();
    }

    public void func_145843_s() {
        this.energyBuffer.func_145843_s();
        super.func_145843_s();
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack stack = this.inventory[index];
            this.inventory[index] = null;
            return stack;
        }
        return null;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        return Arrays.asList(new ItemStack((Block)CompactSolars.compactSolarBlock, 1, this.getType().ordinal()));
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IElectricItem;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }
}

