/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.compactsolars.common;

import com.google.common.base.Throwables;
import cpw.mods.compactsolars.CompactSolars;
import cpw.mods.compactsolars.blocks.BlockCompactSolar;
import cpw.mods.compactsolars.items.ItemSolarHat;
import cpw.mods.compactsolars.tileentity.TileEntityCompactSolar;
import cpw.mods.compactsolars.tileentity.TileEntityCompactSolarHV;
import cpw.mods.compactsolars.tileentity.TileEntityCompactSolarMV;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public enum CompactSolarType implements IStringSerializable
{
    LOW_VOLTAGE(8, 32, "Low Voltage Solar Array", "lv_transformer", TileEntityCompactSolar.class, "lv_hat"),
    MEDIUM_VOLTAGE(64, 128, "Medium Voltage Solar Array", "mv_transformer", TileEntityCompactSolarMV.class, "mv_hat"),
    HIGH_VOLTAGE(512, 512, "High Voltage Solar Array", "hv_transformer", TileEntityCompactSolarHV.class, "hv_hat");

    private int output;
    public Class<? extends TileEntityCompactSolar> clazz;
    public String friendlyName;
    public String transformerName;
    public final ResourceLocation hatTexture;
    public final String hatName;
    private ItemSolarHat item;
    public final ResourceLocation hatItemTexture;
    public final int outputPacketSize;
    public final int maxStorage;

    private CompactSolarType(int output, int outputPacketSize, String friendlyName, String transformerName, Class<? extends TileEntityCompactSolar> clazz, String hatTexture) {
        this.output = output;
        this.outputPacketSize = outputPacketSize;
        this.friendlyName = friendlyName;
        this.transformerName = transformerName;
        this.clazz = clazz;
        this.hatName = "solar_hat_" + this.name().toLowerCase();
        this.hatTexture = new ResourceLocation("compactsolars", "textures/armor/" + hatTexture + ".png");
        this.hatItemTexture = new ResourceLocation("compactsolars", hatTexture);
        this.maxStorage = outputPacketSize << 1;
    }

    public static void generateRecipes(BlockCompactSolar block) {
        ItemStack solar;
        ItemStack parent = solar = IC2Items.getItem((String)"te", (String)"solar_generator");
        for (CompactSolarType typ : CompactSolarType.values()) {
            ItemStack targ = new ItemStack((Block)block, 1, typ.ordinal());
            ItemStack transformer = IC2Items.getItem((String)"te", (String)typ.transformerName);
            CompactSolarType.addRecipe(targ, "SSS", "SXS", "SSS", Character.valueOf('S'), parent, Character.valueOf('X'), transformer);
            parent = targ;
        }
    }

    private static void addRecipe(ItemStack target, Object ... args) {
        GameRegistry.addRecipe((ItemStack)target, (Object[])args);
    }

    public int getOutput() {
        return this.output;
    }

    public static TileEntityCompactSolar makeEntity(int metadata) {
        try {
            TileEntityCompactSolar te = CompactSolarType.values()[metadata].clazz.newInstance();
            return te;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public int getTextureRow() {
        return this.ordinal();
    }

    public String tileEntityName() {
        return "CompactSolarType." + this.name();
    }

    public ItemSolarHat buildHat() {
        this.item = new ItemSolarHat(this);
        this.item.func_77655_b("compactsolars:" + this.hatName);
        this.item.setRegistryName(new ResourceLocation("compactsolars", this.hatName));
        GameRegistry.register((IForgeRegistryEntry)this.item);
        return this.item;
    }

    public static void buildHats() {
        for (CompactSolarType typ : CompactSolarType.values()) {
            typ.buildHat();
            CompactSolars.proxy.registerSolarHatModels((Item)typ.item);
        }
    }

    public static void generateHatRecipes(BlockCompactSolar block) {
        ItemArmor ironHat = Items.field_151028_Y;
        for (CompactSolarType typ : CompactSolarType.values()) {
            ItemStack solarBlock = new ItemStack((Block)block, 0, typ.ordinal());
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)typ.item), (Object[])new Object[]{solarBlock, ironHat});
        }
    }

    public static int validateMeta(int metadata) {
        if (metadata < CompactSolarType.values().length) {
            return metadata;
        }
        return 0;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }
}

