/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.EnumReloadType;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.ISyncData;
import com.feed_the_beast.ftbl.api.NotificationId;
import com.feed_the_beast.ftbl.api_impl.PackMode;
import com.feed_the_beast.ftbl.api_impl.SharedClientData;
import com.feed_the_beast.ftbl.api_impl.SharedServerData;
import com.feed_the_beast.ftbl.client.teamsgui.MyTeamData;
import com.feed_the_beast.ftbl.lib.Notification;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.net.MessageNotifyPlayer;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.server.permission.PermissionAPI;

public class MessageLogin
extends MessageToClient<MessageLogin> {
    private static final byte IS_OP = 1;
    private static final byte OPTIONAL_SERVER_MODS = 2;
    private byte flags;
    private String currentMode;
    private UUID universeID;
    private Map<NotificationId, INotification> notifications;
    private NBTTagCompound syncData;
    private Collection<String> optionalServerMods;
    private long lastMessageTime;

    public MessageLogin() {
    }

    public MessageLogin(EntityPlayerMP player, IForgePlayer forgePlayer) {
        this.flags = 0;
        this.flags = Bits.setFlag(this.flags, (byte)1, PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbl.op_buttons"));
        this.currentMode = SharedServerData.INSTANCE.getPackMode().func_176610_l();
        this.universeID = SharedServerData.INSTANCE.getUniverseID();
        this.notifications = SharedServerData.INSTANCE.notifications;
        this.syncData = new NBTTagCompound();
        FTBLibModCommon.SYNCED_DATA.forEach((key, value) -> this.syncData.func_74782_a(key, (NBTBase)value.writeSyncData(player, forgePlayer)));
        this.optionalServerMods = SharedServerData.INSTANCE.optionalServerMods;
        this.flags = Bits.setFlag(this.flags, (byte)2, !this.optionalServerMods.isEmpty());
        IForgeTeam team = forgePlayer.getTeam();
        if (team != null && team.getMessages().size() > 0) {
            this.lastMessageTime = team.getMessages().get(team.getMessages().size() - 1).getTime();
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void toBytes(ByteBuf io) {
        io.writeByte((int)this.flags);
        ByteBufUtils.writeUTF8String((ByteBuf)io, (String)this.currentMode);
        NetUtils.writeUUID(io, this.universeID);
        io.writeShort(this.notifications.size());
        this.notifications.forEach((key, value) -> MessageNotifyPlayer.write(io, value));
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.syncData);
        if (!this.optionalServerMods.isEmpty()) {
            io.writeShort(this.optionalServerMods.size());
            for (String s : this.optionalServerMods) {
                ByteBufUtils.writeUTF8String((ByteBuf)io, (String)s);
            }
        }
        io.writeLong(this.lastMessageTime);
    }

    public void fromBytes(ByteBuf io) {
        this.flags = io.readByte();
        this.currentMode = ByteBufUtils.readUTF8String((ByteBuf)io);
        this.universeID = NetUtils.readUUID(io);
        int s = io.readUnsignedShort();
        this.notifications = new HashMap<NotificationId, INotification>(s);
        while (--s >= 0) {
            Notification n = MessageNotifyPlayer.read(io);
            this.notifications.put(n.getId(), n);
        }
        this.syncData = ByteBufUtils.readTag((ByteBuf)io);
        if (Bits.getFlag(this.flags, (byte)2)) {
            s = io.readUnsignedShort();
            this.optionalServerMods = new HashSet<String>(s);
            while (--s >= 0) {
                this.optionalServerMods.add(ByteBufUtils.readUTF8String((ByteBuf)io));
            }
        }
        this.lastMessageTime = io.readLong();
    }

    @Override
    public void onMessage(MessageLogin m, EntityPlayer player) {
        SharedClientData.INSTANCE.reset();
        SharedClientData.INSTANCE.isClientPlayerOP = Bits.getFlag(m.flags, (byte)1);
        SharedClientData.INSTANCE.universeID = m.universeID;
        SharedClientData.INSTANCE.currentMode = new PackMode(m.currentMode);
        if (m.optionalServerMods != null && !m.optionalServerMods.isEmpty()) {
            SharedClientData.INSTANCE.optionalServerMods.addAll(m.optionalServerMods);
        }
        SharedClientData.INSTANCE.notifications.putAll(m.notifications);
        for (String key : m.syncData.func_150296_c()) {
            ISyncData nbt = FTBLibModCommon.SYNCED_DATA.get(key);
            if (nbt == null) continue;
            nbt.readSyncData(m.syncData.func_74775_l(key));
        }
        FTBLibClient.CACHED_SKINS.clear();
        FTBLibIntegrationInternal.API.reload(Side.CLIENT, (ICommandSender)player, EnumReloadType.CREATED);
        MyTeamData.lastMessageTime = m.lastMessageTime;
    }
}

