/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.lib.config.BasicConfigContainer;
import com.feed_the_beast.ftbl.lib.config.ConfigTree;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.NetUtils;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.net.MessageEditConfigResponse;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MessageEditConfig
extends MessageToClient<MessageEditConfig> {
    private static NBTTagCompound RX_NBT;
    private static final IConfigTree RX_CONFIG_TREE;
    private IConfigTree group;
    private NBTTagCompound extraNBT;
    private ITextComponent title;

    public MessageEditConfig() {
    }

    public MessageEditConfig(UUID id, @Nullable NBTTagCompound nbt, IConfigContainer c) {
        FTBLibModCommon.TEMP_SERVER_CONFIG.put(id, c);
        this.group = c.getConfigTree().copy();
        this.extraNBT = nbt;
        this.title = c.getTitle();
        if (LMUtils.DEV_ENV) {
            LMUtils.DEV_LOGGER.info("TX Send: " + this.group.getTree());
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    public void fromBytes(ByteBuf io) {
        RX_NBT = ByteBufUtils.readTag((ByteBuf)io);
        this.title = NetUtils.readTextComponent(io);
        RX_CONFIG_TREE.readData(io);
    }

    public void toBytes(ByteBuf io) {
        ByteBufUtils.writeTag((ByteBuf)io, (NBTTagCompound)this.extraNBT);
        NetUtils.writeTextComponent(io, this.title);
        this.group.writeData(io);
    }

    @Override
    public void onMessage(MessageEditConfig m, EntityPlayer player) {
        if (LMUtils.DEV_ENV) {
            LMUtils.DEV_LOGGER.info("RX Send: " + RX_CONFIG_TREE.getTree());
        }
        new GuiEditConfig(RX_NBT, new BasicConfigContainer(m.title, RX_CONFIG_TREE)).openGui();
    }

    static {
        RX_CONFIG_TREE = new ConfigTree(){

            @Override
            public void func_152753_a(JsonElement json) {
                new MessageEditConfigResponse(RX_NBT, json.getAsJsonObject()).sendToServer();
            }
        };
    }
}

