/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.io;

import com.feed_the_beast.ftbl.lib.io.RequestMethod;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.imageio.ImageIO;

public final class Response {
    private RequestMethod method;
    private long millis;
    private int code;
    private InputStream stream;

    public Response(RequestMethod m, long ms, int c, InputStream is) {
        this.method = m;
        this.millis = ms;
        this.code = c;
        this.stream = is;
    }

    public Response(InputStream is) {
        this(RequestMethod.GET, 0L, 200, is);
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public long getMillis() {
        return this.millis;
    }

    public int getResponseCode() {
        return this.code;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public String asString() throws Exception {
        return StringUtils.readString(this.getStream());
    }

    public List<String> asStringList() throws Exception {
        return StringUtils.readStringList(this.getStream());
    }

    public JsonElement asJson() throws Exception {
        return JsonUtils.fromJson(new BufferedReader(new InputStreamReader(this.getStream())));
    }

    public BufferedImage asImage() throws Exception {
        return ImageIO.read(this.getStream());
    }

    public String toString() {
        return (Object)((Object)this.getMethod()) + "-" + Integer.toString(this.getResponseCode());
    }
}

