/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.gui.misc;

import com.feed_the_beast.ftbl.api.gui.IClientActionGui;
import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.api.gui.IMouseButton;
import com.feed_the_beast.ftbl.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbl.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ColoredObject;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.client.TextureCoords;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.guide.ButtonGuidePage;
import com.feed_the_beast.ftbl.lib.guide.GuidePage;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GuiGuide
extends GuiBase
implements IClientActionGui {
    private static final ResourceLocation TEXTURE = FTBLibFinals.get("textures/gui/info.png");
    private static final TextureCoords TEX_SLIDER = TextureCoords.fromCoords(TEXTURE, 0, 30, 12, 18, 64, 64);
    private static final TextureCoords TEX_BACK = TextureCoords.fromCoords(TEXTURE, 13, 30, 14, 11, 64, 64);
    private static final TextureCoords TEX_CLOSE = TextureCoords.fromCoords(TEXTURE, 13, 41, 14, 11, 64, 64);
    public static final TextureCoords TEX_BULLET = TextureCoords.fromCoords(TEXTURE, 0, 49, 6, 6, 64, 64);
    private static final TextureCoords TEX_BG_MU = TextureCoords.fromCoords(TEXTURE, 14, 0, 1, 13, 64, 64);
    private static final TextureCoords TEX_BG_MD = TextureCoords.fromCoords(TEXTURE, 14, 16, 1, 13, 64, 64);
    private static final TextureCoords TEX_BG_ML = TextureCoords.fromCoords(TEXTURE, 0, 14, 13, 1, 64, 64);
    private static final TextureCoords TEX_BG_MR = TextureCoords.fromCoords(TEXTURE, 16, 14, 13, 1, 64, 64);
    private static final TextureCoords TEX_BG_NN = TextureCoords.fromCoords(TEXTURE, 0, 0, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_PN = TextureCoords.fromCoords(TEXTURE, 16, 0, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_NP = TextureCoords.fromCoords(TEXTURE, 0, 16, 13, 13, 64, 64);
    private static final TextureCoords TEX_BG_PP = TextureCoords.fromCoords(TEXTURE, 16, 16, 13, 13, 64, 64);
    public static final IDrawableObject FILLING = (x, y, w, h, col) -> GuiHelper.drawBlankRect(x + 4, y + 4, w - 8, h - 8, col.hasColor() ? col : GuiConfigs.INFO_BACKGROUND.getColor());
    public static final IDrawableObject BORDERS = (x, y, w, h, col) -> {
        Color4I c = col.hasColor() ? col : Color4I.WHITE;
        TEX_BG_MU.draw(x + 13, y, w - 24, 13, c);
        TEX_BG_MR.draw(x + w - 13, y + 13, 13, h - 25, c);
        TEX_BG_MD.draw(x + 13, y + h - 13, w - 24, 13, c);
        TEX_BG_ML.draw(x, y + 13, 13, h - 25, c);
        TEX_BG_NN.draw(x, y, 13, 13, c);
        TEX_BG_NP.draw(x, y + h - 13, 13, 13, c);
        TEX_BG_PN.draw(x + w - 13, y, 13, 13, c);
        TEX_BG_PP.draw(x + w - 13, y + h - 13, 13, 13, c);
    };
    public final GuidePage pageTree;
    public final Panel panelPages;
    public final Panel panelText;
    public final Panel panelTitle;
    public final PanelScrollBar sliderPages;
    public final PanelScrollBar sliderText;
    private final Button buttonBack;
    public int panelWidth;
    private final List<ButtonSpecial> specialButtons;
    private GuidePage selectedPage;

    public GuiGuide(GuidePage tree) {
        super(0, 0);
        this.selectedPage = this.pageTree = tree;
        this.buttonBack = new Button(12, 12, 14, 11){

            @Override
            public void onClicked(GuiBase gui, IMouseButton button) {
                GuiHelper.playClickSound();
                GuiGuide.this.sliderPages.setValue(gui, 0.0);
                GuiGuide.this.sliderText.setValue(gui, 0.0);
                GuiGuide.this.setSelectedPage(((GuiGuide)GuiGuide.this).selectedPage.parent);
            }

            @Override
            public String getTitle(GuiBase gui) {
                return ((GuiGuide)GuiGuide.this).selectedPage.parent == null ? GuiLang.BUTTON_CLOSE.translate() : GuiLang.BUTTON_BACK.translate();
            }
        };
        this.buttonBack.setIcon(new ColoredObject((IDrawableObject)TEX_CLOSE, GuiConfigs.INFO_TEXT.getColor()));
        this.panelPages = new Panel(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                for (GuidePage c : ((GuiGuide)GuiGuide.this).selectedPage.childPages.values()) {
                    this.add(c.createWidget(GuiGuide.this));
                }
                GuiGuide.this.panelTitle.refreshWidgets();
            }

            @Override
            public void updateWidgetPositions() {
                if (!this.widgets.isEmpty()) {
                    GuiGuide.this.sliderPages.setElementSize(this.align(WidgetLayout.VERTICAL));
                }
            }
        };
        this.panelPages.addFlags(3);
        this.panelText = new Panel(0, 0, 0, 0){
            private final WidgetLayout LAYOUT;
            {
                this.LAYOUT = new WidgetLayout.Vertical(2, 0, 4);
            }

            @Override
            public void addWidgets() {
                for (Widget w : GuiGuide.this.panelPages.widgets) {
                    if (!(w instanceof ButtonGuidePage)) continue;
                    ((ButtonGuidePage)w).updateTitle(GuiGuide.this);
                }
                boolean uni = GuiGuide.this.getFont().func_82883_a();
                GuiGuide.this.getFont().func_78264_a(true);
                for (IGuideTextLine line : ((GuiGuide)GuiGuide.this).selectedPage.text) {
                    this.add(line == null ? new Widget(0, 0, GuiGuide.this.panelText.width, GuiGuide.this.getFont().field_78288_b + 1) : line.createWidget(GuiGuide.this, GuiGuide.this.panelText));
                }
                GuiGuide.this.getFont().func_78264_a(uni);
            }

            @Override
            public void updateWidgetPositions() {
                if (!this.widgets.isEmpty()) {
                    int s = this.align(this.LAYOUT);
                    GuiGuide.this.sliderText.setElementSize(s);
                    GuiGuide.this.sliderText.setSrollStepFromOneElementSize((s - 6) / this.widgets.size());
                }
            }
        };
        this.panelText.addFlags(7);
        this.panelTitle = new Panel(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                this.add(GuiGuide.this.buttonBack);
                GuiGuide.this.buttonBack.setIcon(new ColoredObject((IDrawableObject)(((GuiGuide)GuiGuide.this).selectedPage.parent == null ? TEX_CLOSE : TEX_BACK), GuiGuide.this.getContentColor()));
                GuiGuide.this.specialButtons.clear();
                for (SpecialGuideButton button : ((GuiGuide)GuiGuide.this).selectedPage.specialButtons) {
                    GuiGuide.this.specialButtons.add(new ButtonSpecial(button));
                }
                this.addAll(GuiGuide.this.specialButtons);
            }
        };
        this.sliderPages = new PanelScrollBar(0, 0, 12, 0, 18, this.panelPages);
        this.sliderPages.slider = TEX_SLIDER;
        this.sliderPages.background = ImageProvider.NULL;
        this.sliderText = new PanelScrollBar(0, 0, 12, 0, 18, this.panelText);
        this.sliderText.slider = TEX_SLIDER;
        this.sliderText.background = ImageProvider.NULL;
        this.specialButtons = new ArrayList<ButtonSpecial>();
    }

    public GuidePage getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(@Nullable GuidePage p) {
        this.sliderText.setValue(this, 0.0);
        if (this.selectedPage != p) {
            if (p == null) {
                this.mc.field_71439_g.func_71053_j();
                return;
            }
            this.selectedPage = p;
            if (p.childPages.isEmpty()) {
                this.panelText.refreshWidgets();
            } else {
                this.sliderPages.setValue(this, 0.0);
                this.refreshWidgets();
            }
        }
        this.panelTitle.refreshWidgets();
    }

    @Override
    public void addWidgets() {
        this.selectedPage.refreshGui(this);
        this.add(this.sliderText);
        this.add(this.panelPages);
        this.add(this.panelText);
        this.add(this.panelTitle);
        this.add(this.sliderPages);
        this.panelPages.setWidth(this.panelWidth - (this.sliderPages.isEnabled(this) ? 32 : 17));
        for (int i = 0; i < this.specialButtons.size(); ++i) {
            ButtonSpecial b = this.specialButtons.get(i);
            b.posX = this.panelWidth - 24 - 20 * i;
            b.posY = 10;
        }
    }

    @Override
    public void onInit() {
        this.posX = GuiConfigs.INFO_BORDER_WIDTH.getInt();
        this.posY = GuiConfigs.INFO_BORDER_HEIGHT.getInt();
        this.setWidth(this.getScreen().func_78326_a() - this.posX * 2);
        this.setHeight(this.getScreen().func_78328_b() - this.posY * 2);
        this.panelTitle.width = this.panelWidth = (int)((double)this.width * 0.3);
        this.panelTitle.height = 46;
        this.panelPages.posX = 10;
        this.panelPages.posY = 43;
        this.panelPages.setWidth(this.panelWidth - 17);
        this.panelPages.setHeight(this.height - 49);
        this.panelText.posX = this.panelWidth + 10;
        this.panelText.posY = 6;
        this.panelText.setWidth(this.width - this.panelWidth - 23 - this.sliderText.width);
        this.panelText.setHeight(this.height - 12);
        this.sliderPages.posX = this.panelWidth - this.sliderPages.width - 10;
        this.sliderPages.posY = 46;
        this.sliderPages.setHeight(this.height - 56);
        this.sliderText.posY = 10;
        this.sliderText.setHeight(this.height - 20);
        this.sliderText.posX = this.width - 10 - this.sliderText.width;
    }

    @Override
    public void drawBackground() {
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        FILLING.draw(this.posX + this.panelWidth, this.posY, this.width - this.panelWidth, this.height, Color4I.NONE);
        FILLING.draw(this.posX, this.posY + 36, this.panelWidth, this.height - 36, Color4I.NONE);
        FILLING.draw(this.posX, this.posY, this.panelWidth, 36, Color4I.NONE);
        GuiHelper.pushScissor(this.getScreen(), this.posX, this.posY, this.panelWidth, 36);
        this.drawString(this.selectedPage.getDisplayName().func_150254_d(), this.buttonBack.getAX() + this.buttonBack.width + 5, this.posY + 14);
        GuiHelper.popScissor();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawForeground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BORDERS.draw(this.posX + this.panelWidth, this.posY, this.width - this.panelWidth, this.height, Color4I.NONE);
        BORDERS.draw(this.posX, this.posY + 36, this.panelWidth, this.height - 36, Color4I.NONE);
        BORDERS.draw(this.posX, this.posY, this.panelWidth, 36, Color4I.NONE);
        super.drawForeground();
    }

    @Override
    public Color4I getContentColor() {
        return GuiConfigs.INFO_TEXT.getColor();
    }

    @Override
    public boolean drawDefaultBackground() {
        return false;
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    @Override
    public boolean changePage(String value) {
        GuidePage page = this.pageTree.getSubRaw(value);
        if (page != null) {
            if (page.parent != null) {
                this.setSelectedPage(page.parent);
            }
            this.setSelectedPage(page);
        }
        return false;
    }

    private static class ButtonSpecial
    extends Button {
        private final SpecialGuideButton specialInfoButton;

        public ButtonSpecial(SpecialGuideButton b) {
            super(0, 0, 16, 16);
            this.specialInfoButton = b;
            this.setTitle(this.specialInfoButton.title.func_150254_d());
        }

        @Override
        public void onClicked(GuiBase gui, IMouseButton button) {
            if (GuiHelper.onClickEvent(this.specialInfoButton.clickEvent)) {
                GuiHelper.playClickSound();
            }
        }

        @Override
        public void renderWidget(GuiBase gui) {
            this.specialInfoButton.icon.draw(this.getAX(), this.getAY(), this.width, this.height, Color4I.NONE);
        }
    }
}

