/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.config.PropertyBase;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;

public class PropertyInt
extends PropertyBase
implements IntSupplier {
    public static final String ID = "int";
    public static final Color4I COLOR = new Color4I(false, -5612824);
    private int value;
    private int minValue = Integer.MIN_VALUE;
    private int maxValue = Integer.MAX_VALUE;

    public static PropertyInt create(int defValue, int min, int max, final IntSupplier getter, final IntConsumer setter) {
        return new PropertyInt(defValue, min, max){

            @Override
            public int getInt() {
                return getter.getAsInt();
            }

            @Override
            public void setInt(int v) {
                setter.accept(v);
            }
        };
    }

    public PropertyInt() {
    }

    public PropertyInt(int v) {
        this.value = v;
    }

    public PropertyInt(int v, int min, int max) {
        this(v);
        this.minValue = min;
        this.maxValue = max;
    }

    public String func_176610_l() {
        return ID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.getInt();
    }

    public PropertyInt setMin(int v) {
        this.minValue = v;
        return this;
    }

    public PropertyInt setMax(int v) {
        this.maxValue = v;
        return this;
    }

    public int getMin() {
        return this.minValue;
    }

    public int getMax() {
        return this.maxValue;
    }

    public void setInt(int v) {
        this.value = MathHelper.func_76125_a((int)v, (int)this.getMin(), (int)this.getMax());
    }

    @Override
    public String getString() {
        return Integer.toString(this.getInt());
    }

    @Override
    public boolean getBoolean() {
        return this.getInt() != 0;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public IConfigValue copy() {
        return new PropertyInt(this.getInt(), this.getMin(), this.getMax());
    }

    @Override
    public boolean equalsValue(IConfigValue value) {
        return this.getInt() == value.getInt();
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public void addInfo(IConfigKey key, List<String> list) {
        super.addInfo(key, list);
        int m = this.getMin();
        if (m != Integer.MIN_VALUE) {
            list.add(TextFormatting.AQUA + "Min: " + m);
        }
        if ((m = this.getMax()) != Integer.MAX_VALUE) {
            list.add(TextFormatting.AQUA + "Max: " + m);
        }
    }

    @Override
    public boolean setValueFromString(String text, boolean simulate) {
        if (MathUtils.canParseInt(text)) {
            if (!simulate) {
                this.setInt(Integer.parseInt(text));
            }
            return true;
        }
        return false;
    }

    public void func_152753_a(JsonElement json) {
        this.setInt(json.getAsInt());
    }

    public JsonElement func_151003_a() {
        return new JsonPrimitive((Number)this.getInt());
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeInt(this.getInt());
        data.writeInt(this.getMin());
        data.writeInt(this.getMax());
    }

    @Override
    public void readData(ByteBuf data) {
        this.setInt(data.readInt());
        this.setMin(data.readInt());
        this.setMax(data.readInt());
    }

    @Override
    public int getAsInt() {
        return this.getInt();
    }
}

