/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.PropertyInt;
import io.netty.buffer.ByteBuf;

public class PropertyByte
extends PropertyInt {
    public static final String ID = "byte";
    private boolean unsigned = false;

    public PropertyByte() {
    }

    public PropertyByte(int v) {
        super(v);
    }

    public PropertyByte(int v, int min, int max) {
        super(v, min, max);
    }

    public PropertyByte(int v, int min, int max, boolean u) {
        this(v, min, max);
        this.unsigned = u;
    }

    public PropertyByte setUnsigned() {
        this.unsigned = true;
        return this;
    }

    @Override
    public void setInt(int v) {
        super.setInt(this.unsigned ? (byte)(v & 0xFF) : (byte)v);
    }

    @Override
    public String func_176610_l() {
        return ID;
    }

    @Override
    public IConfigValue copy() {
        return new PropertyByte(this.getInt(), this.getMin(), this.getMax(), this.unsigned);
    }

    @Override
    public void writeData(ByteBuf data) {
        data.writeBoolean(this.unsigned);
        data.writeByte(this.getInt());
        data.writeByte(this.getMin());
        data.writeByte(this.getMax());
    }

    @Override
    public void readData(ByteBuf data) {
        this.unsigned = data.readBoolean();
        this.setInt(this.unsigned ? data.readUnsignedByte() : (short)data.readByte());
        this.setMin(this.unsigned ? data.readUnsignedByte() : (short)data.readByte());
        this.setMax(this.unsigned ? data.readUnsignedByte() : (short)data.readByte());
    }
}

