/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.config;

import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.config.SimpleConfigKey;

public class ConfigKey
extends SimpleConfigKey {
    private final IConfigValue defValue;
    private int flags;
    private String displayNameLangKey;
    private String infoLangKey = "";
    private String group = "";

    public ConfigKey(String id, IConfigValue def, String dn) {
        super(id);
        this.defValue = def;
        this.displayNameLangKey = dn;
    }

    public ConfigKey(String id, IConfigValue def, String group, String prefix) {
        this(group.isEmpty() ? id : group + "." + id, def);
        this.setGroup(group);
        this.setNameLangKey(prefix + "." + this.func_176610_l() + ".name");
        this.setInfoLangKey(prefix + "." + this.func_176610_l() + ".info");
    }

    public ConfigKey(String id, IConfigValue def) {
        this(id, def, "");
    }

    @Override
    public ConfigKey setNameLangKey(String key) {
        this.displayNameLangKey = key;
        return this;
    }

    @Override
    public ConfigKey setInfoLangKey(String key) {
        this.infoLangKey = key;
        return this;
    }

    @Override
    public ConfigKey setGroup(String g) {
        this.group = g;
        return this;
    }

    @Override
    public IConfigValue getDefValue() {
        return this.defValue;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public ConfigKey setFlags(int f) {
        this.flags = f;
        return this;
    }

    @Override
    public ConfigKey addFlags(int f) {
        this.flags |= f;
        return this;
    }

    @Override
    public String getNameLangKey() {
        return this.displayNameLangKey;
    }

    @Override
    public String getInfoLangKey() {
        return this.infoLangKey;
    }

    @Override
    public String getGroup() {
        return this.group;
    }
}

