/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.cmd;

import com.feed_the_beast.ftbl.api.config.IConfigContainer;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.config.SimpleConfigKey;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class CmdEditConfigBase
extends CmdBase {
    public CmdEditConfigBase(String n, CmdBase.Level l) {
        super(n, l);
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        try {
            List<String> variants;
            IConfigValue entry;
            Map<IConfigKey, IConfigValue> map = this.getConfigContainer(sender).getConfigTree().getTree();
            if (args.length == 1) {
                ArrayList<Object> keys = new ArrayList<Object>();
                keys.addAll(map.keySet());
                keys.sort(StringUtils.ID_COMPARATOR);
                return CmdEditConfigBase.func_175762_a((String[])args, keys);
            }
            if (args.length == 2 && (entry = map.get(new SimpleConfigKey(args[0]))) != null && !(variants = entry.getVariants()).isEmpty()) {
                return CmdEditConfigBase.func_175762_a((String[])args, variants);
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayerMP) {
            FTBLibIntegrationInternal.API.editServerConfig(CmdEditConfigBase.func_71521_c((ICommandSender)sender), null, this.getConfigContainer(sender));
            return;
        }
        CmdEditConfigBase.checkArgs(args, 1, "[ID] [value]");
        IConfigContainer cc = this.getConfigContainer(sender);
        IConfigTree tree = cc.getConfigTree();
        IConfigKey key = tree.getKey(args[0]);
        if (key == null) {
            throw FTBLibLang.RAW.commandError("Can't find config entry '" + args[0] + "'!");
        }
        IConfigValue entry = tree.get(key);
        if (args.length >= 2) {
            String json = String.valueOf(StringUtils.joinSpaceUntilEnd(1, args));
            FTBLibFinals.LOGGER.info("Setting " + args[0] + " to " + json);
            try {
                JsonElement value = JsonUtils.fromJson(JsonUtils.fixJsonString(json));
                sender.func_145747_a(new TextComponentString("'").func_150257_a((ITextComponent)new TextComponentTranslation(key.getNameLangKey(), new Object[0])).func_150258_a("' set to " + value));
                JsonObject json1 = new JsonObject();
                json1.add(args[0], value);
                cc.saveConfig(sender, null, json1);
                return;
            }
            catch (Exception ex) {
                throw FTBLibLang.RAW.commandError(ex.toString());
            }
        }
        sender.func_145747_a((ITextComponent)new TextComponentString(String.valueOf(entry.func_151003_a())));
    }

    public abstract IConfigContainer getConfigContainer(ICommandSender var1) throws CommandException;
}

