/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DrawableObjectList
implements IDrawableObject {
    public final List<IDrawableObject> list;
    private IDrawableObject current = ImageProvider.NULL;
    public long timer = 1000L;

    public DrawableObjectList(Collection<IDrawableObject> l) {
        if (l.contains(null) || l.contains(ImageProvider.NULL)) {
            this.list = new ArrayList<IDrawableObject>();
            for (IDrawableObject o : l) {
                if (o == null || o == ImageProvider.NULL) continue;
                this.list.add(o);
            }
        } else {
            this.list = new ArrayList<IDrawableObject>(l);
        }
        if (!this.list.isEmpty()) {
            this.current = this.list.get(0);
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    public IDrawableObject getObject(int index) {
        if (index < 0 || index >= this.list.size()) {
            return this.current;
        }
        return this.list.get(index);
    }

    public void setIndex(int i) {
        this.current = this.list.get(MathUtils.wrap(i, this.list.size()));
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        if (this.current != null) {
            this.current.draw(x, y, w, h, col);
        }
        if (!this.list.isEmpty()) {
            this.setIndex((int)(System.currentTimeMillis() / this.timer));
        }
    }
}

