/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib.client;

import com.feed_the_beast.ftbl.api.gui.IDrawableObject;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.renderer.GlStateManager;

public class ColoredObject
implements IDrawableObject {
    public final IDrawableObject parent;
    public final Color4I color;

    public ColoredObject(IDrawableObject p, Color4I c) {
        this.parent = p;
        this.color = c;
    }

    public ColoredObject(IDrawableObject p, int c) {
        this(p, new Color4I(true, c));
    }

    @Override
    public void draw(int x, int y, int w, int h, Color4I col) {
        Color4I col1;
        Color4I color4I = col1 = col.hasColor() ? col : this.color;
        if (this.parent == ImageProvider.NULL) {
            GuiHelper.drawBlankRect(x, y, w, h, col1);
        } else {
            this.parent.draw(x, y, w, h, col1);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public JsonObject getJson() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive("colored"));
        if (this.color.hasColor()) {
            o.add("color", ColorUtils.serialize(this.color.rgba()));
            if (this.color.alpha() != 255) {
                o.add("color_alpha", (JsonElement)new JsonPrimitive((Number)this.color.alpha()));
            }
        }
        o.add("parent", this.parent.getJson());
        return o;
    }
}

