/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;

public final class EnumNameMap<E extends Enum<E>> {
    public static final String NULL_VALUE = "-";
    public final int size;
    private final Map<String, E> map;
    private final List<String> keys;
    private final List<E> values;
    private final E defaultValue;

    public EnumNameMap(E[] v, boolean addNull, @Nullable E def) {
        ArrayList<E> list = new ArrayList<E>();
        for (E e : v) {
            if (e == null) continue;
            list.add(e);
        }
        if (addNull) {
            list.add(null);
        }
        this.values = Collections.unmodifiableList(list);
        this.size = this.values.size();
        LinkedHashMap<String, Enum> map1 = new LinkedHashMap<String, Enum>(this.size);
        for (Enum e : this.values) {
            map1.put(EnumNameMap.getName(e), e);
        }
        this.map = Collections.unmodifiableMap(map1);
        this.keys = Collections.unmodifiableList(new ArrayList<String>(this.map.keySet()));
        this.defaultValue = def;
    }

    public EnumNameMap(E[] v, boolean addNull) {
        this((Enum[])v, addNull, null);
    }

    public static String getName(@Nullable Object o) {
        if (o == null) {
            return NULL_VALUE;
        }
        if (o instanceof IStringSerializable) {
            return ((IStringSerializable)o).func_176610_l();
        }
        return (o instanceof Enum ? ((Enum)o).name() : o.toString()).toLowerCase();
    }

    @Nullable
    public E get(@Nullable String s) {
        if (s == null || s.isEmpty() || s.charAt(0) == '-') {
            return this.defaultValue;
        }
        Enum e = (Enum)this.map.get(s);
        return (E)(e == null ? this.defaultValue : e);
    }

    @Nullable
    public E getFromIndex(int index) {
        return (E)((Enum)this.values.get(index));
    }

    public int getIndex(@Nullable Object e) {
        return this.values.indexOf(e);
    }

    public int getStringIndex(String s) {
        return this.getIndex(this.map.get(s));
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<E> getValues() {
        return this.values;
    }

    @Nullable
    public E getDefaultValue() {
        return this.defaultValue;
    }
}

