/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.lib;

import com.feed_the_beast.ftbl.lib.util.ColorUtils;
import com.google.gson.JsonElement;
import net.minecraft.util.math.MathHelper;

public final class Color4I {
    public static final Color4I NONE = new Color4I(false, 0);
    public static final Color4I BLACK = new Color4I(false, -16777216);
    public static final Color4I DARK_GRAY = new Color4I(false, -14606047);
    public static final Color4I GRAY = new Color4I(false, -6710887);
    public static final Color4I WHITE = new Color4I(false, -1);
    public static final Color4I WHITE_A33 = new Color4I(false, 0x21FFFFFF);
    public static final Color4I RED = new Color4I(false, -65536);
    public static final Color4I LIGHT_RED = new Color4I(false, -43434);
    private final boolean canEdit;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int alpha = 255;
    private int rgba = -1;

    public Color4I(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public Color4I(boolean canEdit, int r, int g, int b, int a) {
        this.canEdit = canEdit;
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
        this.rgba = ColorUtils.getRGBA(this.red, this.green, this.blue, this.alpha);
    }

    public Color4I(boolean canEdit, int rgba) {
        this.canEdit = canEdit;
        this.red = ColorUtils.getRed(rgba);
        this.green = ColorUtils.getGreen(rgba);
        this.blue = ColorUtils.getBlue(rgba);
        this.alpha = ColorUtils.getAlpha(rgba);
        this.rgba = rgba;
    }

    public Color4I(boolean canEdit, Color4I col, int a) {
        this(canEdit, col.red, col.green, col.blue, a);
    }

    public Color4I(boolean canEdit, Color4I col) {
        this(canEdit, col, col.alpha);
    }

    public boolean canEdit() {
        return this.canEdit;
    }

    public void set(int r, int g, int b, int a) {
        if (this.canEdit) {
            this.red = r;
            this.green = g;
            this.blue = b;
            this.alpha = a;
            this.rgba = ColorUtils.getRGBA(this.red, this.green, this.blue, this.alpha);
        }
    }

    public void set(Color4I col, int a) {
        if (this.canEdit) {
            this.set(col.red, col.green, col.blue, a);
        }
    }

    public void set(Color4I col) {
        if (this.canEdit) {
            this.set(col, col.alpha);
        }
    }

    public void set(int col, int a) {
        if (this.canEdit) {
            this.set(ColorUtils.getRed(col), ColorUtils.getGreen(col), ColorUtils.getBlue(col), a);
        }
    }

    public void set(int col) {
        if (this.canEdit) {
            this.set(col, ColorUtils.getAlpha(col));
        }
    }

    public int red() {
        return this.red;
    }

    public int green() {
        return this.green;
    }

    public int blue() {
        return this.blue;
    }

    public int alpha() {
        return this.alpha;
    }

    public float redf() {
        return (float)this.red / 255.0f;
    }

    public float greenf() {
        return (float)this.green / 255.0f;
    }

    public float bluef() {
        return (float)this.blue / 255.0f;
    }

    public float alphaf() {
        return (float)this.alpha / 255.0f;
    }

    public int rgba() {
        return this.rgba;
    }

    public boolean hasColor() {
        return this.alpha > 0;
    }

    public int hashCode() {
        return this.rgba();
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.hashCode() == this.rgba();
    }

    public String toString() {
        return ColorUtils.getHex(this.rgba());
    }

    public JsonElement toJson() {
        return ColorUtils.serialize(this.rgba());
    }

    public void addBrightness(int b) {
        if (this.canEdit) {
            this.set(MathHelper.func_76125_a((int)(this.red + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.green + b), (int)0, (int)255), MathHelper.func_76125_a((int)(this.blue + b), (int)0, (int)255), this.alpha);
        }
    }

    public void setFromHSB(float h, float s, float b) {
        if (!this.canEdit) {
            return;
        }
        this.blue = 0;
        this.green = 0;
        this.red = 0;
        if (s == 0.0f) {
            this.green = this.blue = (int)(b * 255.0f + 0.5f);
            this.red = this.blue;
        } else {
            float h6 = (h - (float)MathHelper.func_76141_d((float)h)) * 6.0f;
            float f = h6 - (float)MathHelper.func_76141_d((float)h6);
            float p = b * (1.0f - s);
            float q = b * (1.0f - s * f);
            float t = b * (1.0f - s * (1.0f - f));
            switch ((int)h6) {
                case 0: {
                    this.red = (int)(b * 255.0f + 0.5f);
                    this.green = (int)(t * 255.0f + 0.5f);
                    this.blue = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    this.red = (int)(q * 255.0f + 0.5f);
                    this.green = (int)(b * 255.0f + 0.5f);
                    this.blue = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    this.red = (int)(p * 255.0f + 0.5f);
                    this.green = (int)(b * 255.0f + 0.5f);
                    this.blue = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    this.red = (int)(p * 255.0f + 0.5f);
                    this.green = (int)(q * 255.0f + 0.5f);
                    this.blue = (int)(b * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    this.red = (int)(t * 255.0f + 0.5f);
                    this.green = (int)(p * 255.0f + 0.5f);
                    this.blue = (int)(b * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    this.red = (int)(b * 255.0f + 0.5f);
                    this.green = (int)(p * 255.0f + 0.5f);
                    this.blue = (int)(q * 255.0f + 0.5f);
                }
            }
        }
    }
}

