/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.lib.Color4I;
import com.feed_the_beast.ftbl.lib.client.ImageProvider;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ClientNotifications {
    private static Temp current;

    static boolean shouldRenderTemp() {
        return current != null || !Temp.MAP.isEmpty();
    }

    static void renderTemp(ScaledResolution screen) {
        if (current != null) {
            if (current.render(screen)) {
                current = null;
            }
        } else if (!Temp.MAP.isEmpty()) {
            current = new Temp((INotification)Temp.MAP.values().iterator().next());
            Temp.MAP.remove(((Temp)ClientNotifications.current).widget.notification.getId().getID());
        }
    }

    public static void add(INotification n) {
        ResourceLocation id = n.getId().getID();
        Temp.MAP.remove(id);
        if (current != null && ((Temp)ClientNotifications.current).widget.notification.getId().equals(n.getId())) {
            current = null;
        }
        Temp.MAP.put(id, n);
    }

    public static void init() {
        current = null;
        Temp.MAP.clear();
    }

    private static class Temp {
        private static final LinkedHashMap<ResourceLocation, INotification> MAP = new LinkedHashMap();
        private static Minecraft mc = Minecraft.func_71410_x();
        private long time;
        private NotificationWidget widget;

        private Temp(INotification n) {
            this.widget = new NotificationWidget(n, Temp.mc.field_71466_p);
            this.time = -1L;
        }

        public boolean render(ScaledResolution screen) {
            if (this.time == -1L) {
                this.time = System.currentTimeMillis();
            } else if (this.time <= 0L) {
                return true;
            }
            int timeExisted = (int)(System.currentTimeMillis() - this.time);
            int timer = this.widget.notification.getTimer() & 0xFFFF;
            if (timeExisted > timer) {
                this.time = 0L;
                return true;
            }
            double d1 = 1.0;
            if (timer - timeExisted < 300) {
                d1 = (double)(timer - timeExisted) / 300.0;
            }
            if (timeExisted < 300) {
                d1 = (double)timeExisted / 300.0;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            this.widget.render(mc, screen.func_78326_a() - this.widget.width - 4, (int)(d1 * (double)this.widget.height) - this.widget.height);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            return false;
        }
    }

    public static class NotificationWidget {
        public final INotification notification;
        public final List<String> text;
        public final int height;
        public int width;

        public NotificationWidget(INotification n, FontRenderer font) {
            this.notification = n;
            this.width = 0;
            if (this.notification.getText().isEmpty()) {
                this.text = Collections.emptyList();
            } else {
                this.text = new ArrayList<String>();
                for (ITextComponent c : this.notification.getText()) {
                    for (String s : font.func_78271_c(c.func_150254_d(), 250)) {
                        this.text.add(s);
                        this.width = Math.max(this.width, font.func_78256_a(s));
                    }
                }
            }
            this.width += 20;
            if (this.notification.getIcon() != ImageProvider.NULL) {
                this.width = this.text.isEmpty() ? 32 : (this.width += 20);
            }
            this.height = this.text.size() > 2 ? 4 + this.text.size() * 12 : 32;
        }

        public void render(Minecraft mc, int ax, int ay) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiHelper.drawBlankRect(ax, ay, this.width, this.height, this.notification.getColor());
            if (this.notification.getIcon() != ImageProvider.NULL) {
                this.notification.getIcon().draw(ax + 8, ay + (this.height - 16) / 2, 16, 16, Color4I.NONE);
            }
            for (int i = 0; i < this.text.size(); ++i) {
                mc.field_71466_p.func_78276_b(this.text.get(i), ax + (this.notification.getIcon() != ImageProvider.NULL ? 30 : 10), ay + i * 11 + (this.height - this.text.size() * 10) / 2, -1);
            }
        }
    }
}

