/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api_impl;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerDeathEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerLoggedOutEvent;
import com.feed_the_beast.ftbl.api.events.player.ForgePlayerSettingsEvent;
import com.feed_the_beast.ftbl.api_impl.ForgeTeam;
import com.feed_the_beast.ftbl.api_impl.Universe;
import com.feed_the_beast.ftbl.lib.NBTDataStorage;
import com.feed_the_beast.ftbl.lib.config.ConfigTree;
import com.feed_the_beast.ftbl.lib.config.PropertyBool;
import com.feed_the_beast.ftbl.lib.internal.FTBLibStats;
import com.feed_the_beast.ftbl.lib.io.Bits;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.feed_the_beast.ftbl.lib.util.NBTUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.net.MessageLogin;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ForgePlayer
implements IForgePlayer,
Comparable<ForgePlayer> {
    private static FakePlayer playerForStats;
    private final UUID playerId;
    private String playerName;
    private final NBTDataStorage dataStorage;
    private ForgeTeam team = null;
    private final PropertyBool hideTeamNotification;
    private final PropertyBool hideNewTeamMsgNotification;
    private EntityPlayerMP entityPlayer;
    private NBTTagCompound playerNBT;
    private final IConfigTree cachedConfig;
    private boolean loggingOut;

    public ForgePlayer(UUID id, String name) {
        this.playerId = id;
        this.playerName = name;
        this.dataStorage = FTBLibMod.PROXY.createDataStorage(this, FTBLibModCommon.DATA_PROVIDER_PLAYER);
        this.hideTeamNotification = new PropertyBool();
        this.hideNewTeamMsgNotification = new PropertyBool();
        this.cachedConfig = new ConfigTree();
        ForgePlayerSettingsEvent event = new ForgePlayerSettingsEvent(this, this.cachedConfig);
        MinecraftForge.EVENT_BUS.post((Event)event);
        String group = "ftbl";
        event.add(group, "hide_team_notification", this.hideTeamNotification);
        event.add(group, "hide_new_team_msg_notification", this.hideNewTeamMsgNotification);
    }

    @Override
    public final void setTeamID(String id) {
        this.team = Universe.INSTANCE.getTeam(id);
    }

    @Override
    @Nullable
    public final ForgeTeam getTeam() {
        if (this.team != null && !this.team.isValid()) {
            return null;
        }
        return this.team;
    }

    @Override
    public final GameProfile getProfile() {
        if (this.isOnline()) {
            return this.entityPlayer.func_146103_bH();
        }
        return new GameProfile(this.playerId, this.playerName);
    }

    @Override
    public final UUID getId() {
        return this.playerId;
    }

    @Override
    public final String getName() {
        return this.playerName;
    }

    public final void setUsername(String n) {
        this.playerName = n;
    }

    @Override
    @Nullable
    public INBTSerializable<?> getData(ResourceLocation id) {
        return this.dataStorage == null ? null : this.dataStorage.get(id);
    }

    @Override
    public final int compareTo(ForgePlayer o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public final String toString() {
        return this.playerName;
    }

    public final int hashCode() {
        return this.playerId.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this || o == this.playerId) {
            return true;
        }
        if (o instanceof UUID) {
            return this.playerId.equals(o);
        }
        if (o instanceof IForgePlayer) {
            return this.equalsPlayer((IForgePlayer)o);
        }
        return this.equalsPlayer(Universe.INSTANCE.getPlayer(o));
    }

    @Override
    public boolean equalsPlayer(@Nullable IForgePlayer p) {
        return p == this || p != null && this.getId().equals(p.getId());
    }

    @Override
    public boolean isOnline() {
        return this.entityPlayer != null;
    }

    @Override
    public EntityPlayerMP getPlayer() {
        Preconditions.checkNotNull((Object)this.entityPlayer, (Object)"EntityPlayer can't be null!");
        return this.entityPlayer;
    }

    @Override
    public boolean isFake() {
        return this.entityPlayer instanceof FakePlayer;
    }

    @Override
    public boolean isOP() {
        return ServerUtils.isOP(this.getProfile());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Flags")) {
            int flags = nbt.func_74762_e("Flags");
            this.hideTeamNotification.setBoolean(Bits.getFlag(flags, 1));
            this.hideNewTeamMsgNotification.setBoolean(Bits.getFlag(flags, 2));
        } else {
            this.hideTeamNotification.setBoolean(nbt.func_74767_n("HideTeamNotification"));
            this.hideNewTeamMsgNotification.setBoolean(nbt.func_74767_n("HideNewTeamMsgNotification"));
        }
        this.setTeamID(nbt.func_74779_i("TeamID"));
        if (this.dataStorage != null) {
            this.dataStorage.deserializeNBT(nbt.func_74764_b("Caps") ? nbt.func_74775_l("Caps") : nbt.func_74775_l("Data"));
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("HideTeamNotification", this.hideTeamNotification.getBoolean());
        nbt.func_74757_a("HideNewTeamMsgNotification", this.hideNewTeamMsgNotification.getBoolean());
        if (this.team != null && this.team.isValid()) {
            nbt.func_74778_a("TeamID", this.team.func_176610_l());
        }
        if (this.dataStorage != null) {
            nbt.func_74782_a("Data", (NBTBase)this.dataStorage.serializeNBT());
        }
        return nbt;
    }

    public void onLoggedIn(EntityPlayerMP ep, boolean firstLogin) {
        this.entityPlayer = ep;
        this.playerNBT = null;
        this.loggingOut = false;
        if (!this.isFake()) {
            FTBLibStats.updateLastSeen(this.stats());
            new MessageLogin(ep, this).sendTo((EntityPlayer)this.entityPlayer);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerLoggedInEvent(this, firstLogin));
    }

    public void onLoggedOut() {
        this.loggingOut = true;
        FTBLibStats.updateLastSeen(this.stats());
        MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerLoggedOutEvent(this));
        this.entityPlayer = null;
        this.playerNBT = null;
    }

    public void onDeath(EntityPlayerMP ep, DamageSource ds) {
        this.entityPlayer = ep;
        if (this.isOnline()) {
            FTBLibStats.updateLastSeen(this.stats());
            MinecraftForge.EVENT_BUS.post((Event)new ForgePlayerDeathEvent(this, ds));
        }
    }

    @Override
    public StatisticsManagerServer stats() {
        if (playerForStats == null) {
            playerForStats = new FakePlayer(ServerUtils.getServerWorld(), new GameProfile(new UUID(0L, 0L), "_unknown"));
        }
        playerForStats.func_184221_a(this.getId());
        return ServerUtils.getServer().func_184103_al().func_152602_a((EntityPlayer)playerForStats);
    }

    @Override
    public IConfigTree getSettings() {
        return this.cachedConfig;
    }

    @Override
    public NBTTagCompound getPlayerNBT() {
        if (this.isOnline()) {
            return this.getPlayer().serializeNBT();
        }
        if (this.playerNBT == null) {
            try {
                this.playerNBT = NBTUtils.readTag(new File(LMUtils.folderWorld, "playerdata/" + this.getId() + ".dat"));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.playerNBT;
    }

    @Override
    public boolean hideTeamNotification() {
        return this.hideTeamNotification.getBoolean();
    }

    @Override
    public boolean hideNewTeamMsgNotification() {
        return this.hideNewTeamMsgNotification.getBoolean();
    }

    public void setLoggingOut(boolean v) {
        this.loggingOut = v;
    }

    @Override
    public boolean isLoggingOut() {
        return this.loggingOut;
    }
}

