/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.model.parsing;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import team.chisel.ctm.api.model.IModelCTM;
import team.chisel.ctm.api.model.IModelParser;
import team.chisel.ctm.client.model.ModelCTM;

public class ModelParserV1
implements IModelParser {
    private static final Deque<ResourceLocation> _loadingModels = (Deque)ReflectionHelper.getPrivateValue(ModelLoaderRegistry.class, null, (String[])new String[]{"loadingModels"});
    private static final Gson GSON = new Gson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public IModelCTM fromJson(ResourceLocation res, JsonObject json) {
        IModel vanillamodel;
        ModelBlock modelinfo = ModelBlock.func_178294_a((String)json.toString());
        ResourceLocation prev = _loadingModels.removeLast();
        try {
            vanillamodel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(res.func_110624_b(), res.func_110623_a().replace("models/", "")));
        }
        catch (IllegalStateException e) {
            IModel parent = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(json.get("parent").getAsString()));
            if (!(parent instanceof IModelCTM)) throw new IllegalStateException("CTM model " + res + " cannot have non-CTM parent " + json.get("parent"));
            IModelCTM iModelCTM = (IModelCTM)parent;
            return iModelCTM;
        }
        finally {
            _loadingModels.addLast(prev);
        }
        Map parsed = (Map)GSON.fromJson((JsonElement)json.getAsJsonObject("ctm_overrides"), new TypeToken<Map<String, JsonElement>>(){}.getType());
        if (parsed == null) {
            parsed = Collections.emptyMap();
        }
        Int2ObjectArrayMap replacements = new Int2ObjectArrayMap(parsed.size());
        Iterator iterator = parsed.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            try {
                int index = Integer.parseInt((String)e.getKey());
                replacements.put(index, e.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ModelCTM(modelinfo, vanillamodel, (Int2ObjectMap<JsonElement>)replacements);
    }
}

