/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.core;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.core.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModRecipes {
    public static ItemStack makeBasicDrawerItemStack(EnumBasicDrawer info, String material, int count) {
        ItemStack stack = new ItemStack((Block)ModBlocks.extraDrawers, count, info.getMetadata());
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("material", material);
        stack.func_77982_d(data);
        return stack;
    }

    public void init() {
        ConfigManager config = StorageDrawers.config;
        ConfigManagerExt configExt = StorageDrawersExtra.config;
        for (EnumVariant variant : EnumVariant.values()) {
            ItemStack result;
            Block block;
            Block block2;
            EnumMod mod;
            if (variant == EnumVariant.DEFAULT || (mod = variant.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod))) continue;
            ItemStack plankStack = null;
            if (variant.getPlankResource() != null && (block2 = Block.func_149684_b((String)variant.getPlankResource().toString())) != null) {
                plankStack = new ItemStack(block2, 1, variant.getPlankMeta());
            }
            ItemStack slabStack = null;
            if (variant.getSlabResource() != null && (block = Block.func_149684_b((String)variant.getSlabResource().toString())) != null) {
                slabStack = new ItemStack(block, 1, variant.getSlabMeta());
            }
            String material = variant.getResource().toString();
            if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName()) && plankStack != null) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName()) && plankStack != null) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName()) && plankStack != null) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, material, config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), plankStack, Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName()) && slabStack != null) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, material, config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}));
            }
            if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName()) && slabStack != null) {
                result = ModRecipes.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, material, config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), slabStack, Character.valueOf('y'), "chestWood"}));
            }
            if (!config.isBlockEnabled("trim") || plankStack == null) continue;
            result = new ItemStack((Block)ModBlocks.extraTrim[variant.getGroupIndex()], config.getBlockRecipeOutput("trim"), variant.getGroupMeta());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(result, new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), plankStack}));
        }
    }
}

