/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.core.ModCreativeTabs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockTrimExtra
extends Block
implements INetworked {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)15);
    public static final IUnlistedProperty<EnumVariant> VARIANT = new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"variant", EnumVariant.class));
    private final int group;

    public BlockTrimExtra(String blockName, int group) {
        super(Material.field_151575_d);
        this.group = group;
        this.func_149663_c(blockName);
        this.setRegistryName(blockName);
        this.func_149711_c(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
    }

    public int getGroup() {
        return this.group;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, true);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack dropStack = new ItemStack(Item.func_150898_a((Block)this), 1, state.func_177230_c().func_176201_c(state));
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(dropStack);
        return drops;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        ConfigManagerExt configExt = StorageDrawersExtra.config;
        for (EnumVariant variant : EnumVariant.values()) {
            EnumMod mod;
            if (variant == EnumVariant.DEFAULT || (mod = variant.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod)) || this.group != variant.getGroupIndex()) continue;
            list.add(new ItemStack(item, 1, variant.getGroupMeta()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((state = this.func_176221_a(state, world, pos)) instanceof IExtendedBlockState)) {
            return state;
        }
        return ((IExtendedBlockState)state).withProperty(VARIANT, (Object)EnumVariant.byGroupMeta(this.group, (Integer)state.func_177229_b((IProperty)META)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{META}, new IUnlistedProperty[]{VARIANT});
    }
}

