/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawersextra.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockStandardDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawersextra.StorageDrawersExtra;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumMod;
import com.jaquadro.minecraft.storagedrawersextra.block.EnumVariant;
import com.jaquadro.minecraft.storagedrawersextra.config.ConfigManagerExt;
import com.jaquadro.minecraft.storagedrawersextra.core.ModCreativeTabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockExtraDrawers
extends BlockStandardDrawers {
    public static final IUnlistedProperty<EnumVariant> VARIANT = new Properties.PropertyAdapter((IProperty)PropertyEnum.func_177709_a((String)"variant", EnumVariant.class));

    public BlockExtraDrawers(String blockName) {
        super(blockName);
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
    }

    protected ItemStack getMainDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        IBlockState extended;
        ItemStack drop = super.getMainDrop(world, pos, state);
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return drop;
        }
        NBTTagCompound data = drop.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        if ((extended = this.getExtendedState(state, world, pos)) instanceof IExtendedBlockState) {
            EnumVariant variant = (EnumVariant)((Object)((IExtendedBlockState)extended).getValue(VARIANT));
            data.func_74778_a("material", variant.func_176610_l());
        }
        drop.func_77982_d(data);
        return drop;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        ConfigManagerExt configExt = StorageDrawersExtra.config;
        for (EnumBasicDrawer type : EnumBasicDrawer.values()) {
            for (EnumVariant material : EnumVariant.values()) {
                EnumMod mod;
                if (material == EnumVariant.DEFAULT || (mod = material.getMod()) == null || !mod.isEnabled(configExt.getModToggleState(mod))) continue;
                ItemStack stack = new ItemStack(item, 1, type.getMetadata());
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("material", material.getResource().toString());
                stack.func_77982_d(data);
                list.add(stack);
            }
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((state = this.func_176221_a(state, world, pos)) instanceof IExtendedBlockState)) {
            return state;
        }
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        if (tile == null) {
            return state;
        }
        return ((IExtendedBlockState)super.getExtendedState(state, world, pos)).withProperty(VARIANT, (Object)this.translateMaterial(tile.getMaterialOrDefault()));
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BLOCK, FACING}, new IUnlistedProperty[]{VARIANT, STATE_MODEL});
    }

    private EnumVariant translateMaterial(String materal) {
        for (EnumVariant type : EnumVariant.values()) {
            if (!materal.equals(type.getResource().toString())) continue;
            return type;
        }
        return EnumVariant.DEFAULT;
    }
}

