/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.wire;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IRedstoneConductor;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.component.wire.ComponentWirePostBase;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ComponentRedstonePostBundled
extends ComponentWirePostBase {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "post_rs_bundled");
    private byte[] power = new byte[16];
    private boolean shouldOutputPower = true;
    private boolean shouldPropagate = true;

    public ComponentRedstonePostBundled(ICircuit circuit) {
        super(circuit);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.009000001f;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public boolean isBundled() {
        return true;
    }

    @Override
    public EnumDyeColor getColor() {
        return null;
    }

    @Override
    public boolean isColorBiased() {
        return true;
    }

    @Override
    public byte getInput(EnumDyeColor color) {
        if (!this.shouldPropagate) {
            return 0;
        }
        int input = 0;
        Pair<IComponent, EnumComponentSlot> neighbor = this.getNeighborPair(EnumComponentSlot.CENTER, EnumCircuitSide.TOP);
        if (neighbor != null && !(neighbor.getKey() instanceof IRedstoneConductor)) {
            input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), EnumCircuitSide.BOTTOM, color, true) & 0xFF);
        }
        if ((neighbor = this.getNeighborPair(EnumComponentSlot.CENTER, EnumCircuitSide.BOTTOM)) != null && !(neighbor.getKey() instanceof IRedstoneConductor)) {
            input = Math.max(input, ((IComponent)neighbor.getKey()).getOutputSignal((EnumComponentSlot)((Object)neighbor.getValue()), EnumCircuitSide.TOP, color, true) & 0xFF);
        }
        return (byte)input;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return bundled && this.shouldOutputPower && this.isOutput(slot, side) && this.cond.getNeighbors()[side.ordinal()].getNeighbor() == null ? this.power[color.ordinal()] : (byte)0;
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side == EnumCircuitSide.TOP;
    }

    @Override
    public void propagate(IRedstoneConductor from, EnumDyeColor color, Multimap<IRedstoneConductor, EnumDyeColor> wires, Set<Triple<IRedstoneConductor, IRedstoneConductor, EnumDyeColor>> scheduled) {
        if (this.shouldPropagate) {
            super.propagate(from, color, wires, scheduled);
        }
    }

    @Override
    public void onPropagated(Set<EnumDyeColor> colors, byte power) {
        boolean update = false;
        for (EnumDyeColor c : colors) {
            if (this.power[c.ordinal()] == power) continue;
            this.power[c.ordinal()] = power;
            update = true;
        }
        if (update) {
            super.onPropagated(colors, power);
            this.getCircuit().markDirty();
            this.getCircuit().notifyUpdate(this.getPos(), this.getSlot(), this.cond.getNeighbors()[EnumCircuitSide.BOTTOM.ordinal()].getNeighbor() == null ? EnumCircuitSide.BOTTOM : null, this.cond.getNeighbors()[EnumCircuitSide.TOP.ordinal()].getNeighbor() == null ? EnumCircuitSide.TOP : null);
        }
    }

    @Override
    public boolean connect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type, boolean simulated) {
        return side.face.func_176740_k() == EnumFacing.Axis.Y && super.connect(side, conductor, type, simulated);
    }

    @Override
    public void onConnect(EnumCircuitSide side, IRedstoneConductor conductor, IRedstoneConductor.EnumConnectionType type) {
        this.getCircuit().markDirty();
    }

    @Override
    public void onDisconnect(EnumCircuitSide side) {
        this.getCircuit().markDirty();
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.BUNDLED_STICK.ordinal());
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        super.addSelectionBoxes(boxes);
        double d = 0.3125;
        boxes.add(new AxisAlignedBB(d, 0.0, d, 1.0 - d, 1.0, 1.0 - d));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74773_a("power", this.power);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74770_j("power");
    }

    @Override
    public void debug(EntityPlayer player) {
        StringBuilder power = new StringBuilder("Power: [");
        for (byte b : this.power) {
            power.append((b & 0xFF) + ", ");
        }
        power.reverse().delete(0, 2).reverse().append("]");
        player.func_145747_a((ITextComponent)new TextComponentString(power.toString()));
    }

    public static class Factory
    extends SimpleFactory<ComponentRedstonePostBundled> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[0]);
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/post_rs_bundled");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.BUNDLED_STICK.ordinal();
        }

        @Override
        public ComponentRedstonePostBundled instantiate(ICircuit circuit) {
            return new ComponentRedstonePostBundled(circuit);
        }
    }
}

