/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.digital;

import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumCircuitUpdate;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import com.amadornes.rscircuits.api.component.IComponentFactory;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentFaceRotatable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class ComponentLever
extends ComponentFaceRotatable {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "lever");
    private boolean input = false;
    private boolean prevInput = false;
    private boolean state = false;

    public ComponentLever(ICircuit circuit, int rotation) {
        super(circuit, EnumComponentSlot.BOTTOM, rotation);
    }

    public ComponentLever(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.01f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.state)).func_177226_a((IProperty)ROTATION, (Comparable)Integer.valueOf(this.rotation));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (side != EnumCircuitSide.TOP && side != EnumCircuitSide.BOTTOM) {
            return (side.ordinal() - 2 & 2) == (this.rotation == 0 || this.rotation == 2 ? 2 : 0);
        }
        return side == EnumCircuitSide.BOTTOM;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        if (side != EnumCircuitSide.TOP && side != EnumCircuitSide.BOTTOM) {
            return (side.ordinal() - 2 & 2) != (this.rotation == 0 || this.rotation == 2 ? 2 : 0);
        }
        return side == EnumCircuitSide.TOP;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        if (side == EnumCircuitSide.TOP) {
            return this.state ? (byte)-1 : 0;
        }
        return (side.ordinal() & 1) == ((this.state ? 1 : 0) ^ (this.rotation == 0 || this.rotation == 3 ? 1 : 0)) ? (byte)-1 : 0;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (super.onActivated(player, hand, heldItem, hit)) {
            return true;
        }
        if (!this.getCircuit().getWorld().field_72995_K) {
            this.toggle();
        }
        return true;
    }

    @Override
    public void onAddedPost() {
        this.updateInput();
        this.prevInput = this.input;
    }

    @Override
    public void onCircuitAdded() {
        this.updateInput();
        this.prevInput = this.input;
    }

    @Override
    public void rotatePost() {
        this.updateInput();
        if (this.input && !this.prevInput) {
            this.toggle();
        }
        this.prevInput = this.input;
        super.rotatePost();
    }

    @Override
    public void onNeighborChange(EnumCircuitSide side, EnumComponentSlot slot, IComponent component, EnumCircuitUpdate updateType) {
        if (side == EnumCircuitSide.BOTTOM && this.dropIfNeeded()) {
            return;
        }
        if (this.isInput(this.slot, side)) {
            this.updateInput();
            this.getCircuit().scheduleTick(this, 0, 0, this.input);
        }
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        boolean input = (Boolean)data;
        if (input && !this.prevInput) {
            this.toggle();
        }
        this.prevInput = input;
    }

    private void updateInput() {
        IComponent c;
        this.input = false;
        for (EnumCircuitSide s : EnumCircuitSide.HORIZONTALS) {
            if (!this.isInput(this.slot, s) || this.getInputAny(EnumComponentSlot.BOTTOM, s) == 0) continue;
            this.input = true;
            break;
        }
        if (!this.input && (c = this.getCircuit().getComponent(this.getPos().func_177977_b(), EnumComponentSlot.TOP)) != null && c.getOutputSignalAny(EnumComponentSlot.TOP, EnumCircuitSide.TOP) != 0) {
            this.input = true;
        }
    }

    private void toggle() {
        this.state = !this.state;
        this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
        this.getCircuit().markDirty();
        EnumCircuitSide s = this.rotation == 0 || this.rotation == 2 ? EnumCircuitSide.FRONT : EnumCircuitSide.RIGHT;
        this.getCircuit().notifyUpdate(this.getPos(), this.slot, EnumCircuitSide.TOP, s, s.getOpposite());
    }

    @Override
    public void addSelectionBoxes(List<AxisAlignedBB> boxes) {
        if (this.rotation % 2 == 0) {
            boxes.add(new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 0.375, 1.0));
        } else {
            boxes.add(new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 0.375, 0.875));
        }
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(Blocks.field_150442_at);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("input", this.input);
        tag.func_74757_a("prevInput", this.prevInput);
        tag.func_74757_a("state", this.state);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.input = tag.func_74767_n("input");
        this.prevInput = tag.func_74767_n("prevInput");
        this.state = tag.func_74767_n("state");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeBoolean(this.state);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.state = buf.readBoolean();
    }

    public static class Factory
    extends ComponentFaceRotatable.RotatableFactory<ComponentLever> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON, ComponentBaseInt.ROTATION});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/lever");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150442_at);
        }

        @Override
        public ComponentLever getPlacementData(ICircuit circuit, BlockPos pos, EnumCircuitSide faceClicked, Vec3d hitVec, ItemStack stack, EntityPlayer player, IComponentFactory.EnumPlacementType type, ComponentLever previousData, Map<BlockPos, ComponentLever> otherData, IComponentFactory.EnumInstantanceUse use) {
            if (previousData != null) {
                return previousData;
            }
            return new ComponentLever(circuit, this.getRotation(player));
        }

        @Override
        public ComponentLever instantiate(ICircuit circuit) {
            return new ComponentLever(circuit);
        }
    }
}

