/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.component.button;

import com.amadornes.rscircuits.SCM;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.component.ComponentBaseInt;
import com.amadornes.rscircuits.component.ComponentButton;
import com.amadornes.rscircuits.component.SimpleFactory;
import com.amadornes.rscircuits.init.SCMItems;
import com.amadornes.rscircuits.item.EnumResourceType;
import com.google.common.base.Supplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class ComponentTimer
extends ComponentButton {
    public static final ResourceLocation NAME = new ResourceLocation("rscircuits", "timer");
    private int delay = 20;
    private int ticks = 0;
    private int length = 2;
    private boolean locked = false;
    private boolean shouldOutput = true;

    public ComponentTimer(ICircuit circuit) {
        super(circuit, EnumComponentSlot.BOTTOM);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public float getComplexity() {
        return 0.05f;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public IBlockState getActualState() {
        return super.getActualState().func_177226_a(ON, (Comparable)Boolean.valueOf(this.shouldOutput && this.ticks < this.length));
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return side != EnumCircuitSide.TOP;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return (byte)(this.shouldOutput && this.ticks < this.length && side.face.func_176740_k() != EnumFacing.Axis.Y ? -1 : 0);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, Vec3d hit) {
        if (heldItem != null && (heldItem.func_77973_b() == SCMItems.screwdriver || heldItem.func_77973_b() == SCMItems.multimeter)) {
            SCM.proxy.displayTimerGui((d, s) -> "Ender Pulsar: " + d + (s ? " seconds" : " ticks"), s -> s ? "s" : "t", (Supplier<Integer>)((Supplier)() -> this.delay), d -> {
                ByteBuf buf = Unpooled.buffer();
                buf.writeInt(d.intValue());
                this.getCircuit().sendCustomPayload(this.getPos(), this.slot, buf);
            }, 3, 72000, 20.0);
            return true;
        }
        return false;
    }

    @Override
    public void onAdded() {
        this.getCircuit().scheduleTick(this, 1, 0, null);
    }

    @Override
    public void onScheduledTick(int type, Object data) {
        if (this.getInput() != 0) {
            this.ticks = -1;
            boolean wasLocked = this.locked;
            this.locked = true;
            this.shouldOutput = false;
            if (!wasLocked) {
                this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
                this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
                this.getCircuit().markDirty();
            }
        } else {
            boolean wasLocked = this.locked;
            this.locked = false;
            if (wasLocked) {
                this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
                this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
                this.getCircuit().markDirty();
            }
        }
        ++this.ticks;
        if (this.ticks == this.length) {
            this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
        if (this.ticks >= this.delay) {
            this.ticks = 0;
            this.shouldOutput = true;
            this.getCircuit().notifyUpdateAll(this.getPos(), this.slot);
            this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
            this.getCircuit().markDirty();
        }
        this.getCircuit().scheduleTick(this, 1, 0, null);
    }

    @Override
    public List<ItemStack> getDrops() {
        return Arrays.asList(this.getPickedItem());
    }

    @Override
    public ItemStack getPickedItem() {
        return new ItemStack(SCMItems.resource, 1, EnumResourceType.ENDER_PULSAR.ordinal());
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("ticks", this.ticks);
        tag.func_74768_a("length", this.length);
        tag.func_74757_a("locked", this.locked);
        tag.func_74757_a("shouldOutput", this.shouldOutput);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.delay = tag.func_74762_e("delay");
        this.ticks = tag.func_74762_e("ticks");
        this.length = tag.func_74762_e("length");
        this.locked = tag.func_74767_n("locked");
        this.shouldOutput = tag.func_74767_n("shouldOutput");
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
        super.writeDescription(buf);
        buf.writeInt(this.delay);
        buf.writeInt(this.ticks);
        buf.writeInt(this.length);
        buf.writeBoolean(this.shouldOutput);
    }

    @Override
    public void readDescription(PacketBuffer buf) {
        super.readDescription(buf);
        this.delay = buf.readInt();
        this.ticks = buf.readInt();
        this.length = buf.readInt();
        this.shouldOutput = buf.readBoolean();
    }

    @Override
    public NBTTagCompound serializeTickData(int type, Object data) {
        return new NBTTagCompound();
    }

    @Override
    public Object deserializeTickData(int type, NBTTagCompound tag) {
        return null;
    }

    @Override
    public void handleCustomPayload(ByteBuf buf) {
        this.delay = buf.readInt();
        this.getCircuit().sendUpdate(this.getPos(), this.slot, false);
    }

    public static class Factory
    extends SimpleFactory<ComponentTimer> {
        @Override
        public BlockStateContainer createBlockState() {
            return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{ComponentBaseInt.ON});
        }

        @Override
        public ResourceLocation getModelPath() {
            return new ResourceLocation("rscircuits", "component/timer");
        }

        @Override
        public boolean isValidPlacementStack(ItemStack stack, EntityPlayer player) {
            return stack.func_77973_b() == SCMItems.resource && stack.func_77952_i() == EnumResourceType.ENDER_PULSAR.ordinal();
        }

        @Override
        public ComponentTimer instantiate(ICircuit circuit) {
            return new ComponentTimer(circuit);
        }
    }
}

