/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.ExecutionException;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public abstract class SimpleModelFontRenderer
extends FontRenderer {
    private static final ResourceLocation font = new ResourceLocation("minecraft", "textures/font/ascii.png");
    private static final ResourceLocation font2 = new ResourceLocation("minecraft", "font/ascii");
    private static final Cache<VertexFormat, SimpleModelFontRenderer> fontCache = CacheBuilder.newBuilder().maximumSize(3L).build();
    private static TextureAtlasSprite fontTexture;
    private float r;
    private float g;
    private float b;
    private float a;
    private final Matrix4f matrix;
    private ImmutableList.Builder<BakedQuad> builder = ImmutableList.builder();
    private final VertexFormat format;
    private final Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
    private final EnumFacing orientation;
    private boolean fillBlanks = false;
    private TextureAtlasSprite sprite;
    private final Vector4f vec = new Vector4f();

    public static SimpleModelFontRenderer get(VertexFormat format) {
        try {
            SimpleModelFontRenderer fontRenderer = (SimpleModelFontRenderer)((Object)fontCache.get((Object)format, () -> {
                Matrix4f m = new Matrix4f();
                m.m20 = 0.0078125f;
                m.m01 = m.m12 = -m.m20;
                m.m33 = 1.0f;
                m.setTranslation(new Vector3f(1.0f, 1.0f, 0.0f));
                return new SimpleModelFontRenderer(Minecraft.func_71410_x().field_71474_y, font, Minecraft.func_71410_x().func_110434_K(), false, m, format){

                    @Override
                    protected float func_78277_a(char c, boolean italic) {
                        return super.func_78266_a(126, italic);
                    }
                };
            }));
            fontRenderer.setSprite(fontTexture);
            return fontRenderer;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        fontTexture = event.getMap().func_174942_a(font2);
    }

    private SimpleModelFontRenderer(GameSettings settings, ResourceLocation font, TextureManager manager, boolean isUnicode, Matrix4f matrix, VertexFormat format) {
        super(settings, font, manager, isUnicode);
        manager.func_110577_a(TextureMap.field_110575_b);
        this.matrix = new Matrix4f(matrix);
        Matrix3f nm = new Matrix3f();
        this.matrix.getRotationScale(nm);
        nm.invert();
        nm.transpose();
        this.format = format;
        nm.transform((Tuple3f)this.normal);
        this.normal.normalize();
        this.orientation = EnumFacing.func_176737_a((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
        super.func_110549_a(null);
    }

    public void setFillBlanks(boolean fillBlanks) {
        this.fillBlanks = fillBlanks;
    }

    protected float func_78266_a(int pos, boolean italic) {
        float x = (float)(pos % 16) / 16.0f;
        float y = (float)(pos / 16) / 16.0f;
        float sh = italic ? 1.0f : 0.0f;
        float w = (float)this.field_78286_d[pos] - 1.01f;
        float h = (float)this.field_78288_b - 1.01f;
        float wt = w / 128.0f;
        float ht = h / 128.0f;
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setQuadOrientation(this.orientation);
        this.addVertex(quadBuilder, this.field_78295_j + sh, this.field_78296_k, x, y);
        this.addVertex(quadBuilder, this.field_78295_j - sh, this.field_78296_k + h, x, y + ht);
        this.addVertex(quadBuilder, this.field_78295_j + w + sh, this.field_78296_k + h, x + wt, y + ht);
        this.addVertex(quadBuilder, this.field_78295_j + w - sh, this.field_78296_k, x + wt, y);
        this.builder.add((Object)quadBuilder.build());
        if (this.fillBlanks) {
            float cuv = 0.9375f;
            quadBuilder = new UnpackedBakedQuad.Builder(this.format);
            quadBuilder.setQuadOrientation(this.orientation);
            this.addVertex(quadBuilder, this.field_78295_j + w + sh, this.field_78296_k, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j + w - sh, this.field_78296_k + h, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j + (float)this.field_78286_d[pos] + sh, this.field_78296_k + h, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j + (float)this.field_78286_d[pos] - sh, this.field_78296_k, cuv, cuv);
            this.builder.add((Object)quadBuilder.build());
            quadBuilder = new UnpackedBakedQuad.Builder(this.format);
            quadBuilder.setQuadOrientation(this.orientation);
            this.addVertex(quadBuilder, this.field_78295_j + sh, this.field_78296_k + h, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j - sh, this.field_78296_k + (float)this.field_78288_b, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j + (float)this.field_78286_d[pos] + sh, this.field_78296_k + (float)this.field_78288_b, cuv, cuv);
            this.addVertex(quadBuilder, this.field_78295_j + (float)this.field_78286_d[pos] - sh, this.field_78296_k + h, cuv, cuv);
            this.builder.add((Object)quadBuilder.build());
        }
        return this.field_78286_d[pos];
    }

    private void addVertex(UnpackedBakedQuad.Builder quadBuilder, float x, float y, float u, float v) {
        this.vec.x = x;
        this.vec.y = y;
        this.vec.z = 0.0f;
        this.vec.w = 1.0f;
        this.matrix.transform((Tuple4f)this.vec);
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    quadBuilder.put(e, new float[]{this.vec.x, this.vec.y, this.vec.z, this.vec.w});
                    continue block6;
                }
                case UV: {
                    quadBuilder.put(e, new float[]{this.sprite.func_94214_a((double)(u * 16.0f)), this.sprite.func_94207_b((double)(v * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    quadBuilder.put(e, new float[]{this.r, this.g, this.b, this.a});
                    continue block6;
                }
                case NORMAL: {
                    quadBuilder.put(e, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
                    continue block6;
                }
                default: {
                    quadBuilder.put(e, new float[0]);
                }
            }
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        super.func_110549_a(resourceManager);
        String p = this.field_111273_g.func_110623_a();
        if (p.startsWith("textures/")) {
            p = p.substring("textures/".length(), p.length());
        }
        if (p.endsWith(".png")) {
            p = p.substring(0, p.length() - ".png".length());
        }
        String f = this.field_111273_g.func_110624_b() + ":" + p;
        this.sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(f);
    }

    protected abstract float func_78277_a(char var1, boolean var2);

    protected void doDraw(float shift) {
        this.field_78295_j += (float)((int)shift);
    }

    protected void setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void enableAlpha() {
    }

    public ImmutableList<BakedQuad> build() {
        ImmutableList ret = this.builder.build();
        this.builder = ImmutableList.builder();
        return ret;
    }
}

