/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.client;

import com.amadornes.rscircuits.api.circuit.EnumCircuitIOMode;
import com.amadornes.rscircuits.client.MSRCircuit;
import com.amadornes.rscircuits.client.ModelTransformer;
import com.amadornes.rscircuits.client.SimpleModelFontRenderer;
import com.amadornes.rscircuits.part.PartCircuit;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelWrapperInnerCircuit
implements IBakedModel {
    private final IBakedModel parent;

    public ModelWrapperInnerCircuit(IBakedModel parent) {
        this.parent = parent;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.processQuads(state, side, this.parent.func_188616_a(state, side, rand));
    }

    private List<BakedQuad> processQuads(IBlockState state, EnumFacing side, List<BakedQuad> quads) {
        if (side == null && state instanceof IExtendedBlockState && ((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_IO_MODE) != null && ((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_NAME) != null) {
            quads = new ArrayList<BakedQuad>(quads);
            EnumCircuitIOMode[] modes = (EnumCircuitIOMode[])((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_IO_MODE);
            ArrayList<BakedQuad> added = new ArrayList<BakedQuad>();
            ListIterator<BakedQuad> li = quads.listIterator();
            while (li.hasNext()) {
                BakedQuad q2 = li.next();
                try {
                    if (q2.func_187508_a().func_94215_i().equals("rscircuits:blocks/overlay_normal")) {
                        this.doTheThing(state, modes, EnumCircuitIOMode.REGULAR, li, added, q2);
                        continue;
                    }
                    if (!q2.func_187508_a().func_94215_i().equals("rscircuits:blocks/overlay_combo")) continue;
                    this.doTheThing(state, modes, EnumCircuitIOMode.BUNDLED, li, added, q2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            quads.addAll(added);
            added.clear();
            String name = (String)((IExtendedBlockState)state).getValue(PartCircuit.PROPERTY_NAME);
            if (name.length() > 0) {
                SimpleModelFontRenderer fontRenderer = SimpleModelFontRenderer.get(quads.iterator().next().getFormat());
                fontRenderer.setFillBlanks(true);
                int width = fontRenderer.func_78256_a(name) - 1;
                int size = Math.max(width, fontRenderer.field_78288_b + 2);
                fontRenderer.func_78276_b(name, 0, 0, -1);
                ModelTransformer.IVertexTransformer transformer = (q, type, usage, data) -> {
                    if (usage == VertexFormatElement.EnumUsage.POSITION) {
                        Point3f p = new Point3f(data[0], data[1], data[2]);
                        p.x = (p.x - (1.0f - (float)(fontRenderer.field_78288_b - 2) / 16.0f / 16.0f)) * (57.6f / (float)size) + 0.5f;
                        p.y = p.y - 1.0f + 0.171875f + 0.002f;
                        p.z = (p.z - (float)width / 16.0f / 16.0f) * (57.6f / (float)size) + 0.5f;
                        return new float[]{p.x, p.y, p.z, data[3]};
                    }
                    return data;
                };
                fontRenderer.build().stream().map(q -> ModelTransformer.transform(q, transformer)).forEach(quads::add);
            }
        }
        return quads;
    }

    public void doTheThing(IBlockState state, EnumCircuitIOMode[] modes, EnumCircuitIOMode mode, ListIterator<BakedQuad> li, List<BakedQuad> quads, BakedQuad quad) {
        int k = ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).func_176740_k() == EnumFacing.Axis.Y ? 0 : 1;
        for (int i = 0; i < 4; ++i) {
            Matrix4f matrix;
            int j;
            int n = i == 2 ? 0 : (i == 0 ? 1 : (j = i == 1 ? 2 : 3));
            if (modes[(j + k) % 4] != mode || (matrix = ModelRotation.func_177524_a((int)0, (int)(i * 90)).getMatrix()) == null) continue;
            quads.add(ModelTransformer.transform(quad, (q, type, usage, data) -> {
                if (usage == VertexFormatElement.EnumUsage.POSITION) {
                    Point3f point = new Point3f(data[0], data[1], data[2]);
                    Matrix4f mat = new Matrix4f(MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()]);
                    mat.invert();
                    mat.transform(point);
                    point.y += 0.001f;
                    matrix.transform(point);
                    MSRCircuit.matrices[((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal()].transform(point);
                    return new float[]{point.x, point.y, point.z, data[3]};
                }
                return data;
            }));
        }
        li.remove();
    }

    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }
}

