/*
 * Decompiled with CFR 0.152.
 */
package com.amadornes.rscircuits.api.component;

import com.amadornes.rscircuits.api.SCMAPI;
import com.amadornes.rscircuits.api.circuit.ICircuit;
import com.amadornes.rscircuits.api.component.EnumCircuitSide;
import com.amadornes.rscircuits.api.component.EnumComponentSlot;
import com.amadornes.rscircuits.api.component.IComponent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ComponentBase
implements IComponent {
    private final ICircuit circuit;
    private BlockPos pos;

    public ComponentBase(ICircuit circuit) {
        this.circuit = circuit;
    }

    @Override
    public ICircuit getCircuit() {
        return this.circuit;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public IBlockState getActualState() {
        return SCMAPI.getInstance().getComponentRegistry().getState(this.getName()).func_177621_b();
    }

    @Override
    public EnumSet<EnumComponentSlot> getSlots() {
        return EnumSet.noneOf(EnumComponentSlot.class);
    }

    @Override
    public boolean isInput(EnumComponentSlot slot, EnumCircuitSide side) {
        return false;
    }

    @Override
    public boolean isOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return false;
    }

    @Override
    public boolean isStrongOutput(EnumComponentSlot slot, EnumCircuitSide side) {
        return false;
    }

    @Override
    public byte getOutputSignal(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color, boolean bundled) {
        return 0;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void writeDescription(PacketBuffer buf) {
    }

    @Override
    public void readDescription(PacketBuffer buf) {
    }

    public IComponent getNeighbor(EnumComponentSlot slot, EnumCircuitSide side) {
        return ComponentBase.getNeighbor(this.getCircuit(), this.getPos(), slot, side);
    }

    public Pair<IComponent, EnumComponentSlot> getNeighborPair(EnumComponentSlot slot, EnumCircuitSide side) {
        return ComponentBase.getNeighborPair(this.getCircuit(), this.getPos(), slot, side);
    }

    public static IComponent getNeighbor(ICircuit circuit, BlockPos pos, EnumComponentSlot slot, EnumCircuitSide side) {
        Pair<IComponent, EnumComponentSlot> p = ComponentBase.getNeighborPair(circuit, pos, slot, side);
        return p == null ? null : (IComponent)p.getKey();
    }

    public static Pair<IComponent, EnumComponentSlot> getNeighborPair(ICircuit circuit, BlockPos pos, EnumComponentSlot slot, EnumCircuitSide side) {
        return ComponentBase.getNeighborPairConditioned(circuit, pos, slot, side, (c, s) -> true);
    }

    public static Pair<IComponent, EnumComponentSlot> getNeighborPairConditioned(ICircuit circuit, BlockPos pos, EnumComponentSlot slot, EnumCircuitSide side, BiPredicate<IComponent, EnumComponentSlot> predicate) {
        IComponent c;
        if (slot.side != side) {
            if (slot.side == side.getOpposite()) {
                IComponent c2 = circuit.getComponent(pos, EnumComponentSlot.CENTER);
                if (c2 != null && predicate.test(c2, EnumComponentSlot.CENTER)) {
                    return Pair.of((Object)c2, (Object)((Object)EnumComponentSlot.CENTER));
                }
                return null;
            }
            c = circuit.getComponent(pos, EnumComponentSlot.VALUES[side.ordinal()]);
            if (c != null && predicate.test(c, EnumComponentSlot.VALUES[side.ordinal()])) {
                return Pair.of((Object)c, (Object)((Object)EnumComponentSlot.VALUES[side.ordinal()]));
            }
        }
        if ((c = circuit.getComponent(pos.func_177972_a(side.face), EnumComponentSlot.VALUES[side.getOpposite().ordinal()])) != null && predicate.test(c, EnumComponentSlot.VALUES[side.getOpposite().ordinal()])) {
            return Pair.of((Object)c, (Object)((Object)EnumComponentSlot.VALUES[side.getOpposite().ordinal()]));
        }
        if (slot.side == side) {
            slot = EnumComponentSlot.CENTER;
        }
        if ((c = circuit.getComponent(pos.func_177972_a(side.face), slot)) != null && predicate.test(c, slot)) {
            return Pair.of((Object)c, (Object)((Object)slot));
        }
        return null;
    }

    public byte getInput(EnumComponentSlot slot, EnumCircuitSide side, EnumDyeColor color) {
        Pair<IComponent, EnumComponentSlot> c = this.getNeighborPair(slot, side);
        if (c != null && ((IComponent)c.getKey()).isStrongOutput((EnumComponentSlot)((Object)c.getValue()), side.getOpposite())) {
            return ((IComponent)c.getKey()).getOutputSignal((EnumComponentSlot)((Object)c.getValue()), side.getOpposite(), color, false);
        }
        return 0;
    }

    public byte getInputAny(EnumComponentSlot slot, EnumCircuitSide side) {
        int power = 0;
        Pair<IComponent, EnumComponentSlot> c = this.getNeighborPair(slot, side);
        if (c != null && ((IComponent)c.getKey()).isStrongOutput((EnumComponentSlot)((Object)c.getValue()), side.getOpposite())) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                power = Math.max(power, ((IComponent)c.getKey()).getOutputSignal((EnumComponentSlot)((Object)c.getValue()), side.getOpposite(), color, false) & 0xFF);
            }
        }
        return (byte)power;
    }

    public boolean isOnEdge(EnumCircuitSide edge) {
        return edge == null ? false : this.getCircuit().getCircuit(this.pos.func_177972_a(edge.face)) == null;
    }

    public EnumCircuitSide getEdgeOn() {
        BlockPos pos = this.getPos();
        if (pos.func_177958_n() == 0) {
            return EnumCircuitSide.RIGHT;
        }
        if (pos.func_177958_n() == 6) {
            return EnumCircuitSide.LEFT;
        }
        if (pos.func_177952_p() == 0) {
            return EnumCircuitSide.BACK;
        }
        if (pos.func_177952_p() == 6) {
            return EnumCircuitSide.FRONT;
        }
        return null;
    }

    public List<EnumCircuitSide> getEdgesOn() {
        ArrayList<EnumCircuitSide> edges = new ArrayList<EnumCircuitSide>();
        BlockPos pos = this.getPos();
        if (pos.func_177958_n() == 0) {
            edges.add(EnumCircuitSide.RIGHT);
        }
        if (pos.func_177958_n() == 6) {
            edges.add(EnumCircuitSide.LEFT);
        }
        if (pos.func_177952_p() == 0) {
            edges.add(EnumCircuitSide.BACK);
        }
        if (pos.func_177952_p() == 6) {
            edges.add(EnumCircuitSide.FRONT);
        }
        return edges;
    }

    public boolean isOnSeam() {
        BlockPos pos = this.getPos();
        return pos.func_177958_n() == 8 || pos.func_177952_p() == 8;
    }
}

