/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.network;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.TileEntityIronChest;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCrystalChestSync
implements IMessage {
    int dimension;
    BlockPos pos;
    private ItemStack[] topStacks;

    public MessageCrystalChestSync(TileEntityIronChest tile, ItemStack[] stack) {
        this.dimension = tile.func_145831_w().field_73011_w.getDimension();
        this.pos = tile.func_174877_v();
        this.topStacks = stack;
    }

    public MessageCrystalChestSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        this.topStacks = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            this.topStacks[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.topStacks.length);
        for (ItemStack stack : this.topStacks) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageCrystalChestSync, IMessage> {
        public IMessage onMessage(MessageCrystalChestSync message, MessageContext ctx) {
            TileEntity tile;
            World world = IronChest.proxy.getClientWorld();
            if (world != null && (tile = world.func_175625_s(message.pos)) instanceof TileEntityIronChest) {
                ((TileEntityIronChest)tile).receiveMessageFromServer(message.topStacks);
            }
            return null;
        }
    }
}

