/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.plugin.jei.generator;

import com.miningmark48.pearcelmod.init.GeneratorRegistry;
import com.miningmark48.pearcelmod.plugin.jei.generator.GeneratorFuelRecipe;
import com.miningmark48.pearcelmod.tileentity.TileEntityPearcelGenerator;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;

public class GeneratorFuelRecipeMaker {
    private GeneratorFuelRecipeMaker() {
    }

    public static List<GeneratorFuelRecipe> getFuelRecipes(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        IStackHelper stackHelper = helpers.getStackHelper();
        List<ItemStack> fuelStacks = GeneratorRegistry.getFuels();
        ArrayList<GeneratorFuelRecipe> fuelRecipes = new ArrayList<GeneratorFuelRecipe>(fuelStacks.size());
        for (ItemStack fuelStack : fuelStacks) {
            List fuels;
            if (fuelStack == null || (fuels = stackHelper.getSubtypes(fuelStack)).isEmpty()) continue;
            int cooldownTime = GeneratorFuelRecipeMaker.getBurnTime((ItemStack)fuels.get(0));
            int rfPerTick = GeneratorFuelRecipeMaker.getRFPerTick((ItemStack)fuels.get(0));
            fuelRecipes.add(new GeneratorFuelRecipe(guiHelper, fuels, cooldownTime, rfPerTick));
        }
        return fuelRecipes;
    }

    private static int getBurnTime(ItemStack stack) {
        return TileEntityPearcelGenerator.getCooldownTime(stack);
    }

    private static int getRFPerTick(ItemStack stack) {
        return TileEntityPearcelGenerator.getRFPerTick(stack);
    }
}

