/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.gem.EntityAgate;
import mod.akrivus.kagic.entity.gem.EntityRuby;
import mod.akrivus.kagic.entity.gem.EntityRutile;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModAchievements;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModConfigs;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModMetrics;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.server.SpaceStuff;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ModEvents {
    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)e.getEntity();
            if (e.getEntity().field_70170_p.field_72995_K) {
                ModMetrics.Update result;
                if (ModConfigs.notifyOnUpdates && (result = ModMetrics.setMetrics(player)) != null && !"@version".equals(result.getModVersion())) {
                    player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"\u00ef\u00bf\u00bdcKAGIC v" + result.getModVersion() + " is out for Minecraft " + "@mcversion" + "\u00ef\u00bf\u00bdf\"}]")));
                    player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)"[{\"text\":\"This update adds the following changes:\"}]"));
                    for (String change : result.getChangelogs()) {
                        player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"- " + change + "\"}]")));
                    }
                    player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)("[{\"text\":\"\u00ef\u00bf\u00bde\u00ef\u00bf\u00bdnDownload\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bdf\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + result.getDownloadLink() + "\"}}, {\"text\":\" | \"}, {\"text\":\"\u00ef\u00bf\u00bd3\u00ef\u00bf\u00bdnDiscord\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bdf\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + result.getDiscordLink() + "\"}}, {\"text\":\" | \"}, {\"text\":\"\u00ef\u00bf\u00bd6\u00ef\u00bf\u00bdnPatreon\u00ef\u00bf\u00bdr\u00ef\u00bf\u00bdf\",\"clickEvent\":{\"action\":\"open_url\",\"value\":\"" + result.getPatreonLink() + "\"}}]")));
                }
                player.func_71029_a((StatBase)ModAchievements.INSTALLED_KAGIC);
            }
        }
        if (e.getEntity() instanceof EntityMob) {
            EntityMob mob = (EntityMob)e.getEntity();
            if (!(e.getEntity() instanceof EntityEnderman) && !(e.getEntity() instanceof EntityGolem)) {
                mob.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)mob, EntityGem.class, 1, true, true, (Predicate)new Predicate<EntityGem>(){

                    public boolean apply(EntityGem input) {
                        return !(input instanceof EntityAgate) && (!input.isDefective() || !(input instanceof EntityRutile));
                    }
                }));
            }
            mob.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)mob, EntityAgate.class, 6.0f, 1.0, 1.2));
        } else if (e.getEntity() instanceof EntityGolem) {
            EntityGolem golem = (EntityGolem)e.getEntity();
            golem.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)golem, EntityGem.class, 1, true, true, (Predicate)new Predicate<EntityGem>(){

                public boolean apply(EntityGem input) {
                    return input.getServitude() > 1;
                }
            }));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        MinecraftServer server = event.world.func_73046_m();
        if (ModConfigs.spawnMeteorRubies && server.func_71233_x() > 0) {
            EntityPlayer player = (EntityPlayer)server.func_184103_al().func_181057_v().get(event.world.field_73012_v.nextInt(server.func_71233_x()));
            if (!player.field_70170_p.field_72995_K && player.field_71093_bK == 0 && !player.field_70170_p.func_72935_r() && player.field_70170_p.func_82737_E() - SpaceStuff.get().getLastRubyImpactTime() >= (long)(24000 * ModConfigs.meteorRubyRate) && player.field_70170_p.field_73012_v.nextInt(12000) == 0) {
                EntityRuby ruby = new EntityRuby(player.field_70170_p);
                double xdev = player.field_70170_p.field_73012_v.nextInt(128) - 64;
                double newX = player.field_70165_t + Math.abs(xdev) < 16.0 ? 128.0 : xdev;
                double zdev = player.field_70170_p.field_73012_v.nextInt(128) - 64;
                double newZ = player.field_70161_v + Math.abs(zdev) < 16.0 ? 128.0 : zdev;
                ruby.func_70107_b(newX, 256.0, newZ);
                ruby.isSpaceBorn = true;
                player.field_70170_p.func_72838_d((Entity)ruby);
                ruby.func_180482_a(ruby.field_70170_p.func_175649_E(new BlockPos((Entity)ruby)), null);
                player.field_70170_p.func_184133_a(player, player.func_180425_c(), ModSounds.RUBY_EXPLODE, SoundCategory.NEUTRAL, 10.0f, 1.0f);
                SpaceStuff.get().setLastRubyImpactTime(player.field_70170_p.func_82737_E());
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent e) {
        if (e.getName().equals((Object)LootTableList.field_186424_f) || e.getName().equals((Object)LootTableList.field_186423_e)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.CRACKED_BISMUTH_GEM, 1, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_PERIDOT_GEM, 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_PEARL_GEM, 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.INACTIVE_GEM_BASE, 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(2.0f))}, new LootCondition[0], "kagic"), new LootEntryItem(Item.func_150898_a((Block)ModBlocks.INJECTOR), 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem(Item.func_150898_a((Block)ModBlocks.GEM_DRILL), 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem(Item.func_150898_a((Block)ModBlocks.INCUBATOR), 3, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(2.0f), "kagic"));
        } else if (e.getName().equals((Object)LootTableList.field_186429_k) || e.getName().equals((Object)LootTableList.field_186421_c) || e.getName().equals((Object)LootTableList.field_186430_l) || e.getName().equals((Object)LootTableList.field_186425_g)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.CRACKED_PERIDOT_GEM, 4, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_AMETHYST_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_JASPER_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_CARNELIAN_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(2.0f), "kagic"));
        } else if (e.getName().equals((Object)LootTableList.field_186422_d) || e.getName().equals((Object)LootTableList.field_186428_j)) {
            e.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryItem((Item)ModItems.CRACKED_RUBY_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.CRACKED_PEARL_GEM, 2, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(1.0f))}, new LootCondition[0], "kagic"), new LootEntryItem((Item)ModItems.INACTIVE_GEM_BASE, 5, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(4.0f))}, new LootCondition[0], "kagic")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(2.0f), "kagic"));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        ModConfigs.syncConfiguration();
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (!e.getWorld().field_72995_K) {
            try {
                KAGIC.spaceStuff = new SpaceStuff(e.getWorld());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save e) {
        if (!e.getWorld().field_72995_K) {
            KAGIC.spaceStuff.save();
        }
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent e) {
        List list = e.getPlayer().field_70170_p.func_72872_a(EntityGem.class, e.getPlayer().func_174813_aQ().func_72314_b(48.0, 16.0, 48.0));
        for (EntityGem gem : list) {
            boolean obeyed = gem.onSpokenTo((EntityPlayer)e.getPlayer(), e.getMessage());
            if (!obeyed) continue;
            gem.playObeySound();
        }
    }
}

