/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntityPepo;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.entity.pepo.EntityCactus;
import mod.akrivus.kagic.entity.pepo.EntityMelon;
import mod.akrivus.kagic.entity.pepo.EntityPumpkin;
import mod.akrivus.kagic.init.ModAchievements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.items.ItemGem;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class EntityRoseQuartz
extends EntityGem {
    public static final HashMap<Block, Double> ROSE_QUARTZ_YIELDS = new HashMap();
    public static final HashMap<Integer, ResourceLocation> ROSE_QUARTZ_HAIR_STYLES = new HashMap();
    private BlockPos lastSurgeLocation;
    private int regenTicks = 0;

    public EntityRoseQuartz(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.3f);
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.FACETED, GemPlacements.RIGHT_KNEE);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 10, true, false, (Predicate)new Predicate<EntityMob>(){

            public boolean apply(EntityMob input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.droppedGemItem = ModItems.ROSE_QUARTZ_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_ROSE_QUARTZ_GEM;
    }

    @Override
    public float[] getGemColor() {
        return new float[]{1.0f, 0.63529414f, 0.9019608f};
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.FACETED.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.BELLY.id);
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND && !this.field_70170_p.field_72995_K) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player) && stack.func_77973_b() instanceof ItemGem && ((ItemGem)stack.func_77973_b()).isCracked) {
                Item gem = stack.func_77973_b();
                ItemStack result = new ItemStack((Item)ModItems.GEM_TABLE.get(gem));
                result.func_77982_d(stack.func_77978_p());
                this.func_70099_a(result, 1.0f);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.playObeySound();
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_70105_a(0.63f, 2.3f);
    }

    @Override
    public void func_70636_d() {
        if (!(this.regenTicks <= 80 || this.isDefective() || this.field_70128_L || this.func_110143_aJ() <= 0.0f)) {
            this.startCryingLikeAnEmo();
            this.regenTicks = 0;
        }
        ++this.regenTicks;
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.lastSurgeLocation == null || this.func_180425_c().func_177951_i((Vec3i)this.lastSurgeLocation) > 16.0) {
                for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-8, -2, -8), (BlockPos)this.func_180425_c().func_177982_a(8, 2, 8))) {
                    EntityPepo pepo;
                    IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                    if (state.func_177230_c() == Blocks.field_150440_ba) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityMelon(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150423_aK) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityPumpkin(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        continue;
                    }
                    if (state.func_177230_c() == Blocks.field_150428_aP) {
                        this.field_70170_p.func_175655_b((BlockPos)pos, false);
                        pepo = new EntityPumpkin(this.field_70170_p);
                        pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        pepo.func_70606_j(pepo.func_110138_aP());
                        this.field_70170_p.func_72838_d((Entity)pepo);
                        pepo.setMaster(this);
                        ((EntityPumpkin)pepo).setLit(true);
                        continue;
                    }
                    if (state.func_177230_c() != Blocks.field_150434_aF) continue;
                    this.field_70170_p.func_175655_b((BlockPos)pos, false);
                    pepo = new EntityCactus(this.field_70170_p);
                    pepo.func_70107_b(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    pepo.func_70606_j(pepo.func_110138_aP());
                    this.field_70170_p.func_72838_d((Entity)pepo);
                    pepo.setMaster(this);
                }
            }
            List list = this.field_70170_p.func_72872_a(EntityPepo.class, this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0));
            for (EntityPepo pepo : list) {
                if (pepo.getMaster() != null) continue;
                pepo.setMaster(this);
            }
            if (list.size() > 0 && this.getServitude() == 1 && this.getOwner() != null) {
                this.getOwner().func_71029_a((StatBase)ModAchievements.REVOLUTION);
            }
            this.lastSurgeLocation = this.func_180425_c();
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() != null && !this.isOwner((EntityLivingBase)cause.func_76346_g())) {
            this.func_145779_a((Item)ModItems.RECORD_ROSES_FOUNTAIN, 1);
        }
        super.func_70645_a(cause);
    }

    private void startCryingLikeAnEmo() {
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(16.0).func_72321_a(0.0, (double)this.field_70170_p.func_72800_K(), 0.0);
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
            for (EntityLivingBase entity : list) {
                if (entity.field_70128_L && !(entity.func_110143_aJ() > 0.0f)) continue;
                if (entity instanceof EntityGem) {
                    EntityGem gem = (EntityGem)entity;
                    if (this.getServitude() == gem.getServitude()) {
                        if (this.getServitude() == 1) {
                            if (this.isOwnerId(gem.func_184753_b())) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                            }
                        } else {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
                        }
                    }
                }
                if (!this.isOwner(entity)) continue;
                entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100));
            }
        }
    }

    public SoundEvent func_184639_G() {
        return ModSounds.ROSE_QUARTZ_LIVING;
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.ROSE_QUARTZ_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.ROSE_QUARTZ_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.ROSE_QUARTZ_DEATH;
    }
}

