/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModAchievements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityLapisLazuli
extends EntityGem {
    public static final HashMap<Block, Double> LAPIS_LAZULI_YIELDS = new HashMap();
    public static final HashMap<Integer, ResourceLocation> LAPIS_LAZULI_HAIR_STYLES = new HashMap();
    public int ticksFlying = 0;

    public EntityLapisLazuli(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
        this.visorChanceReciprocal = 20;
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.LAPIS_LAZULI_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_LAPIS_LAZULI_GEM;
    }

    @Override
    public float[] getGemColor() {
        return new float[]{0.11764706f, 0.56078434f, 0.95686275f};
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TEARDROP.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BACK.id);
            }
        }
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
                if (this.isCoreItem(stack)) {
                    return super.func_184645_a(player, hand);
                }
                if (stack.func_77973_b() instanceof ItemHoe) {
                    boolean toolChanged = true;
                    if (this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                        if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                            this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                        } else {
                            toolChanged = false;
                        }
                    }
                    if (toolChanged) {
                        ItemStack heldItem = stack.func_77946_l();
                        this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                        this.playObeySound();
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (!this.isDefective()) {
                    player.field_70177_z = this.field_70177_z;
                    player.field_70125_A = this.field_70125_A;
                    player.func_184220_m((Entity)this);
                    player.func_71029_a((StatBase)ModAchievements.GIVE_ME_A_LIFT);
                    this.playObeySound();
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        passenger.func_70107_b(this.field_70165_t, this.field_70163_u - 1.25, this.field_70161_v);
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase rider = (EntityLivingBase)entity;
            return this.isOwner(rider);
        }
        return false;
    }

    @Override
    public void func_70612_e(float strafe, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = Math.max(-90.0f, -90.0f - entity.field_70125_A * 2.0f);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 3.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            forward = ((EntityLivingBase)entity).field_70701_bs;
            strafe = ((EntityLivingBase)entity).field_70702_br;
            if (this.func_184186_bw()) {
                if (this.func_70090_H()) {
                    this.func_70060_a(strafe, 0.91f, 0.02f);
                    this.field_70181_x = forward / 10.0f;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= (double)0.8f;
                    this.field_70181_x *= (double)0.8f;
                    this.field_70179_y *= (double)0.8f;
                } else if (this.func_180799_ab()) {
                    this.func_70060_a(strafe, 0.91f, 0.02f);
                    this.field_70181_x = forward / 10.0f;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= 0.5;
                    this.field_70181_x *= 0.5;
                    this.field_70179_y *= 0.5;
                } else {
                    float f = 0.91f * (this.isPrimary() ? 2.0f : 1.0f);
                    if (!this.field_70122_E) {
                        float f1 = 0.16277136f / (f * f * f);
                        this.func_70060_a(strafe, 0.91f, 0.2f * f1);
                    }
                    this.field_70181_x = forward / 10.0f;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    this.field_70159_w *= (double)f;
                    this.field_70181_x *= (double)f;
                    this.field_70179_y *= (double)f;
                }
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = 0.0f;
            this.field_70721_aZ = 0.0f;
        } else {
            this.field_70138_W = 1.0f;
            this.field_70747_aH = 0.02f;
            super.func_70612_e(strafe, forward);
        }
    }

    public boolean isFarmer() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemHoe;
    }

    private boolean hasWater(World worldIn, BlockPos pos) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a() != Material.field_151586_h) continue;
            return worldIn.func_175623_d(pos.func_177984_a());
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        this.ticksFlying = this.func_184207_aI() && !this.field_70122_E ? ++this.ticksFlying : 0;
        if (this.isFarmer() && this.field_70173_aa % 20 == 0) {
            for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.func_180425_c().func_177982_a(-2, -2, -2), (BlockPos)this.func_180425_c().func_177982_a(2, -1, 2))) {
                IBlockState iblockstate = this.field_70170_p.func_180495_p((BlockPos)pos);
                if (iblockstate.func_177230_c() == Blocks.field_150458_ak && (Integer)iblockstate.func_177229_b((IProperty)BlockFarmland.field_176531_a) < 7) {
                    this.field_70170_p.func_180501_a((BlockPos)pos, iblockstate.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
                    continue;
                }
                if (iblockstate.func_177230_c() != Blocks.field_150346_d && iblockstate.func_177230_c() != Blocks.field_150349_c || !this.hasWater(this.field_70170_p, (BlockPos)pos)) continue;
                this.field_70170_p.func_180501_a((BlockPos)pos, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_184207_aI() && source.func_76346_g() != null && ((Entity)this.func_184188_bt().get(0)).equals((Object)source.func_76346_g())) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.func_184207_aI()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        if (!this.func_184207_aI()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof EntitySkeleton) {
            this.func_145779_a((Item)ModItems.RECORD_LAPIS_FLIGHT, 1);
        }
        super.func_70645_a(cause);
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.LAPIS_LAZULI_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.LAPIS_LAZULI_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.LAPIS_LAZULI_DEATH;
    }
}

