/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.EntityAmethyst;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModAchievements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityJasper
extends EntityGem {
    public static final HashMap<Block, Double> JASPER_YIELDS = new HashMap();
    public static final HashMap<Integer, ResourceLocation> JASPER_HAIR_STYLES = new HashMap();
    private static final DataParameter<Boolean> CHARGED = EntityDataManager.func_187226_a(EntityJasper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int charge_ticks = 0;
    private int hit_count = 0;
    private int regenTicks = 0;

    public EntityJasper(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.3f);
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TINY, GemPlacements.NOSE);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(24.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.droppedGemItem = ModItems.JASPER_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
        this.field_70180_af.func_187214_a(CHARGED, (Object)false);
    }

    @Override
    public float[] getGemColor() {
        switch (this.getSpecial()) {
            case 1: {
                return new float[]{0.34509805f, 0.827451f, 0.8117647f};
            }
            case 2: {
                return new float[]{0.83137256f, 0.5294118f, 0.40784314f};
            }
        }
        return new float[]{1.0f, 0.24705882f, 0.003921569f};
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TINY.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.NOSE.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("charged", ((Boolean)this.field_70180_af.func_187225_a(CHARGED)).booleanValue());
        compound.func_74768_a("charge_ticks", this.charge_ticks);
        compound.func_74768_a("hit_count", this.hit_count);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(CHARGED, (Object)compound.func_74767_n("charged"));
        this.charge_ticks = compound.func_74762_e("charge_ticks");
        this.hit_count = compound.func_74762_e("hit_count");
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        int special = this.field_70146_Z.nextInt(3);
        switch (this.field_70170_p.func_180494_b(this.func_180425_c()).func_150561_m()) {
            case COLD: {
                special = this.field_70146_Z.nextInt(6) == 0 ? 1 : special;
                break;
            }
            case MEDIUM: {
                special = this.field_70146_Z.nextInt(6) == 0 ? 2 : special;
                break;
            }
            case OCEAN: {
                special = this.field_70146_Z.nextInt(6) == 0 ? 1 : special;
                break;
            }
            case WARM: {
                special = this.field_70146_Z.nextInt(6) == 0 ? 0 : special;
            }
        }
        this.func_96094_a(new TextComponentTranslation(String.format("entity.kagic.jasper_%1$d.name", special), new Object[0]).func_150261_e());
        this.setSpecial(special);
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean isCharged() {
        return (Boolean)this.field_70180_af.func_187225_a(CHARGED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(CHARGED, (Object)charged);
    }

    public String getSpecialSkin() {
        switch (this.getSpecial()) {
            case 0: {
                return "";
            }
            case 1: {
                return "ocean_";
            }
            case 2: {
                return "biggs_";
            }
        }
        return null;
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_70105_a(0.63f, 2.3f);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.charge_ticks += 20;
            ++this.hit_count;
            if (this.isCharged()) {
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(8.0).func_72321_a(0.0, (double)this.field_70170_p.func_72800_K(), 0.0);
                List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisalignedbb);
                for (EntityLivingBase entity : list) {
                    if (this.isOwner(entity)) continue;
                    boolean shouldAttack = true;
                    if (entity instanceof EntityGem) {
                        EntityGem gem = (EntityGem)entity;
                        if (this.getServitude() == gem.getServitude()) {
                            shouldAttack = this.getServitude() == 1 && this.getOwner() != null ? !this.isOwnerId(gem.func_184753_b()) : false;
                        }
                    }
                    if (!shouldAttack || !entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)))) continue;
                    entity.field_70181_x += 0.9;
                    this.func_174815_a((EntityLivingBase)this, (Entity)entity);
                }
                if (this.getServitude() == 1 && this.getOwner() != null) {
                    this.getOwner().func_71029_a((StatBase)ModAchievements.FIGHTING_IS_MY_LIFE);
                }
            } else if (entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(10 + this.field_70146_Z.nextInt(15)))) {
                entityIn.field_70181_x += 0.4;
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() || !this.field_70160_al) {
            ++this.regenTicks;
        }
        if (this.hit_count > 12) {
            --this.charge_ticks;
            this.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 80));
            this.setCharged(true);
            if (this.charge_ticks < 1) {
                this.hit_count = 0;
                this.setCharged(false);
            }
        }
        if (this.regenTicks > 200 && !this.field_70128_L && !(this.func_110143_aJ() <= 0.0f) && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70691_i(1.0f);
            this.regenTicks = 0;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && cause.func_76346_g() instanceof EntityAmethyst) {
            this.func_145779_a((Item)ModItems.RECORD_DUEL_OF_THE_QUARTZ, 1);
        }
        switch (this.getSpecial()) {
            case 0: {
                this.droppedGemItem = ModItems.JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_JASPER_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.OCEAN_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_OCEAN_JASPER_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.BIGGS_JASPER_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BIGGS_JASPER_GEM;
            }
        }
        super.func_70645_a(cause);
    }

    public SoundEvent func_184601_bQ() {
        return ModSounds.JASPER_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.JASPER_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.JASPER_DEATH;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return this.isCharged() ? 0xF000F0 : super.func_70070_b(partialTicks);
    }

    @Override
    public float func_70013_c(float partialTicks) {
        return this.isCharged() ? 1.0f : super.func_70013_c(partialTicks);
    }
}

