/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.ai;

import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class EntityAIPredictFights
extends EntityAITarget {
    private final EntityGem gem;
    private double movementSpeed;
    private Path flightPath;

    public EntityAIPredictFights(EntityGem gem, double movementSpeed) {
        super((EntityCreature)gem, true);
        this.gem = gem;
        this.movementSpeed = movementSpeed;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.gem.func_70643_av() != null;
    }

    public void func_75249_e() {
        if (this.gem.func_70643_av() != null) {
            if (this.gem.isSoldier) {
                EntityLivingBase target = this.gem.func_70643_av();
                double healthRatio = this.gem.func_110143_aJ() / target.func_110143_aJ();
                if (healthRatio >= 1.0 && healthRatio <= 2.0) {
                    this.callForHelp(true);
                } else if (healthRatio >= 2.0) {
                    this.flee(true);
                } else {
                    this.fight();
                }
            } else {
                this.flee(true);
            }
        }
    }

    private void flee(boolean callForHelp) {
        List nearbygems = this.gem.field_70170_p.func_72872_a(EntityGem.class, this.gem.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        EntityGem destination = null;
        double distance = 0.0;
        for (EntityGem fighter : nearbygems) {
            if (this.gem.equals((Object)fighter) || !fighter.isSoldier || !(this.gem.func_70068_e((Entity)fighter) > distance)) continue;
            distance = this.gem.func_70068_e((Entity)fighter);
            destination = fighter;
        }
        if (destination == null) {
            Vec3d randomPosition = RandomPositionGenerator.func_75463_a((EntityCreature)this.gem, (int)24, (int)8);
            if (randomPosition == null) {
                int nextX = this.gem.field_70170_p.field_73012_v.nextInt(24) - 12;
                int nextZ = this.gem.field_70170_p.field_73012_v.nextInt(24) - 12;
                BlockPos pos = this.gem.field_70170_p.func_175672_r(this.gem.func_180425_c().func_177982_a(nextX, 0, nextZ));
                randomPosition = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            this.flightPath = this.gem.func_70661_as().func_75488_a(randomPosition.field_72450_a, randomPosition.field_72448_b, randomPosition.field_72449_c);
        } else {
            this.flightPath = this.gem.func_70661_as().func_75494_a(destination);
        }
        if (callForHelp) {
            this.callForHelp(false);
        }
        this.gem.func_70661_as().func_75484_a(this.flightPath, this.movementSpeed);
    }

    private void callForHelp(boolean victimWillFight) {
        List nearbygems = this.gem.field_70170_p.func_72872_a(EntityGem.class, this.gem.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityGem fighter : nearbygems) {
            if (!fighter.isSoldier) continue;
            fighter.func_70624_b(this.gem.func_70643_av());
        }
        if (victimWillFight) {
            this.fight();
        }
    }

    private void fight() {
        this.gem.func_70624_b(this.gem.func_70643_av());
        this.flightPath = null;
    }
}

