/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import mod.akrivus.kagic.entity.vehicles.EntityRoamingEye;
import mod.akrivus.kagic.util.LaserDamage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLaser
extends Entity {
    public EntityLivingBase shootingEntity;
    public int explosionPower;
    public double accelerationX;
    public double accelerationY;
    public double accelerationZ;

    public EntityLaser(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public EntityLaser(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ, int explosionPower) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.accelerationX = accelX;
        this.accelerationY = accelY;
        this.accelerationZ = accelZ;
        this.explosionPower = explosionPower;
    }

    public EntityLaser(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, int explosionPower) {
        super(worldIn);
        this.shootingEntity = shooter;
        this.func_70105_a(1.0f, 1.0f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.accelerationX = accelX;
        this.accelerationY = accelY;
        this.accelerationZ = accelZ;
        this.explosionPower = explosionPower;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shootingEntity == null || !this.shootingEntity.field_70128_L) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            RayTraceResult raytraceresult = ProjectileHelper.func_188802_a((Entity)this, (boolean)true, (boolean)false, (Entity)this.shootingEntity);
            if (raytraceresult != null) {
                this.onImpact(raytraceresult);
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            this.field_70159_w += this.accelerationX;
            this.field_70181_x += this.accelerationY;
            this.field_70179_y += this.accelerationZ;
            this.field_70159_w *= this.getMotionFactor();
            this.field_70181_x *= this.getMotionFactor();
            this.field_70179_y *= this.getMotionFactor();
            this.field_70170_p.func_175688_a(this.getParticleType(), this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
    }

    protected EnumParticleTypes getParticleType() {
        return EnumParticleTypes.SMOKE_NORMAL;
    }

    protected double getMotionFactor() {
        return 0.75;
    }

    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            boolean destroy = true;
            if (result.field_72308_g != null) {
                if (result.field_72308_g instanceof EntityRoamingEye) {
                    EntityRoamingEye roaming_eye = (EntityRoamingEye)result.field_72308_g;
                    for (Entity passenger : roaming_eye.func_184188_bt()) {
                        if (!passenger.equals((Object)this.shootingEntity)) continue;
                        destroy = false;
                    }
                }
                if (destroy) {
                    result.field_72308_g.func_70097_a((DamageSource)new LaserDamage(), 100.0f);
                }
            }
            if (destroy) {
                this.field_70170_p.func_72885_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionPower, true, true);
                this.func_70106_y();
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        compound.func_74782_a("power", (NBTBase)this.func_70087_a(new double[]{this.accelerationX, this.accelerationY, this.accelerationZ}));
        compound.func_74768_a("explosionPower", this.explosionPower);
    }

    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList nbttaglist;
        if (compound.func_150297_b("power", 9) && (nbttaglist = compound.func_150295_c("power", 6)).func_74745_c() == 3) {
            this.accelerationX = nbttaglist.func_150309_d(0);
            this.accelerationY = nbttaglist.func_150309_d(1);
            this.accelerationZ = nbttaglist.func_150309_d(2);
        }
        this.explosionPower = compound.func_74762_e("explosionPower");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).func_74745_c() == 3) {
            NBTTagList nbttaglist1 = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist1.func_150309_d(0);
            this.field_70181_x = nbttaglist1.func_150309_d(1);
            this.field_70179_y = nbttaglist1.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public float func_70013_c(float partialTicks) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return 0xF000F0;
    }

    protected void func_70088_a() {
    }
}

