/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.akrivus.kagic.entity.EntitySlag;
import mod.akrivus.kagic.entity.ai.EntityAIAttackRangedBow;
import mod.akrivus.kagic.entity.ai.EntityAIPredictFights;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.EntityBlueDiamond;
import mod.akrivus.kagic.entity.gem.EntityYellowDiamond;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModAchievements;
import mod.akrivus.kagic.init.ModConfigs;
import mod.akrivus.kagic.init.ModEnchantments;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.items.ItemAutonomyContract;
import mod.akrivus.kagic.items.ItemGem;
import mod.akrivus.kagic.items.ItemJointContract;
import mod.akrivus.kagic.items.ItemLiberationContract;
import mod.akrivus.kagic.items.ItemTransferContract;
import mod.akrivus.kagic.tileentity.TileEntityWarpPadCore;
import mod.akrivus.kagic.util.PoofDamage;
import mod.akrivus.kagic.util.ShatterDamage;
import mod.akrivus.kagic.util.SlagDamage;
import mod.heimrarnadalr.kagic.worlddata.WarpPadDataEntry;
import mod.heimrarnadalr.kagic.worlddata.WorldDataWarpPad;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGem
extends EntityCreature
implements IEntityOwnable,
IRangedAttackMob {
    public static final int SERVE_NONE = 0;
    public static final int SERVE_HUMAN = 1;
    public static final int SERVE_YELLOW_DIAMOND = 2;
    public static final int SERVE_BLUE_DIAMOND = 3;
    public static final int SERVE_WHITE_DIAMOND = 4;
    public static final int SERVE_REBELLION = 5;
    public static final int SERVE_ITSELF = 6;
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Integer> INSIGNIA_COLOR = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> HAIR = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GEM_CUT = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> GEM_PLACEMENT = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> VISOR = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> FUSION_COUNT = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<String> FUSION_PLACEMENTS = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Boolean> DEFECTIVE = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PRIMARY = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SPECIAL = EntityDataManager.func_187226_a(EntityGem.class, (DataSerializer)DataSerializers.field_187192_b);
    private final EntityAIBase rangedAttack = new EntityAIAttackRangedBow(this, 0.6, 20, 16.0f);
    private final EntityAIBase meleeAttack = new EntityAIAttackMelee((EntityCreature)this, 1.2, true);
    private final EntityAITarget diamondAttackAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new Predicate<EntityLivingBase>(){

        public boolean apply(EntityLivingBase input) {
            if (input instanceof EntityGem) {
                return ((EntityGem)input).getServitude() == 1;
            }
            return input != null && input instanceof EntityPlayer;
        }
    });
    private final EntityAITarget rebelAttackAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new Predicate<EntityLivingBase>(){

        public boolean apply(EntityLivingBase input) {
            if (input instanceof EntityGem) {
                return ((EntityGem)input).isTamed() || ((EntityGem)input).isDiamond;
            }
            return input != null && input instanceof EntityPlayer;
        }
    });
    protected EntityAIStay stayAI;
    public ArrayList<NBTTagCompound> fusionMembers = new ArrayList();
    public int compatIndex;
    private ArrayList<UUID> jointOwners = new ArrayList();
    private UUID leader = null;
    private BlockPos restPosition;
    public ItemGem droppedGemItem;
    public ItemGem droppedCrackedGemItem;
    public int fallbackServitude = -1;
    public boolean wantsToFuse;
    public boolean isSoldier;
    public boolean isDiamond;
    public boolean isSpaceBorn;
    public boolean isAttacking;
    public boolean isPeaceful;
    public boolean isSitting;
    public boolean canTalk;
    private int dimensionOfCreation;
    private int timeUntilBetrayal;
    private int servitude = 0;
    private float pitch = 1.0f;
    protected int visorChanceReciprocal = 3;
    private Map<GemCuts, ArrayList<GemPlacements>> cutPlacements = new HashMap<GemCuts, ArrayList<GemPlacements>>();

    public EntityGem(World worldIn) {
        super(worldIn);
        this.seePastDoors();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.field_70138_W = 0.6f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(GEM_PLACEMENT, (Object)-1);
        this.field_70180_af.func_187214_a(GEM_CUT, (Object)-1);
        this.field_70180_af.func_187214_a(VISOR, (Object)false);
        this.field_70180_af.func_187214_a(INSIGNIA_COLOR, (Object)12);
        this.field_70180_af.func_187214_a(HAIR, (Object)0);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(DEFECTIVE, (Object)false);
        this.field_70180_af.func_187214_a(PRIMARY, (Object)false);
        this.field_70180_af.func_187214_a(SPECIAL, (Object)0);
        this.field_70180_af.func_187214_a(FUSION_COUNT, (Object)1);
        this.field_70180_af.func_187214_a(FUSION_PLACEMENTS, (Object)"");
        this.compatIndex = worldIn.field_73012_v.nextInt(GemPlacements.values().length);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("gemPlacement", this.getGemPlacement().id);
        compound.func_74768_a("gemCut", this.getGemCut().id);
        compound.func_74757_a("hasVisor", this.hasVisor());
        compound.func_74768_a("insigniaColor", this.getInsigniaColor());
        compound.func_74768_a("hair", this.getHairStyle());
        compound.func_74757_a("defective", this.isDefective());
        compound.func_74757_a("primary", this.isPrimary());
        compound.func_74768_a("special", this.getSpecial());
        NBTTagList fusionMembers = new NBTTagList();
        for (int i = 0; i < this.fusionMembers.size(); ++i) {
            fusionMembers.func_74742_a((NBTBase)this.fusionMembers.get(i));
        }
        compound.func_74768_a("fusionCount", this.getFusionCount());
        compound.func_74778_a("fusionPlacements", this.getFusionPlacements());
        compound.func_74782_a("fusionMembers", (NBTBase)fusionMembers);
        if (this.func_184753_b() == null) {
            compound.func_74778_a("ownerId", "");
        } else {
            compound.func_74778_a("ownerId", this.func_184753_b().toString());
        }
        if (this.getLeader() == null) {
            compound.func_74778_a("leaderId", "");
        } else {
            compound.func_74778_a("leaderId", this.leader.toString());
        }
        NBTTagList owners = new NBTTagList();
        for (int i = 0; i < this.jointOwners.size(); ++i) {
            UUID ownerId = this.jointOwners.get(i);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("ownerId", ownerId.toString());
            owners.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("jointOwners", (NBTBase)owners);
        if (this.restPosition != null) {
            compound.func_74780_a("restX", (double)this.restPosition.func_177958_n());
            compound.func_74780_a("restY", (double)this.restPosition.func_177956_o());
            compound.func_74780_a("restZ", (double)this.restPosition.func_177952_p());
        }
        compound.func_74757_a("sitting", this.isSitting());
        compound.func_74768_a("servitude", this.servitude);
        compound.func_74768_a("fallbackServitude", this.fallbackServitude);
        compound.func_74768_a("timeUntilBetrayal", this.timeUntilBetrayal);
        compound.func_74768_a("dimensionOfCreation", this.dimensionOfCreation);
        compound.func_74757_a("wantsToFuse", this.wantsToFuse);
        compound.func_74776_a("pitch", this.pitch);
    }

    public void func_70037_a(NBTTagCompound compound) {
        String leaderId;
        String ownerId;
        super.func_70037_a(compound);
        if (compound.func_74764_b("gemCut")) {
            this.setGemCut(compound.func_74762_e("gemCut"));
            this.setGemPlacement(compound.func_74762_e("gemPlacement"));
        } else {
            this.convertGems(compound.func_74762_e("gemPlacement"));
        }
        if (!(this.isGemPlacementDefined() && this.isGemCutDefined() && this.isCorrectCutPlacement())) {
            this.setNewCutPlacement();
        }
        this.applyGemPlacementBuffs(false);
        this.setHasVisor(compound.func_74767_n("hasVisor"));
        if (compound.func_74764_b("insigniaColor")) {
            this.setInsigniaColor(compound.func_74762_e("insigniaColor"));
        } else {
            this.setInsigniaColor(12);
        }
        this.setHairStyle(compound.func_74762_e("hair"));
        this.setDefective(compound.func_74767_n("defective"));
        this.setPrimary(compound.func_74767_n("primary"));
        NBTTagList fusionMembers = compound.func_150295_c("fusionMembers", 10);
        for (int i = 0; i < fusionMembers.func_74745_c(); ++i) {
            this.fusionMembers.add(fusionMembers.func_150305_b(i));
        }
        this.setFusionCount(compound.func_74762_e("fusionCount"));
        this.setFusionPlacements(compound.func_74779_i("fusionPlacements"));
        this.setSpecial(compound.func_74762_e("special"));
        if (compound.func_150297_b("ownerId", 8)) {
            ownerId = compound.func_74779_i("ownerId");
        } else {
            String tempId = compound.func_74779_i("ownerId");
            ownerId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
        }
        if (!ownerId.isEmpty()) {
            this.setOwnerId(UUID.fromString(ownerId));
        }
        if (compound.func_150297_b("leaderId", 8)) {
            leaderId = compound.func_74779_i("leaderId");
        } else {
            String tempId = compound.func_74779_i("leaderId");
            leaderId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
        }
        if (!leaderId.isEmpty()) {
            this.setLeader(UUID.fromString(leaderId));
        }
        NBTTagList owners = compound.func_150295_c("jointOwners", 10);
        for (int i = 0; i < owners.func_74745_c(); ++i) {
            String jointId;
            NBTTagCompound nbt = owners.func_150305_b(i);
            if (nbt.func_150297_b("ownerId", 8)) {
                jointId = nbt.func_74779_i("ownerId");
            } else {
                String tempId = nbt.func_74779_i("ownerId");
                jointId = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)tempId);
            }
            if (jointId.isEmpty()) continue;
            this.jointOwners.add(UUID.fromString(jointId));
        }
        if (compound.func_74764_b("restX") && compound.func_74764_b("restY") && compound.func_74764_b("restZ")) {
            this.restPosition = new BlockPos(compound.func_74769_h("restX"), compound.func_74769_h("restY"), compound.func_74769_h("restZ"));
        }
        if (this.stayAI != null) {
            this.stayAI.setSitting(compound.func_74767_n("sitting"));
        }
        this.isSitting = compound.func_74767_n("sitting");
        this.servitude = compound.func_74762_e("servitude");
        this.fallbackServitude = compound.func_74762_e("fallbackServitude");
        this.timeUntilBetrayal = compound.func_74762_e("timeUntilBetrayal");
        this.wantsToFuse = compound.func_74767_n("wantsToFuse");
        this.pitch = compound.func_74764_b("pitch") ? compound.func_74760_g("pitch") : 0.7f + this.field_70146_Z.nextFloat() / 2.0f;
        if (compound.func_74764_b("dimensionOfCreation")) {
            this.setDimensionOfCreation(compound.func_74762_e("dimensionOfCreation"));
        } else {
            this.setDimensionOfCreation(this.field_71093_bK);
        }
        this.setAttackAI();
    }

    public void setNewCutPlacement() {
        Set<GemCuts> cuts = this.cutPlacements.keySet();
        int cutIndex = this.field_70146_Z.nextInt(cuts.size());
        GemCuts cut = (GemCuts)((Object)cuts.toArray()[cutIndex]);
        ArrayList<GemPlacements> placements = this.cutPlacements.get((Object)cut);
        int placementIndex = this.field_70146_Z.nextInt(placements.size());
        GemPlacements placement = placements.get(placementIndex);
        this.setGemCut(cut.id);
        this.setGemPlacement(placement.id);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.func_70606_j(this.func_110138_aP());
        if (!(this.isGemPlacementDefined() && this.isGemCutDefined() && this.isCorrectCutPlacement())) {
            this.setNewCutPlacement();
        }
        this.applyGemPlacementBuffs(true);
        this.setHasVisor(this.field_70146_Z.nextInt(this.visorChanceReciprocal) == 0);
        this.setDimensionOfCreation(this.field_71093_bK);
        this.setAttackAI();
        if (this.fallbackServitude == -1) {
            this.fallbackServitude = 0;
        }
        this.pitch = 0.7f + this.field_70146_Z.nextFloat() / 2.0f;
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean canChangeInsigniaColorByDefault() {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_70636_d() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && this.func_70638_az() instanceof EntityPlayer) {
            this.func_70624_b(null);
        }
        if (this.isPeaceful) {
            this.func_70624_b(null);
            this.isPeaceful = false;
        }
        if (this.isDefective()) {
            this.whenDefective();
        }
        if (this.fallbackServitude > 0 && ModConfigs.canRebel) {
            if ((double)this.timeUntilBetrayal > this.field_70146_Z.nextDouble() * 4.0 * 24000.0) {
                this.servitude = this.fallbackServitude;
            }
            ++this.timeUntilBetrayal;
        }
        super.func_70636_d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) return super.func_184645_a(player, hand);
        if (hand != EnumHand.MAIN_HAND) return super.func_184645_a(player, hand);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.GEM_STAFF) {
            if (this.isTamed()) {
                if (player.func_70093_af()) {
                    this.alternateInteract(player);
                    this.playObeySound();
                    return super.func_184645_a(player, hand);
                }
                if (this.isOwner((EntityLivingBase)player)) {
                    this.setSitting(player);
                    this.playObeySound();
                    return super.func_184645_a(player, hand);
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
            this.setOwnerId(player.func_110124_au());
            this.setLeader(player);
            this.setServitude(1);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_70606_j(this.func_110138_aP());
            this.playTameEffect();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.playObeySound();
            player.func_71029_a((StatBase)ModAchievements.I_MADE_YOU);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.now_serves_you", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == ModItems.CRACKED_BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.CRACKED_YELLOW_DIAMOND_GEM || stack.func_77973_b() == ModItems.BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.YELLOW_DIAMOND_GEM) {
            if (this.getServitude() == 1) return super.func_184645_a(player, hand);
            this.setOwnerId(player.func_110124_au());
            this.setLeader(player);
            this.setServitude(1);
            this.field_70699_by.func_75499_g();
            this.func_70624_b(null);
            this.func_70606_j(this.func_110138_aP());
            this.playTameEffect();
            this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            this.playObeySound();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.now_serves_you", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == ModItems.TRANSFER_CONTRACT) {
            if (!this.isTamed()) return super.func_184645_a(player, hand);
            if (this.isOwner((EntityLivingBase)player)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.already_serves_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
            ItemTransferContract contract = (ItemTransferContract)stack.func_77973_b();
            if (this.isOwnerId(contract.getOwner(stack))) {
                if (contract.getOwner(stack).equals(this.func_184753_b())) {
                    if (this.leader.equals(this.func_184753_b())) {
                        this.setLeader(player);
                    }
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.ownership_transfered", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                } else {
                    for (UUID ownerId : this.jointOwners) {
                        if (!contract.getOwner(stack).equals(ownerId)) continue;
                        if (this.leader.equals(this.func_184753_b())) {
                            this.setLeader(player);
                        }
                        try {
                            this.field_70170_p.func_152378_a(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())).func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.ownership_transfered", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ownerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    }
                }
                this.playObeySound();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.now_serves_you", new Object[]{this.func_70005_c_()}));
                this.setOwnerId(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
                if (player.field_71075_bZ.field_75098_d) return true;
                stack.func_190918_g(1);
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_signee", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == ModItems.JOINT_CONTRACT) {
            if (!this.isTamed()) return super.func_184645_a(player, hand);
            if (this.isOwner((EntityLivingBase)player)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.already_serves_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
            ItemJointContract contract = (ItemJointContract)stack.func_77973_b();
            if (this.isOwnerId(contract.getOwner(stack))) {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.joint_ownership_added", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                for (UUID ownerId : this.jointOwners) {
                    try {
                        this.field_70170_p.func_152378_a(ownerId).func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.joint_ownership_added", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                    }
                    catch (Exception exception) {}
                }
                this.jointOwners.add(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
                this.playObeySound();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.now_serves_you", new Object[]{this.func_70005_c_()}));
                if (player.field_71075_bZ.field_75098_d) return true;
                stack.func_190918_g(1);
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_signee", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == ModItems.LIBERATION_CONTRACT) {
            if (!this.isTamed()) return super.func_184645_a(player, hand);
            ItemLiberationContract contract = (ItemLiberationContract)stack.func_77973_b();
            if (this.isOwnerId(contract.getOwner(stack))) {
                if (contract.getOwner(stack).equals(this.func_184753_b())) {
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_liberated_by", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                } else {
                    for (UUID ownerId : this.jointOwners) {
                        if (!contract.getOwner(stack).equals(ownerId)) continue;
                        try {
                            this.field_70170_p.func_152378_a(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())).func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_liberated_by", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ownerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    }
                }
                this.playObeySound();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_liberated", new Object[]{this.func_70005_c_()}));
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.setServitude(0);
                this.setOwnerId((UUID)null);
                this.setLeader((UUID)null);
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_signee", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == ModItems.AUTONOMY_CONTRACT) {
            if (!this.isTamed()) return super.func_184645_a(player, hand);
            ItemAutonomyContract contract = (ItemAutonomyContract)stack.func_77973_b();
            if (this.isOwnerId(contract.getOwner(stack))) {
                if (contract.getOwner(stack).equals(this.func_184753_b())) {
                    if (this.leader.equals(this.func_184753_b())) {
                        this.setLeader(player);
                    }
                    this.getOwner().func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_autonomous_by", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                } else {
                    for (UUID ownerId : this.jointOwners) {
                        if (!contract.getOwner(stack).equals(ownerId)) continue;
                        if (this.leader.equals(this.func_184753_b())) {
                            this.setLeader(player);
                        }
                        try {
                            this.field_70170_p.func_152378_a(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH())).func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_liberated_by", new Object[]{this.func_70005_c_(), player.func_70005_c_()}));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ownerId = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
                    }
                }
                this.playObeySound();
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.gem_autonomous", new Object[]{this.func_70005_c_()}));
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                this.setOwnerId((UUID)null);
                this.setLeader((UUID)null);
                this.setServitude(6);
                return true;
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_signee", new Object[]{this.func_70005_c_()}));
            return true;
        }
        if (stack.func_77973_b() == Items.field_151100_aR && this.canChangeInsigniaColorByDefault()) {
            if (!this.isTamed()) return super.func_184645_a(player, hand);
            if (!this.isOwner((EntityLivingBase)player)) return super.func_184645_a(player, hand);
            this.setInsigniaColor(15 - stack.func_77952_i());
            return true;
        }
        if (stack.func_190926_b()) {
            this.setAttackWeapon(player, hand, stack);
            return super.func_184645_a(player, hand);
        } else {
            if (!this.isSoldier) return super.func_184645_a(player, hand);
            if (super.func_184645_a(player, hand)) return true;
            if (!this.setAttackWeapon(player, hand, stack)) return false;
            return true;
        }
    }

    public boolean alternateInteract(EntityPlayer player) {
        KAGIC.instance.chatInfoMessage("Cut is " + (Object)((Object)this.getGemCut()) + " and Placement is " + (Object)((Object)this.getGemPlacement()));
        return false;
    }

    public boolean setAttackWeapon(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (this.isFusion()) {
            return false;
        }
        if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
            boolean toolChanged = true;
            if (!this.isCoreItem(stack) && (stack.func_190926_b() || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemBow)) {
                if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                    this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                } else {
                    toolChanged = false;
                }
                if (toolChanged) {
                    ItemStack heldItem = stack.func_77946_l();
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                    this.playObeySound();
                    this.setAttackAI();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
                return true;
            }
            if (stack.func_77973_b() instanceof ItemArrow || stack.func_77973_b() instanceof ItemShield) {
                if (!this.func_184582_a(EntityEquipmentSlot.OFFHAND).func_185136_b(stack)) {
                    this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.OFFHAND), 0.0f);
                } else {
                    toolChanged = false;
                }
                if (toolChanged) {
                    ItemStack heldItem = stack.func_77946_l();
                    this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
                    this.playObeySound();
                    this.setAttackAI();
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                }
            }
        }
        return false;
    }

    public void setFusionWeapon(ItemStack weapon) {
        if (!this.isFusion()) {
            return;
        }
        if (weapon.func_77973_b() instanceof ItemSword || weapon.func_77973_b() instanceof ItemTool || weapon.func_77973_b() instanceof ItemBow) {
            ItemStack heldItem = weapon.func_77946_l();
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
        } else if (weapon.func_77973_b() instanceof ItemArrow || weapon.func_77973_b() instanceof ItemShield) {
            ItemStack heldItem = weapon.func_77946_l();
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, heldItem);
        }
        this.setAttackAI();
    }

    public boolean onSpokenTo(EntityPlayer player, String message) {
        if (this.isBeingCalledBy(player, message = message.toLowerCase())) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isMatching("regex.kagic.follow", message)) {
                    if (this.isSitting()) {
                        this.isSitting = false;
                        this.restPosition = null;
                        return true;
                    }
                    return false;
                }
                if (this.isMatching("regex.kagic.come", message)) {
                    this.setRestPosition(player.func_180425_c());
                    this.func_70661_as().func_75497_a((Entity)player, 1.0);
                    return true;
                }
                if (this.isMatching("regex.kagic.stop", message)) {
                    this.func_70661_as().func_75499_g();
                    if (!this.isSitting()) {
                        this.isSitting = true;
                        this.restPosition = this.func_180425_c();
                        this.setLeader(player);
                    }
                    return true;
                }
                if (this.isMatching("regex.kagic.warp", message)) {
                    ArrayList<String> args = this.getArgsFrom("regex.kagic.warp", message);
                    if (args.size() > 0) {
                        this.warp(player, args.get(0));
                    }
                } else if (this.isSoldier) {
                    if (this.isMatching("regex.kagic.kill", message)) {
                        ArrayList<String> args = this.getArgsFrom("regex.kagic.kill", message);
                        if (args.size() > 0) {
                            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 16.0, 48.0));
                            double distance = Double.MAX_VALUE;
                            for (EntityLivingBase base : list) {
                                double newDistance = this.func_70068_e((Entity)base);
                                if (!(newDistance <= distance) || !base.func_70005_c_().toLowerCase().contains(args.get(0)) || !this.shouldAttackEntity((EntityLivingBase)this, base)) continue;
                                this.func_70604_c(base);
                                distance = newDistance;
                            }
                        }
                        return this.func_70643_av() != null;
                    }
                    if (this.isMatching("regex.kagic.help", message)) {
                        ArrayList<String> args = this.getArgsFrom("regex.kagic.help", message);
                        if (args.size() > 0) {
                            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 16.0, 48.0));
                            double distance = Double.MAX_VALUE;
                            for (EntityLivingBase base : list) {
                                double newDistance = this.func_70068_e((Entity)base);
                                if (!(newDistance <= distance) || !base.func_70005_c_().toLowerCase().contains(args.get(0)) || !this.shouldAttackEntity((EntityLivingBase)this, base)) continue;
                                this.func_70661_as().func_75497_a((Entity)base, 1.0);
                                this.func_70604_c(base.func_70643_av());
                                distance = newDistance;
                            }
                        }
                        return this.func_70643_av() != null;
                    }
                    if (this.isMatching("regex.kagic.retreat", message)) {
                        boolean retreated = this.func_70638_az() != null;
                        this.func_70624_b(null);
                        return retreated;
                    }
                }
            }
        }
        return false;
    }

    public ArrayList<String> getArgsFrom(String key, String message) {
        Matcher matcher = Pattern.compile(new TextComponentTranslation(key, new Object[0]).func_150261_e()).matcher(message);
        ArrayList<String> results = new ArrayList<String>();
        if (matcher.find()) {
            MatchResult matches = matcher.toMatchResult();
            for (int i = 1; i < matches.groupCount(); ++i) {
                if (matches.group(i) == null) continue;
                results.add(matches.group(i));
            }
        }
        return results;
    }

    public boolean isMatching(String key, String message) {
        return Pattern.compile(new TextComponentTranslation(key, new Object[0]).func_150261_e()).matcher(message).find();
    }

    public boolean isBeingCalledBy(EntityPlayer player, String message) {
        return message.contains(this.func_70005_c_().toLowerCase()) || message.contains(new TextComponentTranslation(this.func_70022_Q().replaceFirst("kagic:", "entity.") + ".name.plural", new Object[0]).func_150261_e().toLowerCase()) || message.contains(new TextComponentTranslation("entity.kagic.gem.name.plural", new Object[0]).func_150254_d().toLowerCase()) || this.isPlayerLookingAt(player);
    }

    public boolean isPlayerLookingAt(EntityPlayer player) {
        Vec3d raycast = player.func_70676_i(1.0f).func_72432_b();
        Vec3d view = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)this.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double length = view.func_72433_c();
        double product = raycast.func_72430_b(view = view.func_72432_b());
        return product > 1.0 - 0.025 / length ? player.func_70685_l((Entity)this) : false;
    }

    public void warp(EntityPlayer player, String destination) {
        TileEntityWarpPadCore pad = TileEntityWarpPadCore.getEntityPad((Entity)this);
        if (pad != null && pad.isValidPad() && !pad.isWarping()) {
            if (!pad.isValid()) {
                this.talkTo(player, new TextComponentTranslation("notify.kagic.padnotvalid", new Object[0]).func_150261_e());
                return;
            }
            if (!pad.isClear()) {
                this.talkTo(player, new TextComponentTranslation("notify.kagic.padnotclear", new Object[0]).func_150261_e());
                return;
            }
            if (pad.name.toLowerCase() == destination) {
                this.talkTo(player, new TextComponentTranslation("notify.kagic.alreadyhere", new Object[0]).func_150261_e());
                return;
            }
            Map<BlockPos, WarpPadDataEntry> padData = WorldDataWarpPad.get(this.field_70170_p).getWarpPadData();
            SortedMap<Double, BlockPos> sortedPoses = WorldDataWarpPad.getSortedPositions(padData, pad.func_174877_v());
            for (BlockPos pos : sortedPoses.values()) {
                WarpPadDataEntry data = padData.get(pos);
                if (!data.name.toLowerCase().equals(destination)) continue;
                TileEntityWarpPadCore dest = (TileEntityWarpPadCore)this.func_130014_f_().func_175625_s(pos);
                if (!dest.isValid()) {
                    this.talkTo(player, new TextComponentTranslation("notify.kagic.destnotvalid", new Object[0]).func_150261_e());
                    return;
                }
                if (!dest.isClear()) {
                    this.talkTo(player, new TextComponentTranslation("notify.kagic.destnotclear", new Object[0]).func_150261_e());
                    return;
                }
                this.talkTo(player, new TextComponentTranslation("notify.kagic.warping", new Object[]{data.name}).func_150261_e());
                this.playObeySound();
                pad.beginWarp(pos);
                return;
            }
            this.talkTo(player, new TextComponentTranslation("notify.kagic.nopad", new Object[]{destination}).func_150261_e());
        }
    }

    public void talkTo(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + message));
    }

    public boolean canPickUpItem(Item itemIn) {
        return false;
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.isTamed() && this.isOwner((EntityLivingBase)player);
    }

    public boolean isCoreItem(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.CRACKED_BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.CRACKED_YELLOW_DIAMOND_GEM || stack.func_77973_b() == ModItems.BLUE_DIAMOND_GEM || stack.func_77973_b() == ModItems.YELLOW_DIAMOND_GEM) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151100_aR && this.canChangeInsigniaColorByDefault()) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.GEM_STAFF) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.TRANSFER_CONTRACT) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.JOINT_CONTRACT) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.AUTONOMY_CONTRACT) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.LIBERATION_CONTRACT) {
            return true;
        }
        if (stack.func_77973_b() == Items.field_151057_cb) {
            return true;
        }
        return stack.func_77973_b() == Items.field_151058_ca;
    }

    public float[] getGemColor() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public void setCutPlacement(GemCuts cut, GemPlacements placement) {
        if (this.cutPlacements.containsKey((Object)cut)) {
            this.cutPlacements.get((Object)cut).add(placement);
        } else {
            ArrayList<GemPlacements> placements = new ArrayList<GemPlacements>();
            placements.add(placement);
            this.cutPlacements.put(cut, placements);
        }
    }

    public boolean isCorrectCutPlacement() {
        if (this.cutPlacements.containsKey((Object)this.getGemCut())) {
            return this.cutPlacements.get((Object)this.getGemCut()).contains((Object)this.getGemPlacement());
        }
        return false;
    }

    public boolean isGemPlacementDefined() {
        return this.getGemPlacement() != GemPlacements.UNKNOWN;
    }

    public boolean isGemCutDefined() {
        return this.getGemCut() != GemCuts.UNKNOWN;
    }

    public GemCuts getGemCut() {
        return GemCuts.values()[(Integer)this.field_70180_af.func_187225_a(GEM_CUT) + 1];
    }

    public void setGemCut(int gemCut) {
        this.field_70180_af.func_187227_b(GEM_CUT, (Object)gemCut);
    }

    public GemPlacements getGemPlacement() {
        return GemPlacements.values()[(Integer)this.field_70180_af.func_187225_a(GEM_PLACEMENT) + 1];
    }

    public void setGemPlacement(int gemPlacement) {
        this.field_70180_af.func_187227_b(GEM_PLACEMENT, (Object)gemPlacement);
    }

    public void convertGems(int placement) {
    }

    public void applyGemPlacementBuffs(boolean initialSpawn) {
        switch (this.getGemPlacement()) {
            case FOREHEAD: {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPredictFights(this, 0.9));
                break;
            }
            case MOUTH: {
                this.canTalk = false;
                break;
            }
            case LEFT_HAND: {
                if (!initialSpawn) break;
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 2.0);
                break;
            }
            case RIGHT_HAND: {
                if (!initialSpawn) break;
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 2.0);
                break;
            }
            case BACK: {
                this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 0.9));
                break;
            }
            case CHEST: {
                if (!initialSpawn) break;
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 2.5);
                break;
            }
            case BELLY: {
                if (this.fallbackServitude == -1 && this.field_70146_Z.nextInt(8) == 0 && ModConfigs.canRebel) {
                    this.fallbackServitude = 5;
                    break;
                }
                this.fallbackServitude = 0;
                break;
            }
            case RIGHT_KNEE: {
                this.func_70659_e(this.func_70689_ay() * 1.2f);
                break;
            }
            case LEFT_KNEE: {
                this.func_70659_e(this.func_70689_ay() * 1.2f);
            }
        }
    }

    public boolean hasVisor() {
        return (Boolean)this.field_70180_af.func_187225_a(VISOR);
    }

    public void setHasVisor(boolean hasVisor) {
        this.field_70180_af.func_187227_b(VISOR, (Object)hasVisor);
    }

    public int getInsigniaColor() {
        return (Integer)this.field_70180_af.func_187225_a(INSIGNIA_COLOR);
    }

    public void setInsigniaColor(int insigniaColor) {
        this.field_70180_af.func_187227_b(INSIGNIA_COLOR, (Object)insigniaColor);
    }

    public int getHairStyle() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR);
    }

    public void setHairStyle(int hairstyle) {
        this.field_70180_af.func_187227_b(HAIR, (Object)hairstyle);
    }

    public boolean isDefective() {
        return (Boolean)this.field_70180_af.func_187225_a(DEFECTIVE);
    }

    public void setDefective(boolean defective) {
        this.field_70180_af.func_187227_b(DEFECTIVE, (Object)defective);
        if (defective) {
            this.whenDefective();
        }
    }

    public void whenDefective() {
    }

    public boolean isPrimary() {
        return (Boolean)this.field_70180_af.func_187225_a(PRIMARY);
    }

    public void setPrimary(boolean primary) {
        this.field_70180_af.func_187227_b(PRIMARY, (Object)primary);
        this.whenPrimary();
    }

    public void whenPrimary() {
    }

    public void seePastDoors() {
        ((PathNavigateGround)this.func_70661_as()).func_179688_b(true);
    }

    protected int getSpecial() {
        return (Integer)this.field_70180_af.func_187225_a(SPECIAL);
    }

    protected void setSpecial(int special) {
        this.field_70180_af.func_187227_b(SPECIAL, (Object)special);
    }

    public boolean isTamed() {
        return this.func_184753_b() != null || this.servitude > 1 || this.isDiamond;
    }

    public boolean isSitting() {
        return this.isSitting;
    }

    public void setSitting(EntityPlayer player) {
        if (player != null) {
            if (this.isSitting()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.will_follow_you", new Object[]{this.func_70005_c_()}));
                this.isSitting = false;
                this.restPosition = null;
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.will_not_follow_you", new Object[]{this.func_70005_c_()}));
                this.isSitting = true;
                this.restPosition = this.func_180425_c();
                this.setLeader(player);
            }
        }
    }

    public void setOwnerId(UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)ownerId));
    }

    public void setOwnerId(String ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)UUID.fromString(ownerId)));
    }

    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public EntityPlayer getOwner() {
        EntityPlayer owner = null;
        double distance = Double.MAX_VALUE;
        for (EntityPlayer playerIn : this.field_70170_p.field_73010_i) {
            if (EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(this.func_184753_b())) {
                if (!(this.func_174818_b(playerIn.func_180425_c()) <= distance)) continue;
                distance = this.func_174818_b(playerIn.func_180425_c());
                owner = playerIn;
                continue;
            }
            for (UUID ownerId : this.jointOwners) {
                if (!EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(ownerId) || !(this.func_174818_b(playerIn.func_180425_c()) <= distance)) continue;
                distance = this.func_174818_b(playerIn.func_180425_c());
                owner = playerIn;
            }
        }
        return owner;
    }

    public UUID getLeader() {
        return this.leader;
    }

    public EntityPlayer getLeaderEntity() {
        try {
            return this.field_70170_p.func_152378_a(this.leader);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setLeader(EntityPlayer newLeader) {
        try {
            if (this.leader != null && !this.leader.equals(EntityPlayer.func_146094_a((GameProfile)newLeader.func_146103_bH()))) {
                EntityPlayer oldLeader = this.field_70170_p.func_152378_a(this.leader);
                oldLeader.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.following_someone_else", new Object[]{this.func_70005_c_(), newLeader.func_70005_c_()}));
            }
            this.leader = EntityPlayer.func_146094_a((GameProfile)newLeader.func_146103_bH());
        }
        catch (Exception e) {
            this.leader = null;
        }
    }

    public void setLeader(UUID newLeader) {
        this.leader = newLeader;
    }

    public BlockPos getRestPosition() {
        return this.restPosition;
    }

    public void setRestPosition(BlockPos pos) {
        this.restPosition = pos;
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        if (this.servitude == 1) {
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer playerIn = (EntityPlayer)entityIn;
                if (playerIn.func_110124_au().equals(this.func_184753_b())) {
                    return true;
                }
                for (UUID ownerId : this.jointOwners) {
                    if (!playerIn.func_110124_au().equals(ownerId)) continue;
                    return true;
                }
            }
        } else {
            if (this.servitude == 3) {
                return entityIn instanceof EntityBlueDiamond;
            }
            if (this.servitude == 2) {
                return entityIn instanceof EntityYellowDiamond;
            }
        }
        return false;
    }

    public boolean isOwnerId(UUID uuid) {
        if (uuid.equals(this.func_184753_b())) {
            return true;
        }
        for (UUID ownerId : this.jointOwners) {
            if (!uuid.equals(ownerId)) continue;
            return true;
        }
        return false;
    }

    public EntityAIStay getAIStay() {
        return this.stayAI;
    }

    public int getFusionCount() {
        return (Integer)this.field_70180_af.func_187225_a(FUSION_COUNT);
    }

    public void setFusionCount(int count) {
        this.field_70180_af.func_187227_b(FUSION_COUNT, (Object)count);
    }

    public String getFusionPlacements() {
        return (String)this.field_70180_af.func_187225_a(FUSION_PLACEMENTS);
    }

    public void setFusionPlacements(String fusionPlacements) {
        this.field_70180_af.func_187227_b(FUSION_PLACEMENTS, (Object)fusionPlacements);
    }

    public String generateFusionPlacements() {
        String fusionPlacements = "";
        for (int i = 0; i < this.fusionMembers.size(); ++i) {
            fusionPlacements = i > 0 ? fusionPlacements + " " + this.fusionMembers.get(i).func_74762_e("gemPlacement") + "_" + this.fusionMembers.get(i).func_74762_e("gemCut") : fusionPlacements + this.fusionMembers.get(i).func_74762_e("gemPlacement") + "_" + this.fusionMembers.get(i).func_74762_e("gemCut");
        }
        this.setFusionPlacements(fusionPlacements);
        return fusionPlacements;
    }

    public boolean canFuse() {
        return (this.isFusion() || !this.isFusion() && this.field_70173_aa > 40) && !this.isDefective() && this.getFusionCount() < 10;
    }

    public void unfuse() {
    }

    public boolean isFusion() {
        return this.getFusionCount() > 1;
    }

    public boolean shouldAttackEntity(EntityLivingBase attacker, EntityLivingBase victim) {
        return !this.func_184191_r((Entity)victim);
    }

    public void setAttackAI() {
        this.field_70714_bg.func_85156_a(this.rangedAttack);
        this.field_70714_bg.func_85156_a(this.meleeAttack);
        if (this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == Items.field_151031_f) {
            this.field_70714_bg.func_75776_a(1, this.rangedAttack);
        } else {
            this.field_70714_bg.func_75776_a(1, this.meleeAttack);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70128_L || this.func_110143_aJ() <= 0.0f) {
                return false;
            }
            if (this.isSpaceBorn) {
                return false;
            }
            if (this.isPeaceful) {
                this.isPeaceful = false;
                return false;
            }
            switch (this.dimensionOfCreation) {
                case -1: {
                    if (source.func_94541_c() || source.func_76347_k()) {
                        return false;
                    }
                    if (source != DamageSource.field_76380_i) break;
                    this.func_70664_aZ();
                    break;
                }
                case 1: {
                    if (!source.func_82725_o() && !source.func_76352_a()) break;
                    return false;
                }
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)source.func_76346_g();
                ItemStack heldItem = attacker.func_184614_ca();
                if (heldItem.func_77948_v()) {
                    NBTTagList enchantments = heldItem.func_77986_q();
                    for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                        if (enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.FAIR_FIGHT)) continue;
                        if (this.isFusion()) {
                            this.unfuse();
                            continue;
                        }
                        this.func_70097_a(new PoofDamage(), this.func_110143_aJ());
                    }
                } else if (heldItem.func_77973_b() == ModItems.GEM_STAFF && this.isOwner(attacker)) {
                    if (this.isFusion()) {
                        this.unfuse();
                    } else {
                        this.func_70097_a(new PoofDamage(), this.func_110143_aJ());
                    }
                }
            }
        }
        this.canTalk = false;
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
            try {
                ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)((EntityLivingBase)entityIn), (Object)100, (String[])new String[]{"recentlyHit", "field_70718_bc", "aT"});
                KAGIC.instance.chatInfoMessage("Set recentlyHit to 100");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f);
        this.func_184609_a(EnumHand.MAIN_HAND);
        if (flag) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack;
        boolean flame;
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double distanceFromTargetX = target.field_70165_t - this.field_70165_t;
        double distanceFromTargetY = target.func_174813_aQ().field_72338_b + (double)target.field_70131_O - arrow.field_70163_u;
        double distanceFromTargetZ = target.field_70161_v - this.field_70161_v;
        double distanceFromTargetS = MathHelper.func_76133_a((double)(distanceFromTargetX * distanceFromTargetX + distanceFromTargetY * distanceFromTargetY));
        arrow.func_70186_c(distanceFromTargetX, distanceFromTargetY + distanceFromTargetS * (double)0.2f, distanceFromTargetZ, 1.6f, 0.0f);
        arrow.func_70239_b((double)distanceFactor * 2.0 + this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111125_b() + this.field_70146_Z.nextGaussian() * 0.25);
        int power = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int punch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        boolean bl = flame = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0;
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (flame) {
            arrow.func_70015_d(100);
        }
        if ((itemstack = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_185167_i) {
            arrow.func_184555_a(itemstack);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    public void func_70612_e(float strafe, float forward) {
        if (this.getGemPlacement() == GemPlacements.NOSE && (this.func_70638_az() != null || this.func_70643_av() != null)) {
            forward *= 2.0f;
            strafe *= 2.0f;
        }
        if (this.dimensionOfCreation == -1) {
            this.field_70181_x = this.field_70181_x > 0.0 ? (this.field_70181_x *= 2.0) : (this.field_70181_x *= 0.5);
        }
        super.func_70612_e(strafe, forward);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isSpaceBorn) {
            if (this.field_70146_Z.nextBoolean() && ModConfigs.canRebel) {
                this.fallbackServitude = 2;
            }
            if (this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70131_O + this.field_70130_N, true, true);
                this.isSpaceBorn = false;
            } else if (this.isSpaceBorn) {
                for (int i = 0; i < this.field_70146_Z.nextInt(7) + 7; ++i) {
                    this.createFireworks();
                }
                this.isSpaceBorn = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public Team func_96124_cp() {
        EntityPlayer entitylivingbase;
        if (this.isTamed() && (entitylivingbase = this.getOwner()) != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entity) {
        if (entity instanceof EntityGem) {
            EntityGem gem = (EntityGem)entity;
            if (gem.getServitude() == this.getServitude()) {
                if (gem.getServitude() == 1) {
                    return gem.func_184753_b().equals(this.func_184753_b());
                }
                return true;
            }
        } else if (this.isTamed()) {
            EntityPlayer entitylivingbase = this.getOwner();
            if (entity.equals((Object)entitylivingbase)) {
                return true;
            }
            if (entitylivingbase != null) {
                return entitylivingbase.func_184191_r(entity);
            }
        }
        return super.func_184191_r(entity);
    }

    public int getServitude() {
        return this.servitude;
    }

    public void setServitude(int servitude) {
        this.servitude = servitude;
        if (!this.isDiamond) {
            switch (this.servitude) {
                case 2: {
                    this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.diamondAttackAI);
                    this.setInsigniaColor(4);
                    break;
                }
                case 3: {
                    this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.diamondAttackAI);
                    this.setInsigniaColor(11);
                    break;
                }
                case 4: {
                    this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.diamondAttackAI);
                    this.setInsigniaColor(0);
                    break;
                }
                case 5: {
                    this.field_70715_bh.func_75776_a(2, (EntityAIBase)this.rebelAttackAI);
                    this.setInsigniaColor(6);
                }
            }
        }
    }

    public boolean isTraitor() {
        return this.fallbackServitude != this.servitude && this.fallbackServitude > 0 && ModConfigs.canRebel;
    }

    public int getDimensionOfCreation() {
        return this.dimensionOfCreation;
    }

    public void setDimensionOfCreation(int dimension) {
        this.dimensionOfCreation = dimension;
        if (dimension == -1) {
            this.field_70178_ae = true;
        }
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.isFusion()) {
                this.unfuse();
                this.func_70106_y();
            } else {
                ItemStack stack = new ItemStack((Item)this.droppedGemItem);
                boolean shattered = false;
                boolean enchanted = false;
                if (cause.func_76346_g() instanceof EntityLivingBase) {
                    ItemStack heldItem = ((EntityLivingBase)cause.func_76346_g()).func_184614_ca();
                    if (heldItem.func_77948_v()) {
                        NBTTagList enchantments = heldItem.func_77986_q();
                        for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                            EntityPlayer player;
                            if (enchantments.func_150305_b(i).func_74762_e("id") == Enchantment.func_185258_b((Enchantment)ModEnchantments.BREAKING_POINT)) {
                                if (cause.func_76346_g() instanceof EntityPlayer) {
                                    player = (EntityPlayer)cause.func_76346_g();
                                    player.func_71029_a((StatBase)ModAchievements.NOW_THATS_A_WEAPON);
                                }
                                stack = new ItemStack((Item)this.droppedCrackedGemItem);
                                enchanted = true;
                                shattered = true;
                                continue;
                            }
                            if (enchantments.func_150305_b(i).func_74762_e("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.FAIR_FIGHT)) continue;
                            if (cause.func_76346_g() instanceof EntityPlayer) {
                                player = (EntityPlayer)cause.func_76346_g();
                                player.func_71029_a((StatBase)ModAchievements.MY_BEST_WORK);
                            }
                            stack = new ItemStack((Item)this.droppedGemItem);
                            enchanted = true;
                        }
                    } else if (heldItem.func_77973_b() == ModItems.GEM_STAFF) {
                        stack = new ItemStack((Item)this.droppedGemItem);
                        enchanted = true;
                    }
                }
                if (!enchanted) {
                    if (this.field_70146_Z.nextInt(80) == 0) {
                        stack = new ItemStack((Item)this.droppedCrackedGemItem);
                        shattered = true;
                    } else {
                        stack = new ItemStack((Item)this.droppedGemItem);
                    }
                }
                if (shattered) {
                    this.func_184185_a(ModSounds.GEM_SHATTER, 3.0f, 1.0f);
                    cause = new ShatterDamage();
                } else {
                    this.func_184185_a(ModSounds.GEM_POOF, 3.0f, 1.0f);
                    cause = new PoofDamage();
                }
                if (cause.func_76346_g() instanceof EntitySlag) {
                    cause = new SlagDamage();
                }
                if (this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages")) {
                    for (EntityPlayer playerIn : this.field_70170_p.field_73010_i) {
                        if (EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(this.func_184753_b())) {
                            playerIn.func_145747_a(cause.func_151519_b((EntityLivingBase)this));
                            continue;
                        }
                        for (UUID ownerId : this.jointOwners) {
                            if (!EntityPlayer.func_146094_a((GameProfile)playerIn.func_146103_bH()).equals(ownerId)) continue;
                            playerIn.func_145747_a(cause.func_151519_b((EntityLivingBase)this));
                        }
                    }
                }
                if (!stack.func_190926_b()) {
                    ((ItemGem)stack.func_77973_b()).setData(this, stack);
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }
        super.func_70645_a(cause);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 7) {
            this.playTameEffect();
        } else {
            super.func_70103_a(id);
        }
    }

    public void playTameEffect() {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.VILLAGER_HAPPY;
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void createFireworks() {
        NBTTagList explosions = new NBTTagList();
        NBTTagCompound explosion = new NBTTagCompound();
        explosion.func_74783_a("Colors", new int[]{this.field_70170_p.field_73012_v.nextInt(0xFFFFFF)});
        explosion.func_74783_a("FadeColors", new int[]{this.field_70170_p.field_73012_v.nextInt(0xFFFFFF)});
        explosion.func_74757_a("Trail", this.field_70170_p.field_73012_v.nextBoolean());
        explosion.func_74757_a("Flicker", this.field_70170_p.field_73012_v.nextBoolean());
        explosions.func_74742_a((NBTBase)explosion);
        ItemStack stack = new ItemStack(Items.field_151152_bP);
        stack.func_190925_c("Fireworks").func_74774_a("Flight", (byte)this.field_70146_Z.nextInt(3));
        stack.func_190925_c("Fireworks").func_74782_a("Explosions", (NBTBase)explosions);
        EntityFireworkRocket firework = new EntityFireworkRocket(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stack);
        this.field_70170_p.func_72838_d((Entity)firework);
    }

    public float func_70647_i() {
        return this.pitch;
    }

    public int func_70627_aG() {
        return 200;
    }

    public SoundEvent getObeySound() {
        return null;
    }

    public void playObeySound() {
        if (this.getObeySound() != null) {
            this.func_184185_a(this.getObeySound(), this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_70642_aH() {
        if (ModConfigs.canGemsMakeSounds && this.canTalk) {
            super.func_70642_aH();
        }
    }

    public void func_184581_c(DamageSource source) {
        if (ModConfigs.canGemsMakeSounds) {
            super.func_184581_c(source);
        } else {
            this.func_184185_a(SoundEvents.field_187543_bD, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float partialTicks) {
        return this.isSpaceBorn ? 0xF000F0 : super.func_70070_b(partialTicks);
    }

    public float func_70013_c(float partialTicks) {
        return this.isSpaceBorn ? 1.0f : super.func_70013_c(partialTicks);
    }
}

