/*
 * Decompiled with CFR 0.152.
 */
package mod.heimrarnadalr.kagic.networking;

import io.netty.buffer.ByteBuf;
import mod.heimrarnadalr.kagic.networking.KTPacketHandler;
import mod.heimrarnadalr.kagic.networking.PadDataMessage;
import mod.heimrarnadalr.kagic.worlddata.WorldDataWarpPad;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PadDataRequestMessage
implements IMessage {
    private int x;
    private int y;
    private int z;

    public PadDataRequestMessage() {
    }

    public PadDataRequestMessage(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public static class PadDataRequestMessageHandler
    implements IMessageHandler<PadDataRequestMessage, IMessage> {
        public IMessage onMessage(PadDataRequestMessage message, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PadDataRequestMessage message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            World world = playerEntity.func_130014_f_();
            NBTTagCompound data = new NBTTagCompound();
            WorldDataWarpPad padData = WorldDataWarpPad.get(world);
            data = padData.func_189551_b(data);
            KTPacketHandler.INSTANCE.sendTo((IMessage)new PadDataMessage(data, message.x, message.y, message.z), ctx.getServerHandler().field_147369_b);
        }
    }
}

