/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.util.injector;

import java.util.ArrayList;
import java.util.HashMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntitySlag;
import mod.akrivus.kagic.init.ModBlocks;
import mod.akrivus.kagic.init.ModEntities;
import mod.akrivus.kagic.util.injector.ExitHole;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class InjectorResult {
    private EntityGem gem;
    private final BlockPos position;
    private final double defectiveRate;
    private final boolean createSlags;
    private final ExitHole exitHole;

    public InjectorResult(EntityGem gem, BlockPos pos, double defectiveRate, boolean createSlags, ExitHole exitHole) {
        this.gem = gem;
        this.position = pos;
        this.defectiveRate = defectiveRate;
        this.createSlags = createSlags;
        this.exitHole = exitHole;
    }

    public EntityGem getGem() {
        return this.gem;
    }

    public String getName() {
        return this.gem.func_70005_c_();
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public double getDefectivity() {
        return this.defectiveRate;
    }

    public boolean canCreateSlags() {
        return this.createSlags;
    }

    public ExitHole getExitHole() {
        return this.exitHole;
    }

    public void generate(World world) {
        if (this.canCreateSlags()) {
            int totalSlags = world.field_73012_v.nextInt(9) + 1;
            for (int i = 0; i <= totalSlags; ++i) {
                boolean failed = true;
                int attempts = 0;
                while (failed && attempts < 10) {
                    BlockPos spawn = this.getPosition().func_177982_a(world.field_73012_v.nextInt(9), 0, world.field_73012_v.nextInt(9));
                    boolean bl = failed = !world.func_175623_d(spawn);
                    if (!failed) {
                        EntitySlag slag = new EntitySlag(world);
                        slag.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p());
                        world.func_72838_d((Entity)slag);
                        slag.func_180482_a(world.func_175649_E(spawn), null);
                        continue;
                    }
                    ++attempts;
                }
            }
            world.func_175655_b(this.position, false);
        } else {
            if (this.exitHole != null) {
                this.exitHole.emerge(world);
            }
            if ((double)this.gem.field_70170_p.field_73012_v.nextFloat() < this.defectiveRate) {
                this.gem.setDefective(true);
            } else if (this.exitHole.createRockMelt()) {
                this.gem.setPrimary(true);
            }
            world.func_72838_d((Entity)this.gem);
            this.gem.func_180482_a(world.func_175649_E(this.getPosition()), null);
        }
    }

    public static InjectorResult create(World world, BlockPos pos, boolean drain) {
        HashMap<Class, Double> resultTable = new HashMap<Class, Double>();
        HashMap<Class, Double> defectivity = new HashMap<Class, Double>();
        HashMap<Class, Double> friction = new HashMap<Class, Double>();
        for (String string : ModEntities.GEMS.keySet()) {
            try {
                Class gemClass = ModEntities.GEMS.get(string);
                HashMap yield = (HashMap)gemClass.getField((string + "_yields").toUpperCase()).get(null);
                double defectivityRate = 1.0;
                double frictionFactor = 0.0;
                for (int x = -4; x <= 4; ++x) {
                    for (int y = -4; y <= 4; ++y) {
                        for (int z = -4; z <= 4; ++z) {
                            BlockPos ore = pos.func_177982_a(x, y, z);
                            IBlockState state = world.func_180495_p(ore);
                            if (state.func_177230_c() == Blocks.field_150348_b && (state.func_177230_c() != Blocks.field_150348_b || state.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.STONE)) continue;
                            if (!resultTable.containsKey(gemClass)) {
                                resultTable.put(gemClass, 0.0);
                            }
                            if (yield.containsKey(state.func_177230_c())) {
                                resultTable.put(gemClass, (Double)resultTable.get(gemClass) + (Double)yield.get(state.func_177230_c()));
                                frictionFactor += 0.003;
                                defectivityRate -= 0.2;
                            }
                            if (state.func_185904_a() != Material.field_151577_b) continue;
                            defectivityRate -= 0.4;
                        }
                    }
                }
                defectivity.put(gemClass, Math.max(0.0, Math.min(1.0, defectivityRate)));
                friction.put(gemClass, frictionFactor);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error creating gem: " + e.getMessage());
            }
        }
        ArrayList<EntityGem> spawnlist = new ArrayList<EntityGem>();
        for (Class gemClass : resultTable.keySet()) {
            if (gemClass.getName().contains("Diamond")) continue;
            int multiples = (int)((Double)resultTable.get(gemClass) * 10.0);
            for (int i = 0; i < multiples; ++i) {
                try {
                    spawnlist.add((EntityGem)((Object)gemClass.getConstructors()[0].newInstance(world)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Error creating gem: " + e.getMessage());
                }
            }
        }
        EntityGem entityGem = spawnlist.isEmpty() ? null : (EntityGem)((Object)spawnlist.get(world.field_73012_v.nextInt(spawnlist.size())));
        ExitHole exitHole = null;
        if (drain && entityGem != null) {
            exitHole = ExitHole.create(world, pos, Math.ceil(entityGem.field_70131_O), (Double)friction.get(((Object)((Object)entityGem)).getClass()) >= 1.0);
            exitHole.emerge(world);
            entityGem.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        }
        if (drain) {
            for (int x = -4; x <= 4; ++x) {
                for (int y = -4; y <= 4; ++y) {
                    for (int z = -4; z <= 4; ++z) {
                        if (!world.field_73012_v.nextBoolean()) continue;
                        BlockPos ore = pos.func_177982_a(x, y, z);
                        InjectorResult.drainBlock(world, ore);
                    }
                }
            }
        }
        return new InjectorResult(entityGem, pos, entityGem == null ? 0.0 : (Double)defectivity.get(((Object)((Object)entityGem)).getClass()), spawnlist.isEmpty(), exitHole);
    }

    private static void drainBlock(World world, BlockPos ore) {
        IBlockState state = world.func_180495_p(ore);
        Block block = state.func_177230_c();
        if (block instanceof BlockBush) {
            world.func_175655_b(ore, false);
        }
        if (state == Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT)) {
            world.func_175656_a(ore, Blocks.field_150351_n.func_176223_P());
        } else if (state.func_185904_a() == Material.field_151577_b || state.func_185904_a() == Material.field_151578_c) {
            world.func_175656_a(ore, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT));
        } else if (state.func_185904_a() == Material.field_151576_e && state.func_185917_h()) {
            world.func_175656_a(ore, ModBlocks.DRAINED_BLOCK.func_176223_P());
        }
    }
}

