/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.tileentity;

import java.util.Iterator;
import java.util.List;
import mod.akrivus.kagic.init.KAGIC;
import mod.akrivus.kagic.init.ModSounds;
import mod.heimrarnadalr.kagic.networking.EntityTeleportMessage;
import mod.heimrarnadalr.kagic.networking.KTPacketHandler;
import mod.heimrarnadalr.kagic.worlddata.WorldDataWarpPad;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWarpPadCore
extends TileEntity
implements ITickable {
    public static final int warpTicks = 40;
    public static final int warpCooldownTicks = 20;
    private int warpTicksLeft = 0;
    private int cooldownTicksLeft = 0;
    private BlockPos destination = null;
    public int renderTicks = 0;
    public int renderCooldown = 0;
    private int ticksSinceLastCheck = 0;
    private final int clearanceHeight = 6;
    private boolean isClear = false;
    private boolean isPadValid = false;
    public String name = "";
    private boolean warping = false;
    private boolean cooling = false;

    private void setDirty() {
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        if (!this.field_145850_b.field_72995_K) {
            WorldDataWarpPad.get(this.field_145850_b).addWarpPadEntry(this.name, this.isPadValid, this.isClear, this.field_174879_c);
        }
    }

    private boolean isStair(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150370_cb && state.func_177229_b((IProperty)BlockStairs.field_176308_b) == BlockStairs.EnumHalf.BOTTOM;
    }

    private boolean validateStairs() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 0, 0));
        if (state.func_177230_c() != Blocks.field_150370_cb || state.func_177229_b((IProperty)BlockStairs.field_176309_a) != EnumFacing.WEST || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM || state.func_177229_b((IProperty)BlockStairs.field_176310_M) != BlockStairs.EnumShape.STRAIGHT) {
            return false;
        }
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 0, 0));
        if (state.func_177230_c() != Blocks.field_150370_cb || state.func_177229_b((IProperty)BlockStairs.field_176309_a) != EnumFacing.EAST || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM || state.func_177229_b((IProperty)BlockStairs.field_176310_M) != BlockStairs.EnumShape.STRAIGHT) {
            return false;
        }
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, 2));
        if (state.func_177230_c() != Blocks.field_150370_cb || state.func_177229_b((IProperty)BlockStairs.field_176309_a) != EnumFacing.NORTH || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM || state.func_177229_b((IProperty)BlockStairs.field_176310_M) != BlockStairs.EnumShape.STRAIGHT) {
            return false;
        }
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 0, -2));
        if (state.func_177230_c() != Blocks.field_150370_cb || state.func_177229_b((IProperty)BlockStairs.field_176309_a) != EnumFacing.SOUTH || state.func_177229_b((IProperty)BlockStairs.field_176308_b) != BlockStairs.EnumHalf.BOTTOM || state.func_177229_b((IProperty)BlockStairs.field_176310_M) != BlockStairs.EnumShape.STRAIGHT) {
            return false;
        }
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 0, -1));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-2, 0, -1), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 0, -2));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, -2), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 0, -1));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(2, 0, -1), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 0, -2));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, -2), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 0, 1));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(2, 0, 1), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(1, 0, 2));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(1, 0, 2), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 0, 1));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_RIGHT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-2, 0, 1), state);
        state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-1, 0, 2));
        if (!this.isStair(state)) {
            return false;
        }
        state = state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST);
        state = state.func_177226_a((IProperty)BlockStairs.field_176310_M, (Comparable)BlockStairs.EnumShape.OUTER_LEFT);
        this.field_145850_b.func_175656_a(this.field_174879_c.func_177982_a(-1, 0, 2), state);
        return true;
    }

    private boolean validatePad() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IBlockState state;
                if (j == 0 && i == 0 || (state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(i, 0, j))).func_177230_c() == Blocks.field_150371_ca && state.func_177229_b((IProperty)BlockQuartz.field_176335_a) == BlockQuartz.EnumType.LINES_Y) continue;
                return false;
            }
        }
        return this.validateStairs();
    }

    private boolean validateClearance() {
        for (int i = -1; i <= 1; ++i) {
            for (int j = 1; j <= 6; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177982_a(i, j, k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void validateWarpPad() {
        boolean clear;
        boolean valid = this.validatePad();
        if (this.isPadValid != valid) {
            this.isPadValid = valid;
            this.setDirty();
        }
        if (this.isClear != (clear = this.validateClearance())) {
            this.isClear = clear;
            this.setDirty();
        }
    }

    public boolean isValidPad() {
        return this.isPadValid && this.isClear;
    }

    public boolean isClear() {
        return this.isClear;
    }

    public boolean isValid() {
        return this.isPadValid;
    }

    public void func_73660_a() {
        ++this.ticksSinceLastCheck;
        if (this.isValid() && (this.ticksSinceLastCheck & 0xA) == 0) {
            this.validateWarpPad();
            this.ticksSinceLastCheck = 0;
        }
        if (this.warpTicksLeft > 0) {
            --this.warpTicksLeft;
            if (this.warpTicksLeft <= 0) {
                this.WARP();
            }
        }
        if (this.cooldownTicksLeft >= 0) {
            --this.cooldownTicksLeft;
        } else if (this.cooling) {
            this.cooling = false;
            this.setDirty();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("valid", this.isPadValid);
        compound.func_74757_a("clear", this.isClear);
        compound.func_74757_a("warping", this.warping);
        compound.func_74757_a("cooling", this.cooling);
        compound.func_74778_a("name", this.name);
        compound.func_74768_a("renderTicks", this.warpTicksLeft);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.isPadValid = compound.func_74767_n("valid");
        this.isClear = compound.func_74767_n("clear");
        this.warping = compound.func_74767_n("warping");
        if (!this.warping) {
            this.renderCooldown = 0;
        }
        this.cooling = compound.func_74767_n("cooling");
        this.name = compound.func_74779_i("name");
        this.renderTicks = compound.func_74762_e("renderTicks");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void setName(String name) {
        if (!this.field_145850_b.field_72995_K) {
            this.name = name;
            this.setDirty();
        } else {
            KAGIC.instance.chatInfoMessage("ERROR: setName called on client");
        }
    }

    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 3.0;
    }

    public void destroy() {
        WorldDataWarpPad.get(this.field_145850_b).removeWarpPadEntry(this.field_174879_c);
    }

    public void beginWarp(BlockPos destination) {
        this.warpTicksLeft = 40;
        this.destination = destination;
        this.warping = true;
        this.setDirty();
        this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.WARP_PAD, SoundCategory.BLOCKS, 20.0f, 1.0f);
    }

    public void WARP() {
        BlockPos minorCorner = new BlockPos(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() - 1);
        BlockPos majorCorner = new BlockPos(this.field_174879_c.func_177958_n() + 2, this.field_174879_c.func_177956_o() + 5, this.field_174879_c.func_177952_p() + 2);
        AxisAlignedBB warpArea = new AxisAlignedBB(minorCorner, majorCorner);
        List entitiesToWarp = this.field_145850_b.func_72872_a(Entity.class, warpArea);
        Iterator it = entitiesToWarp.iterator();
        TileEntityWarpPadCore destPad = (TileEntityWarpPadCore)this.field_145850_b.func_175625_s(this.destination);
        ChunkPos cPos = destPad.field_145850_b.func_175726_f(destPad.field_174879_c).func_76632_l();
        if (!destPad.isValidPad()) {
            this.cooldownTicksLeft = 1;
            return;
        }
        while (it.hasNext()) {
            Entity entity = (Entity)it.next();
            double offsetX = entity.field_70165_t - (double)this.field_174879_c.func_177958_n();
            double offsetY = entity.field_70163_u - (double)this.field_174879_c.func_177956_o();
            double offsetZ = entity.field_70161_v - (double)this.field_174879_c.func_177952_p();
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)this.destination.func_177958_n() + offsetX, (double)this.destination.func_177956_o() + offsetY, (double)this.destination.func_177952_p() + offsetZ, entity.field_70177_z, entity.field_70125_A);
                continue;
            }
            if (entity instanceof EntityLivingBase) {
                entity.func_70634_a((double)this.destination.func_177958_n() + offsetX, (double)this.destination.func_177956_o() + offsetY, (double)this.destination.func_177952_p() + offsetZ);
                for (EntityPlayer player : ((WorldServer)this.field_145850_b).func_73039_n().getTrackingPlayers(entity)) {
                    KTPacketHandler.INSTANCE.sendTo((IMessage)new EntityTeleportMessage(entity.func_145782_y(), (double)this.destination.func_177958_n() + offsetX, (double)this.destination.func_177956_o() + offsetY, (double)this.destination.func_177952_p() + offsetZ), (EntityPlayerMP)player);
                }
                continue;
            }
            entity.func_70012_b((double)this.destination.func_177958_n() + offsetX, (double)this.destination.func_177956_o() + offsetY, (double)this.destination.func_177952_p() + offsetZ, entity.field_70177_z, entity.field_70125_A);
            entity.func_70034_d(entity.field_70177_z);
        }
        this.warping = false;
        this.cooling = true;
        this.cooldownTicksLeft = 20;
        this.setDirty();
    }

    public static TileEntityWarpPadCore getEntityPad(Entity entityIn) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                TileEntity te = entityIn.func_130014_f_().func_175625_s(new BlockPos(entityIn.field_70165_t + (double)i, entityIn.field_70163_u - 1.0, entityIn.field_70161_v + (double)j));
                if (!(te instanceof TileEntityWarpPadCore)) continue;
                return (TileEntityWarpPadCore)te;
            }
        }
        return null;
    }

    public boolean isWarping() {
        return this.warping || this.cooling;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(1, 6, 1));
    }
}

