/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mod.akrivus.kagic.init.KAGIC;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class SpaceStuff {
    private final String FILE_PATH;
    private boolean yellowDiamondSpawned = false;
    private boolean blueDiamondSpawned = false;
    private long lastRubyImpactTime = 0L;
    private long lastRobonoidImpactTime = 0L;

    public SpaceStuff(World world) throws IOException {
        this.FILE_PATH = new File(world.func_73046_m().func_71238_n().getAbsolutePath().replaceAll("\\\\\\.$", "") + (world.func_73046_m().func_71264_H() ? "\\saves\\" : "\\") + world.func_73046_m().func_71270_I() + "\\space_stuff.dat").getAbsolutePath();
        this.load();
    }

    public void load() {
        try {
            File file = new File(this.FILE_PATH);
            if (!file.exists()) {
                file.createNewFile();
                this.save();
            } else {
                FileInputStream stream = new FileInputStream(file);
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
                this.readFromNBT(nbt);
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            File file = new File(this.FILE_PATH);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream stream = new FileOutputStream(file);
            NBTTagCompound nbt = this.writeToNBT(new NBTTagCompound());
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)stream);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("yellowDiamondSpawned")) {
            this.yellowDiamondSpawned = nbt.func_74767_n("yellowDiamondSpawned");
        }
        if (nbt.func_74764_b("blueDiamondSpawned")) {
            this.blueDiamondSpawned = nbt.func_74767_n("blueDiamondSpawned");
        }
        if (nbt.func_74764_b("lastRubyImpactTime")) {
            this.lastRubyImpactTime = nbt.func_74763_f("lastRubyImpactTime");
        }
        if (nbt.func_74764_b("lastRobonoidImpactTime")) {
            this.lastRobonoidImpactTime = nbt.func_74763_f("lastRobonoidImpactTime");
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("yellowDiamondSpawned", this.yellowDiamondSpawned);
        compound.func_74757_a("blueDiamondSpawned", this.blueDiamondSpawned);
        compound.func_74772_a("lastRubyImpactTime", this.lastRubyImpactTime);
        compound.func_74772_a("lastRobonoidImpactTime", this.lastRobonoidImpactTime);
        return compound;
    }

    public boolean hasYellowSpawned() {
        return this.yellowDiamondSpawned;
    }

    public void yellowDiamondSpawned(boolean spawned) {
        this.yellowDiamondSpawned = spawned;
    }

    public boolean hasBlueSpawned() {
        return this.blueDiamondSpawned;
    }

    public void blueDiamondSpawned(boolean spawned) {
        this.blueDiamondSpawned = spawned;
    }

    public long getLastRubyImpactTime() {
        return this.lastRubyImpactTime;
    }

    public void setLastRubyImpactTime(long lastImpactTime) {
        this.lastRubyImpactTime = lastImpactTime;
    }

    public long getLastRobonoidImpactTime() {
        return this.lastRobonoidImpactTime;
    }

    public void setLastRobonoidImpactTime(long lastImpactTime) {
        this.lastRobonoidImpactTime = lastImpactTime;
    }

    public static SpaceStuff get() {
        return KAGIC.spaceStuff;
    }
}

