/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ModConfigs {
    public static File file;
    public static Configuration settings;
    public static boolean notifyOnUpdates;
    public static boolean useMetrics;
    public static boolean canGemsMakeSounds;
    public static boolean spawnMeteorRubies;
    public static int meteorRubyRate;
    public static boolean instructInjectors;
    public static boolean canRebel;

    public static void register(FMLPreInitializationEvent e) {
        file = e.getSuggestedConfigurationFile();
        settings = new Configuration(file);
        ModConfigs.setValues();
    }

    public static void setValues() {
        settings.addCustomCategoryComment("preferences", "These can be set to the user's delight and do not change mod behavior.");
        notifyOnUpdates = settings.getBoolean("Update notifications:", "preferences", true, "Setting to false might expose you to possible bugs.");
        useMetrics = settings.getBoolean("Use metrics?", "preferences", true, "This helps me fine-tune the mod and obtain crash reports.");
        spawnMeteorRubies = settings.getBoolean("Spawn Meteor Rubies:", "preferences", true, "Should Meteor Rubies spawn?");
        canGemsMakeSounds = settings.getBoolean("Make Gems talk:", "preferences", true, "Setting to true can make Gems very loud and annoying.");
        meteorRubyRate = settings.getInt("Meteor Ruby spawn rate:", "preferences", 10, 0, 365, "Amount of days minimum between Meteor Rubies.");
        instructInjectors = settings.getBoolean("Instruct Injector setup:", "preferences", true, "Instructs players on how to set up injectors.");
        canRebel = settings.getBoolean("Gems can rebel: ", "preferences", false, "Whether or not navel gems and meteor rubies have a chance of rebelling after a short time serving you");
        settings.save();
    }

    public static void syncConfiguration() {
        settings.save();
    }

    public static List<IConfigElement> getCategories() {
        ArrayList<IConfigElement> returnee = new ArrayList<IConfigElement>();
        for (String title : settings.getCategoryNames()) {
            if (title.equals("server")) continue;
            ConfigElement elements = new ConfigElement(settings.getCategory(title));
            for (IConfigElement element : elements.getChildElements()) {
                returnee.add(element);
            }
        }
        return returnee;
    }
}

