/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.init;

import java.util.Calendar;
import mod.akrivus.kagic.client.gui.KTGUIProxy;
import mod.akrivus.kagic.command.CommandMeteorRuby;
import mod.akrivus.kagic.command.CommandSpawnGems;
import mod.akrivus.kagic.init.ModBiomes;
import mod.akrivus.kagic.init.ModConfigs;
import mod.akrivus.kagic.init.ModDimensions;
import mod.akrivus.kagic.init.ModEntities;
import mod.akrivus.kagic.init.ModEvents;
import mod.akrivus.kagic.init.ModMetrics;
import mod.akrivus.kagic.init.ModTESRs;
import mod.akrivus.kagic.init.ModTileEntities;
import mod.akrivus.kagic.server.SpaceStuff;
import mod.heimrarnadalr.kagic.chunk.KAGICChunkCallback;
import mod.heimrarnadalr.kagic.crafting.KAGICSmeltingRecipes;
import mod.heimrarnadalr.kagic.networking.KTPacketHandler;
import mod.heimrarnadalr.kagic.proxies.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="kagic", version="1.9.4", acceptedMinecraftVersions="[1.12,1.12.1]", guiFactory="mod.akrivus.kagic.client.gui.GuiFactory")
public class KAGIC {
    public static final String MODID = "kagic";
    public static final String VERSION = "1.9.4";
    public static final String MCVERSION = "[1.12,1.12.1]";
    public static final boolean DEVELOPER = false;
    public static Logger logger;
    @Mod.Instance
    public static KAGIC instance;
    public static SpaceStuff spaceStuff;
    @SidedProxy(clientSide="mod.heimrarnadalr.kagic.proxies.ClientProxy", serverSide="mod.heimrarnadalr.kagic.proxies.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        ModBiomes.register();
        ModConfigs.register(e);
        ModDimensions.register();
        KAGICSmeltingRecipes.register();
        KTPacketHandler.registerMessages(MODID);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new KAGICChunkCallback());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ModEntities.register();
        ModEvents.register();
        ModTileEntities.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new KTGUIProxy());
        if (e.getSide() == Side.CLIENT) {
            ModTESRs.register();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            try {
                ModMetrics.setMetrics(null);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        e.registerServerCommand((ICommand)new CommandMeteorRuby());
        e.registerServerCommand((ICommand)new CommandSpawnGems());
    }

    public void chatInfoMessage(String message) {
    }

    public static boolean isDayToday(int month, int day) {
        boolean sameMonth = Calendar.getInstance().get(2) == month - 1;
        boolean sameDay = Calendar.getInstance().get(5) == day;
        return sameMonth && sameDay;
    }

    public static boolean isFireworksDay() {
        return KAGIC.isDayToday(1, 1) || KAGIC.isDayToday(3, 21) || KAGIC.isDayToday(7, 4);
    }

    public static boolean isHalloween() {
        return KAGIC.isDayToday(10, 31);
    }

    public static boolean isAprilFools() {
        return KAGIC.isDayToday(4, 1);
    }

    public static boolean isChristmas() {
        return KAGIC.isDayToday(12, 25);
    }

    public static boolean isBirthday() {
        return KAGIC.isDayToday(1, 17) || KAGIC.isDayToday(10, 24);
    }
}

