/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import java.util.HashMap;
import java.util.Random;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.ai.EntityAITopazFuse;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityTopaz
extends EntityGem {
    public static final HashMap<Block, Double> TOPAZ_YIELDS = new HashMap();

    public EntityTopaz(World worldIn) {
        super(worldIn);
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.DRUM, GemPlacements.RIGHT_KNEE);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITopazFuse(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.droppedGemItem = ModItems.TOPAZ_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_TOPAZ_GEM;
    }

    @Override
    public float[] getGemColor() {
        if (this.getSpecial() == 1) {
            return new float[]{0.3647059f, 0.4509804f, 1.0f};
        }
        if (this.getSpecial() == 2) {
            return new float[]{0.28235295f, 0.85490197f, 0.65882355f};
        }
        return new float[]{0.98039216f, 1.0f, 0.3647059f};
    }

    public String getColor() {
        switch (this.getSpecial()) {
            case 1: {
                return "blue_";
            }
            case 2: {
                return "green_";
            }
        }
        return "";
    }

    public void setColor(int color) {
        this.setSpecial(color);
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.DRUM.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.LEFT_CHEEK.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.RIGHT_CHEEK.id);
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setSpecial(this.field_70146_Z.nextInt(7) == 0 ? 1 : 0);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        this.wantsToFuse = true;
        return true;
    }

    @Override
    public boolean onSpokenTo(EntityPlayer player, String message) {
        boolean spokenTo = super.onSpokenTo(player, message);
        if (!spokenTo && this.isBeingCalledBy(player, message = message.toLowerCase())) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isMatching("regex.kagic.fuse", message)) {
                    this.wantsToFuse = true;
                    return true;
                }
                if (this.isMatching("regex.kagic.unfuse", message)) {
                    this.wantsToFuse = false;
                    if (this.isFusion()) {
                        this.unfuse();
                    }
                    return true;
                }
            }
        }
        return spokenTo;
    }

    public void whenFused() {
        this.func_70105_a(0.9f * (float)this.getFusionCount(), 2.3f * (float)this.getFusionCount());
    }

    @Override
    public void func_70636_d() {
        if (this.isFusion()) {
            this.whenFused();
        }
        super.func_70636_d();
    }

    public boolean canFuseWith(EntityTopaz other) {
        if (this.func_110143_aJ() < 0.0f || other.func_110143_aJ() < 0.0f) {
            return false;
        }
        return this.canFuse() && other.canFuse() && this.getServitude() == other.getServitude() && this.getGemPlacement() != other.getGemPlacement() && (this.getServitude() == 1 && this.func_184753_b().equals(other.func_184753_b()) || this.getServitude() != 1);
    }

    @Override
    public boolean canFuse() {
        return super.canFuse() && this.wantsToFuse && !this.isFusion();
    }

    public EntityTopaz fuse(EntityTopaz other) {
        ItemStack second;
        EntityTopaz topaz = new EntityTopaz(this.field_70170_p);
        NBTTagCompound primeCompound = new NBTTagCompound();
        this.func_70014_b(primeCompound);
        topaz.fusionMembers.add(primeCompound);
        NBTTagCompound otherCompound = new NBTTagCompound();
        other.func_70014_b(otherCompound);
        topaz.fusionMembers.add(otherCompound);
        if (this.getServitude() == 1) {
            topaz.setOwnerId(this.func_184753_b());
            topaz.setLeader(this.getOwner());
        }
        topaz.setServitude(this.getServitude());
        topaz.setFusionCount(this.getFusionCount() + other.getFusionCount());
        topaz.generateFusionPlacements();
        topaz.func_70107_b((this.field_70165_t + other.field_70165_t) / 2.0, (this.field_70163_u + other.field_70163_u) / 2.0, (this.field_70161_v + other.field_70161_v) / 2.0);
        topaz.setSpecial(this.getSpecial() == other.getSpecial() ? this.getSpecial() : 2);
        topaz.func_70624_b(this.func_70638_az());
        topaz.func_70604_c(this.func_94060_bK());
        topaz.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0 * (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(18.0 * (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.6 / (double)topaz.getFusionCount());
        topaz.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        topaz.field_70138_W = topaz.getFusionCount();
        topaz.func_70606_j(topaz.func_110138_aP());
        ItemStack weapon = this.func_184586_b(EnumHand.MAIN_HAND);
        if (weapon.func_77973_b() == Items.field_190931_a) {
            weapon = other.func_184586_b(EnumHand.MAIN_HAND);
        }
        if ((second = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_190931_a) {
            second = other.func_184586_b(EnumHand.OFF_HAND);
        }
        topaz.setFusionWeapon(weapon);
        topaz.setFusionWeapon(second);
        topaz.func_70105_a(0.9f * (float)topaz.getFusionCount(), 2.3f * (float)topaz.getFusionCount());
        return topaz;
    }

    @Override
    public void unfuse() {
        for (int i = 0; i < this.fusionMembers.size(); ++i) {
            EntityTopaz topaz = new EntityTopaz(this.field_70170_p);
            topaz.func_70020_e((NBTTagCompound)this.fusionMembers.get(i));
            topaz.func_184221_a(MathHelper.func_180182_a((Random)this.field_70170_p.field_73012_v));
            topaz.func_70606_j(topaz.func_110138_aP());
            topaz.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            topaz.func_70604_c(null);
            topaz.func_70624_b(null);
            topaz.wantsToFuse = false;
            this.field_70170_p.func_72838_d((Entity)topaz);
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        super.func_82196_d(target, distanceFactor);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (this.getSpecial() == 1) {
            this.droppedGemItem = ModItems.BLUE_TOPAZ_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_TOPAZ_GEM;
        } else {
            this.droppedGemItem = ModItems.TOPAZ_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_TOPAZ_GEM;
        }
        super.func_70645_a(cause);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public SoundEvent getHurtSound() {
        return ModSounds.TOPAZ_STEP;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.TOPAZ_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.TOPAZ_DEATH;
    }
}

