/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIPickUpItems;
import mod.akrivus.kagic.entity.ai.EntityAIRubyFuse;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityRuby
extends EntityGem {
    public static final HashMap<Block, Double> RUBY_YIELDS = new HashMap();
    private static final DataParameter<Integer> ANGER = EntityDataManager.func_187226_a(EntityRuby.class, (DataSerializer)DataSerializers.field_187192_b);
    private int angerTicks = 0;

    public EntityRuby(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.8f);
        this.field_70178_ae = true;
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.SQUARE, GemPlacements.RIGHT_KNEE);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPickUpItems(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIRubyFuse(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

            public boolean apply(EntityLiving input) {
                return input != null && IMob.field_175450_e.apply((Object)input);
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.RUBY_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_RUBY_GEM;
        this.field_70180_af.func_187214_a(ANGER, (Object)0);
    }

    @Override
    public float[] getGemColor() {
        return new float[]{0.93333334f, 0.13725491f, 0.19215687f};
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.FACETED.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.LEFT_HAND.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.RIGHT_HAND.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BACK.id);
                break;
            }
            case 3: {
                this.setGemPlacement(GemPlacements.LEFT_EYE.id);
                break;
            }
            case 4: {
                this.setGemPlacement(GemPlacements.RIGHT_EYE.id);
                break;
            }
            case 5: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 6: {
                this.setGemPlacement(GemPlacements.BELLY.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("anger", this.getAnger());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setAnger(compound.func_74762_e("anger"));
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setSpecial(this.field_70146_Z.nextInt(6));
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public void whenDefective() {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_70105_a(0.7f, 0.9f);
        this.field_70138_W = 0.5f;
    }

    public void whenFused() {
        this.func_70105_a(0.7f * (float)this.getFusionCount(), 1.8f * (float)this.getFusionCount());
    }

    public boolean canPickupItem(Item itemIn) {
        return this.isDefective() && (itemIn instanceof ItemSword || itemIn instanceof ItemTool || itemIn instanceof ItemBow);
    }

    @Override
    public void func_70636_d() {
        if (this.getAnger() > 2) {
            if (!this.func_70090_H()) {
                for (int k = 0; k < 8; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t - 0.5 + Math.random(), this.field_70163_u + Math.random(), this.field_70161_v - 0.5 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else if (this.getAnger() > 3) {
            if (this.func_70090_H()) {
                this.field_70170_p.func_175698_g(this.func_180425_c());
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
                for (int k = 0; k < 8; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - 0.5 + Math.random(), this.field_70163_u + Math.random(), this.field_70161_v - 0.5 + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
            } else if (this.field_70122_E) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150480_ab.func_176223_P());
            }
        } else if (this.getAnger() > 4) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 60));
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60));
        } else if (this.getAnger() > 6) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 60, 3));
        }
        if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a() == Material.field_151587_i) {
            this.func_70691_i(1.0f);
        }
        ++this.angerTicks;
        if (this.angerTicks > 200 && this.getAnger() > 0) {
            this.setAnger(this.getAnger() - 1);
            this.angerTicks = 0;
        }
        if (this.field_70173_aa % 10 + this.field_70146_Z.nextInt(50) == 0) {
            this.setSpecial(this.field_70146_Z.nextInt(6));
        }
        if (this.isFusion()) {
            if (this.canFuse()) {
                this.whenFused();
            } else {
                this.unfuse();
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean alternateInteract(EntityPlayer player) {
        this.wantsToFuse = true;
        super.alternateInteract(player);
        return true;
    }

    @Override
    public boolean onSpokenTo(EntityPlayer player, String message) {
        boolean spokenTo = super.onSpokenTo(player, message);
        if (!spokenTo && this.isBeingCalledBy(player, message = message.toLowerCase())) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isMatching("regex.kagic.fuse", message)) {
                    this.wantsToFuse = true;
                    return true;
                }
                if (this.isMatching("regex.kagic.unfuse", message)) {
                    this.wantsToFuse = false;
                    if (this.isFusion()) {
                        this.unfuse();
                    }
                    return true;
                }
            }
        }
        return spokenTo;
    }

    public boolean canFuseWith(EntityRuby other) {
        if (this.canFuse() && other.canFuse() && this.getServitude() == other.getServitude() && this.getGemPlacement() != other.getGemPlacement() && (this.getServitude() == 1 && this.func_184753_b().equals(other.func_184753_b()) || this.getServitude() != 1)) {
            if (this.wantsToFuse && other.wantsToFuse) {
                return true;
            }
            if (this.func_94060_bK() != null && this.func_94060_bK().equals((Object)other.func_94060_bK()) || this.func_70638_az() != null && this.func_70638_az().equals((Object)other.func_70638_az())) {
                return true;
            }
            if (((double)(this.func_110143_aJ() / this.func_110138_aP()) <= 0.5 || (double)(other.func_110143_aJ() / other.func_110138_aP()) <= 0.5) && this.func_110143_aJ() > 0.0f && other.func_110143_aJ() > 0.0f) {
                return true;
            }
        }
        return false;
    }

    public EntityRuby fuse(EntityRuby other) {
        ItemStack second;
        EntityRuby ruby = new EntityRuby(this.field_70170_p);
        if (this.isFusion()) {
            for (NBTTagCompound compound : this.fusionMembers) {
                ruby.fusionMembers.add(compound);
            }
        } else {
            NBTTagCompound primeCompound = new NBTTagCompound();
            this.func_70014_b(primeCompound);
            ruby.fusionMembers.add(primeCompound);
        }
        if (other.isFusion()) {
            for (NBTTagCompound compound : other.fusionMembers) {
                ruby.fusionMembers.add(compound);
            }
        } else {
            NBTTagCompound otherCompound = new NBTTagCompound();
            other.func_70014_b(otherCompound);
            ruby.fusionMembers.add(otherCompound);
        }
        if (this.getServitude() == 1) {
            ruby.setOwnerId(this.func_184753_b());
            ruby.setLeader(this.getOwner());
        }
        ruby.setServitude(this.getServitude());
        ruby.setFusionCount(this.getFusionCount() + other.getFusionCount());
        ruby.generateFusionPlacements();
        ruby.func_70107_b((this.field_70165_t + other.field_70165_t) / 2.0, (this.field_70163_u + other.field_70163_u) / 2.0, (this.field_70161_v + other.field_70161_v) / 2.0);
        ruby.setAnger(this.getAnger() + other.getAnger());
        ruby.func_70624_b(this.func_70638_az());
        ruby.func_70604_c(this.func_94060_bK());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0 * (double)ruby.getFusionCount());
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0 * (double)ruby.getFusionCount());
        ruby.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        ruby.field_70138_W = ruby.getFusionCount();
        ruby.func_70606_j(ruby.func_110138_aP());
        ItemStack weapon = this.func_184586_b(EnumHand.MAIN_HAND);
        if (weapon.func_77973_b() == Items.field_190931_a) {
            weapon = other.func_184586_b(EnumHand.MAIN_HAND);
        }
        if ((second = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_190931_a) {
            second = other.func_184586_b(EnumHand.OFF_HAND);
        }
        ruby.setFusionWeapon(weapon);
        ruby.setFusionWeapon(second);
        ruby.func_70105_a(0.7f * (float)ruby.getFusionCount(), 1.8f * (float)ruby.getFusionCount());
        return ruby;
    }

    public void func_70624_b(@Nullable EntityLivingBase entitylivingbaseIn) {
        super.func_70624_b(entitylivingbaseIn);
    }

    @Override
    public void unfuse() {
        for (int i = 0; i < this.fusionMembers.size(); ++i) {
            EntityRuby ruby = new EntityRuby(this.field_70170_p);
            ruby.func_70020_e((NBTTagCompound)this.fusionMembers.get(i));
            ruby.func_184221_a(MathHelper.func_180182_a((Random)this.field_70170_p.field_73012_v));
            ruby.func_70606_j(ruby.func_110138_aP());
            ruby.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            ruby.func_70604_c(null);
            ruby.func_70624_b(null);
            ruby.wantsToFuse = false;
            if (ruby.isFusion()) {
                ruby.unfuse();
                this.field_70170_p.func_72900_e((Entity)ruby);
                continue;
            }
            this.field_70170_p.func_72838_d((Entity)ruby);
        }
        this.field_70170_p.func_72900_e((Entity)this);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase && !this.isOwner((EntityLivingBase)source.func_76346_g())) {
            if (source.func_82725_o()) {
                this.setAnger(this.getAnger() + 4 + (int)(amount / 2.0f));
            } else {
                this.setAnger(this.getAnger() + 1 + (int)(amount / 4.0f));
            }
        } else if (source.func_76352_a()) {
            this.setAnger(this.getAnger() + 2 + (int)(amount / 3.0f));
        }
        if (this.isDefective()) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
        this.setSpecial(this.field_70146_Z.nextInt(6));
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        int anger = this.getAnger();
        if (anger > 7) {
            anger = 7;
        }
        if (this.field_70146_Z.nextInt(8 - anger) == 1) {
            entityIn.func_70015_d(anger * 2 + 4);
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityTippedArrow arrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double distanceFromTargetX = target.field_70165_t - this.field_70165_t;
        double distanceFromTargetY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - arrow.field_70163_u;
        double distanceFromTargetZ = target.field_70161_v - this.field_70161_v;
        double distanceFromTargetS = MathHelper.func_76133_a((double)(distanceFromTargetX * distanceFromTargetX + distanceFromTargetY * distanceFromTargetY));
        arrow.func_70186_c(distanceFromTargetX, distanceFromTargetY + distanceFromTargetS * (double)0.2f, distanceFromTargetZ, 1.6f, 2.0f);
        arrow.func_70239_b((double)(distanceFactor * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        int power = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)this);
        int punch = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        boolean flame = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this) > 0;
        int anger = this.getAnger();
        if (anger > 7) {
            anger = 7;
        }
        if (power > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)power * 0.5 + 0.5);
        }
        if (punch > 0) {
            arrow.func_70240_a(punch);
        }
        if (flame) {
            arrow.func_70015_d(100 + (anger * 100 + 40));
        } else if (this.field_70146_Z.nextInt(8 - anger) == 1) {
            arrow.func_70015_d(anger * 100 + 40);
        }
        ItemStack itemstack = this.func_184586_b(EnumHand.OFF_HAND);
        if (itemstack.func_77973_b() == Items.field_185167_i) {
            arrow.func_184555_a(itemstack);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)arrow);
    }

    public void func_70664_aZ() {
        if (this.isDefective()) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_70664_aZ();
    }

    @Override
    public void func_180430_e(float distance, float damageMultiplier) {
        if (this.isDefective()) {
            this.func_70099_a(this.func_184586_b(EnumHand.MAIN_HAND), 0.0f);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
        }
        super.func_180430_e(distance, damageMultiplier);
    }

    public int getAnger() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER);
    }

    public void setAnger(int anger) {
        this.field_70180_af.func_187227_b(ANGER, (Object)anger);
    }

    public int getSpecialSkin() {
        return this.getSpecial();
    }

    public SoundEvent func_184639_G() {
        return ModSounds.RUBY_LIVING;
    }

    public SoundEvent getHurtSound() {
        return ModSounds.RUBY_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.RUBY_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.RUBY_DEATH;
    }
}

