/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.EntitySlag;
import mod.akrivus.kagic.entity.ai.EntityAIAlignGems;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIHarvestFarmland;
import mod.akrivus.kagic.entity.ai.EntityAIPickUpItems;
import mod.akrivus.kagic.entity.ai.EntityAIStandGuard;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import mod.akrivus.kagic.util.injector.InjectorResult;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityPeridot
extends EntityGem
implements IInventoryChangedListener {
    public static final HashMap<Block, Double> PERIDOT_YIELDS = new HashMap();
    public InventoryBasic gemStorage;
    public InvWrapper gemStorageHandler;
    public InventoryBasic harvest;
    public InvWrapper harvestHandler;
    private int harvestTimer = 0;
    private int dropTimer = 100;
    private BlockPos lastCheckPos;
    private long lastCheckTime;
    private InjectorResult lastResult;

    public EntityPeridot(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 1.9f);
        this.initGemStorage();
        this.seePastDoors();
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.PERIDOT, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TRIANGULAR, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAlignGems(this, 0.9));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIHarvestFarmland(this, 0.6));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIPickUpItems(this, 0.9));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsTarget((EntityCreature)this, 0.414, 32.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIStandGuard(this, 0.6));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySlag.class, true, true));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(400.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.PERIDOT_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_PERIDOT_GEM;
    }

    @Override
    public float[] getGemColor() {
        return new float[]{0.18431373f, 0.972549f, 0.16470589f};
    }

    @Override
    public void convertGems(int placement) {
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                this.setGemCut(GemCuts.PERIDOT.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setGemCut(GemCuts.TRIANGULAR.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound;
        ItemStack itemstack;
        int i;
        super.func_70014_b(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            itemstack = this.gemStorage.func_70301_a(i);
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        for (i = 0; i < this.harvest.func_70302_i_(); ++i) {
            itemstack = this.harvest.func_70301_a(i);
            nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("harvestItems", (NBTBase)nbttaglist);
        compound.func_74768_a("harvestTimer", this.harvestTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        int j;
        NBTTagCompound nbttagcompound;
        int i;
        super.func_70037_a(compound);
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        nbttaglist = compound.func_150295_c("harvestItems", 10);
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound = nbttaglist.func_150305_b(i);
            j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.harvest.func_70302_i_()) continue;
            this.harvest.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.harvestTimer = compound.func_74762_e("harvestTimer");
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed()) {
                if (this.isOwner((EntityLivingBase)player)) {
                    if (this.isCoreItem(stack)) {
                        return super.func_184645_a(player, hand);
                    }
                    if (stack.func_77973_b() instanceof ItemHoe) {
                        boolean toolChanged = true;
                        if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_185136_b(stack)) {
                            this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND), 0.0f);
                        } else {
                            toolChanged = false;
                        }
                        if (toolChanged) {
                            ItemStack heldItem = stack.func_77946_l();
                            this.func_184201_a(EntityEquipmentSlot.MAINHAND, heldItem);
                            this.playObeySound();
                            if (!player.field_71075_bZ.field_75098_d) {
                                stack.func_190918_g(1);
                            }
                        }
                        return true;
                    }
                    if (this.isFarmer()) {
                        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                            ItemStack itemstack = this.gemStorage.func_70301_a(i);
                            this.func_98053_h(false);
                            this.dropTimer = 0;
                            if (itemstack.func_77973_b() == Items.field_151015_O || itemstack.func_77973_b() == Items.field_185164_cV) {
                                this.gemStorage.func_70299_a(i, ItemStack.field_190927_a);
                                this.harvest.func_174894_a(itemstack);
                                continue;
                            }
                            if (itemstack.func_190916_E() <= 1) continue;
                            ItemStack newstack = itemstack.func_77979_a(itemstack.func_190916_E() - 8);
                            this.gemStorage.func_70299_a(i, itemstack);
                            this.harvest.func_174894_a(newstack);
                        }
                        if (this.harvest.func_191420_l()) {
                            player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_no_harvest", new Object[0]).func_150261_e()));
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_harvest", new Object[0]).func_150261_e()));
                        }
                        this.openGUI(player);
                        this.playObeySound();
                        return true;
                    }
                    this.checkSurroundings(this.field_70170_p, this.func_180425_c());
                    this.playObeySound();
                    return true;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("command.kagic.does_not_serve_you", new Object[]{this.func_70005_c_()}));
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean onSpokenTo(EntityPlayer player, String message) {
        boolean spokenTo = super.onSpokenTo(player, message);
        if (this.isBeingCalledBy(player, message = message.toLowerCase())) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isMatching("regex.kagic.harvest", message)) {
                    for (int i = 0; i < this.harvest.func_70302_i_(); ++i) {
                        if (player.field_71071_by.func_70447_i() <= -1) continue;
                        player.field_71071_by.func_70441_a(this.harvest.func_70301_a(i));
                    }
                }
                this.playObeySound();
            }
        }
        return spokenTo;
    }

    public void checkSurroundings(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            InjectorResult result = this.lastCheckPos != null && this.func_174818_b(this.lastCheckPos) > 32.0 || this.lastCheckPos == null || this.field_70170_p.func_82737_E() - this.lastCheckTime > 2400L ? InjectorResult.create(worldIn, pos, false) : this.lastResult;
            String defectivity = Math.round(result.getDefectivity() * 100.0) + "%";
            if (result.getGem() != null) {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_find_gem", new Object[]{result.getName(), defectivity}).func_150261_e()));
            } else {
                this.getOwner().func_145747_a((ITextComponent)new TextComponentString("<" + this.func_70005_c_() + "> " + new TextComponentTranslation("command.kagic.peridot_cant_find_gem", new Object[0]).func_150261_e()));
            }
            this.lastCheckTime = this.field_70170_p.func_82737_E();
            this.lastCheckPos = this.func_180425_c();
            this.lastResult = result;
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.func_98052_bS() && this.dropTimer > 40 && this.isFarmer()) {
            this.func_98053_h(this.isFarmer());
        }
        if (this.isFarmer()) {
            ++this.harvestTimer;
        }
        if (this.dropTimer < 100) {
            ++this.dropTimer;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        super.func_70645_a(cause);
    }

    public void func_76316_a(IInventory inventory) {
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, this.gemStorage.func_70301_a(0));
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.harvest.func_110133_a(new TextComponentTranslation("command.kagic.peridot_inventory", new Object[]{this.func_70005_c_()}).func_150261_e());
            playerEntity.func_71007_a((IInventory)this.harvest);
        }
    }

    private void initGemStorage() {
        InventoryBasic gemStorage = this.gemStorage;
        this.gemStorage = new InventoryBasic("gemStorage", false, 36);
        if (gemStorage != null) {
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = gemStorage.func_70301_a(i);
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.gemStorageHandler = new InvWrapper((IInventory)this.gemStorage);
        InventoryBasic harvest = this.harvest;
        this.harvest = new InventoryBasic("harvest", true, 36);
        if (harvest != null) {
            harvest.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.harvest.func_70302_i_(); ++i) {
                ItemStack itemstack = harvest.func_70301_a(i);
                this.harvest.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.harvest.func_110134_a((IInventoryChangedListener)this);
        this.harvestHandler = new InvWrapper((IInventory)this.harvest);
        this.func_98053_h(this.isTamed());
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        if (this.canPickupItem(itemstack.func_77973_b()) && this.isFarmer()) {
            ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
            if (itemstack1.func_190926_b()) {
                itementity.func_70106_y();
            } else {
                itemstack.func_190920_e(itemstack1.func_190916_E());
            }
        }
    }

    public boolean canPickupItem(Item itemIn) {
        return this.isFarmer() && (itemIn == Items.field_151174_bG || itemIn == Items.field_151172_bF || itemIn == Items.field_151015_O || itemIn == Items.field_151014_N || itemIn == Items.field_185164_cV || itemIn == Items.field_185163_cU || itemIn == Items.field_151075_bm);
    }

    public boolean isFarmer() {
        return this.isTamed() && this.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemHoe;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            this.func_145779_a((Item)ModItems.RECORD_LITTLE_PERIDOT, 1);
        }
    }

    public SoundEvent func_184639_G() {
        return ModSounds.PERIDOT_LIVING;
    }

    public SoundEvent getHurtSound() {
        return ModSounds.PERIDOT_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.PERIDOT_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.PERIDOT_DEATH;
    }
}

