/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIPickUpItems;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityPearl
extends EntityGem
implements IInventoryChangedListener {
    public static final HashMap<Block, Double> PEARL_YIELDS = new HashMap();
    public static final ArrayList<ResourceLocation> PEARL_HAIR_STYLES = new ArrayList();
    public static final ArrayList<ResourceLocation> PEARL_DRESS_STYLES = new ArrayList();
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HAIR_COLOR = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DRESS_STYLE = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> NAKED = EntityDataManager.func_187226_a(EntityPearl.class, (DataSerializer)DataSerializers.field_187198_h);
    public InventoryBasic gemStorage;
    public InvWrapper gemStorageHandler;

    public EntityPearl(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.9f);
        this.initGemStorage();
        this.seePastDoors();
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.CABOCHON, GemPlacements.BELLY);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, (Predicate)new Predicate<EntityCreeper>(){

            public boolean apply(EntityCreeper input) {
                return input.func_70832_p() == 1;
            }
        }, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPickUpItems(this, 0.9));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.droppedGemItem = ModItems.PEARL_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_PEARL_GEM;
        this.field_70180_af.func_187214_a(COLOR, (Object)this.field_70146_Z.nextInt(16));
        this.field_70180_af.func_187214_a(HAIR_COLOR, this.field_70180_af.func_187225_a(COLOR));
        this.field_70180_af.func_187214_a(DRESS_STYLE, (Object)1);
        this.field_70180_af.func_187214_a(NAKED, (Object)false);
    }

    @Override
    public float[] getGemColor() {
        return EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.values()[this.getColor()]);
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.CABOCHON.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.CHEST.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.BACK.id);
            }
        }
    }

    @Override
    public boolean canChangeInsigniaColorByDefault() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("color", this.getColor());
        compound.func_74768_a("hairColor", this.getHairColor());
        compound.func_74768_a("dressStyle", this.getDressStyle());
        compound.func_74757_a("naked", this.isNaked());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
            ItemStack itemstack = this.gemStorage.func_70301_a(i);
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColor(compound.func_74762_e("color"));
        if (compound.func_74764_b("hairColor")) {
            this.setHairColor(compound.func_74762_e("hairColor"));
        } else {
            this.setHairColor(this.getColor());
        }
        this.setDressStyle(compound.func_74762_e("dressStyle"));
        this.setNaked(compound.func_74767_n("naked"));
        NBTTagList nbttaglist = compound.func_150295_c("items", 10);
        this.initGemStorage();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("slot") & 0xFF;
            if (j < 0 || j >= this.gemStorage.func_70302_i_()) continue;
            this.gemStorage.func_70299_a(j, new ItemStack(nbttagcompound));
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.setHairStyle(this.field_70146_Z.nextInt(PEARL_HAIR_STYLES.size()));
        this.setGemCut(GemCuts.CABOCHON.id);
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND) {
            ItemStack stack = player.func_184614_ca();
            if (this.isTamed() && this.isOwner((EntityLivingBase)player)) {
                if (stack.func_77973_b() == Items.field_151097_aZ) {
                    if (player.func_70093_af()) {
                        if (!this.isNaked()) {
                            this.func_184581_c(DamageSource.field_76376_m);
                            this.func_184185_a(SoundEvents.field_187763_eJ, this.func_70599_aP(), this.func_70647_i());
                            this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getInsigniaColor()), 0.0f);
                            this.setNaked(true);
                        }
                    } else {
                        int hair = this.getHairStyle() + 1;
                        if (hair >= PEARL_HAIR_STYLES.size() || hair < 0) {
                            hair = 0;
                        }
                        this.setHairStyle(hair);
                    }
                    this.func_184185_a(SoundEvents.field_187763_eJ, this.func_70599_aP(), this.func_70647_i());
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_77972_a(1, (EntityLivingBase)this);
                    }
                    return true;
                }
                if (stack.func_77973_b() == Items.field_151100_aR) {
                    if (player.func_70093_af()) {
                        int oldColor = this.getHairColor();
                        this.setHairColor(15 - stack.func_77952_i());
                        if (!player.field_71075_bZ.field_75098_d && oldColor != this.getHairColor()) {
                            stack.func_190918_g(1);
                        }
                    } else {
                        int oldColor = this.getColor();
                        this.setColor(15 - stack.func_77952_i());
                        if (!player.field_71075_bZ.field_75098_d && oldColor != this.getColor()) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
                    if (this.isNaked()) {
                        this.setInsigniaColor(stack.func_77952_i());
                        this.setNaked(false);
                        stack.func_190918_g(1);
                    }
                    if (stack.func_190916_E() > 0) {
                        if (player.func_70093_af()) {
                            int dress = this.getDressStyle() + 1;
                            if (dress >= PEARL_DRESS_STYLES.size() || dress < 0) {
                                dress = 0;
                            }
                            this.setDressStyle(dress);
                            this.func_184185_a(SoundEvents.field_187728_s, this.func_70599_aP(), this.func_70647_i());
                            return true;
                        }
                        int oldColor = this.getInsigniaColor();
                        this.setInsigniaColor(stack.func_77952_i());
                        if (!player.field_71075_bZ.field_75098_d && oldColor != this.getInsigniaColor()) {
                            stack.func_190918_g(1);
                        }
                    }
                    return true;
                }
                if (this.isCoreItem(stack)) {
                    return super.func_184645_a(player, hand);
                }
                this.openGUI(player);
                this.playObeySound();
                return true;
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public boolean onSpokenTo(EntityPlayer player, String message) {
        boolean spokenTo = super.onSpokenTo(player, message);
        boolean found = false;
        if (this.isBeingCalledBy(player, message = message.toLowerCase())) {
            this.func_70671_ap().func_75651_a((Entity)player, 30.0f, 30.0f);
            if (this.isOwner((EntityLivingBase)player)) {
                if (this.isMatching("regex.kagic.give", message)) {
                    ArrayList<String> args = this.getArgsFrom("regex.kagic.give", message);
                    if (args.size() > 0) {
                        for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                            if (!this.gemStorage.func_70301_a(i).func_82833_r().toLowerCase().equals(args.get(0)) || player.field_71071_by.func_70447_i() <= -1) continue;
                            player.field_71071_by.func_70441_a(this.gemStorage.func_70301_a(i));
                            found = true;
                        }
                    }
                    if (found) {
                        this.playObeySound();
                    }
                    return found;
                }
                if (this.isMatching("regex.kagic.take", message)) {
                    this.gemStorage.func_174894_a(player.func_184614_ca());
                    this.playObeySound();
                    return true;
                }
                if (this.isDefective()) {
                    if (this.isMatching("regex.kagic.kill", message)) {
                        ArrayList<String> args = this.getArgsFrom("regex.kagic.kill", message);
                        if (args.size() > 0) {
                            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 16.0, 48.0));
                            double distance = Double.MAX_VALUE;
                            for (EntityLivingBase base : list) {
                                double newDistance = this.func_70068_e((Entity)base);
                                if (!(newDistance <= distance) || !base.func_70005_c_().toLowerCase().contains(args.get(0)) || !this.shouldAttackEntity((EntityLivingBase)this, base)) continue;
                                this.func_70604_c(base);
                                distance = newDistance;
                            }
                        }
                        return this.func_70643_av() != null;
                    }
                    if (this.isMatching("regex.kagic.help", message)) {
                        ArrayList<String> args = this.getArgsFrom("regex.kagic.help", message);
                        if (args.size() > 0) {
                            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(48.0, 16.0, 48.0));
                            double distance = Double.MAX_VALUE;
                            for (EntityLivingBase base : list) {
                                double newDistance = this.func_70068_e((Entity)base);
                                if (!(newDistance <= distance) || !base.func_70005_c_().toLowerCase().contains(args.get(0)) || !this.shouldAttackEntity((EntityLivingBase)this, base)) continue;
                                this.func_70661_as().func_75497_a((Entity)base, 1.0);
                                this.func_70604_c(base.func_94060_bK());
                                distance = newDistance;
                            }
                        }
                        return this.func_70638_az() != null;
                    }
                    if (this.isMatching("regex.kagic.retreat", message)) {
                        boolean retreated = this.func_70638_az() != null;
                        this.func_70624_b(null);
                        return retreated;
                    }
                }
            }
        }
        return spokenTo;
    }

    public void func_76316_a(IInventory inventory) {
        ItemStack firstItem = this.gemStorage.func_70301_a(0);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, firstItem);
    }

    protected void func_175445_a(EntityItem itementity) {
        ItemStack itemstack = itementity.func_92059_d();
        ItemStack itemstack1 = this.gemStorage.func_174894_a(itemstack);
        if (itemstack1.func_190926_b()) {
            itementity.func_70106_y();
        } else {
            itemstack.func_190920_e(itemstack1.func_190916_E());
        }
    }

    @Override
    public boolean canPickUpItem(Item itemIn) {
        return true;
    }

    @Override
    public void setDefective(boolean defective) {
        if (defective) {
            this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
            this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, true, false, (Predicate)new Predicate<EntityLiving>(){

                public boolean apply(EntityLiving input) {
                    return input != null && IMob.field_175450_e.apply((Object)input);
                }
            }));
            this.setAttackAI();
        }
        super.setDefective(defective);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setHairColor(int color) {
        this.field_70180_af.func_187227_b(HAIR_COLOR, (Object)color);
    }

    public int getHairColor() {
        return (Integer)this.field_70180_af.func_187225_a(HAIR_COLOR);
    }

    public void setDressStyle(int dress) {
        this.field_70180_af.func_187227_b(DRESS_STYLE, (Object)dress);
    }

    public int getDressStyle() {
        return (Integer)this.field_70180_af.func_187225_a(DRESS_STYLE);
    }

    public void setNaked(boolean naked) {
        this.field_70180_af.func_187227_b(NAKED, (Object)naked);
    }

    public boolean isNaked() {
        return (Boolean)this.field_70180_af.func_187225_a(NAKED);
    }

    public String getSpecialSkin() {
        return "_" + this.getSpecial();
    }

    public void setSpecialSkin(int special) {
        super.setSpecial(special);
        switch (special) {
            case 1: {
                this.func_96094_a("Blue Pearl");
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setSpecial(1);
                this.setColor(3);
                break;
            }
            case 2: {
                this.func_96094_a("Yellow Pearl");
                this.setGemPlacement(GemPlacements.CHEST.id);
                this.setSpecial(2);
                this.setColor(4);
                break;
            }
            case 3: {
                this.func_96094_a("Yellow Pearl");
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                this.setSpecial(3);
                this.setColor(0);
            }
        }
    }

    public InventoryBasic getInventory() {
        return this.gemStorage;
    }

    @Override
    public void func_70636_d() {
        if (!this.func_98052_bS()) {
            this.func_98053_h(this.isTamed());
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        this.func_98053_h(false);
        if (this.getSpecialSkin() == null || this.getSpecialSkin() != null && !this.getSpecialSkin().equals("crystal_gems")) {
            switch (this.getColor()) {
                case 0: {
                    this.droppedGemItem = ModItems.WHITE_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_PEARL_GEM;
                    break;
                }
                case 1: {
                    this.droppedGemItem = ModItems.ORANGE_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_PEARL_GEM;
                    break;
                }
                case 2: {
                    this.droppedGemItem = ModItems.MAGENTA_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_MAGENTA_PEARL_GEM;
                    break;
                }
                case 3: {
                    this.droppedGemItem = ModItems.LIGHT_BLUE_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_BLUE_PEARL_GEM;
                    break;
                }
                case 4: {
                    this.droppedGemItem = ModItems.YELLOW_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_PEARL_GEM;
                    break;
                }
                case 5: {
                    this.droppedGemItem = ModItems.LIME_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_LIME_PEARL_GEM;
                    break;
                }
                case 6: {
                    this.droppedGemItem = ModItems.PINK_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_PINK_PEARL_GEM;
                    break;
                }
                case 7: {
                    this.droppedGemItem = ModItems.GRAY_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_GRAY_PEARL_GEM;
                    break;
                }
                case 8: {
                    this.droppedGemItem = ModItems.LIGHT_GRAY_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_GRAY_PEARL_GEM;
                    break;
                }
                case 9: {
                    this.droppedGemItem = ModItems.CYAN_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_CYAN_PEARL_GEM;
                    break;
                }
                case 10: {
                    this.droppedGemItem = ModItems.PURPLE_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_PEARL_GEM;
                    break;
                }
                case 11: {
                    this.droppedGemItem = ModItems.BLUE_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_PEARL_GEM;
                    break;
                }
                case 12: {
                    this.droppedGemItem = ModItems.BROWN_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_BROWN_PEARL_GEM;
                    break;
                }
                case 13: {
                    this.droppedGemItem = ModItems.GREEN_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_PEARL_GEM;
                    break;
                }
                case 14: {
                    this.droppedGemItem = ModItems.RED_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_RED_PEARL_GEM;
                    break;
                }
                case 15: {
                    this.droppedGemItem = ModItems.BLACK_PEARL_GEM;
                    this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_PEARL_GEM;
                }
            }
        } else {
            this.droppedGemItem = ModItems.PEARL_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_PEARL_GEM;
        }
        super.func_70645_a(cause);
    }

    private void initGemStorage() {
        InventoryBasic gemstorage = this.gemStorage;
        this.gemStorage = new InventoryBasic("gemStorage", false, this.getMaxInventorySlots());
        if (gemstorage != null) {
            gemstorage.func_110132_b((IInventoryChangedListener)this);
            for (int i = 0; i < this.gemStorage.func_70302_i_(); ++i) {
                ItemStack itemstack = gemstorage.func_70301_a(i);
                this.gemStorage.func_70299_a(i, itemstack.func_77946_l());
            }
        }
        this.gemStorage.func_110134_a((IInventoryChangedListener)this);
        this.gemStorageHandler = new InvWrapper((IInventory)this.gemStorage);
        this.func_98053_h(this.isTamed());
    }

    public void openGUI(EntityPlayer playerEntity) {
        if (!this.field_70170_p.field_72995_K && this.isTamed()) {
            this.gemStorage.func_110133_a(this.func_70005_c_());
            playerEntity.func_71007_a((IInventory)this.gemStorage);
        }
    }

    public int getMaxInventorySlots() {
        int slots = 36;
        if (this.getGemPlacement() == GemPlacements.FOREHEAD) {
            slots += 9;
        }
        if (this.isPrimary()) {
            slots += 18;
        }
        return slots;
    }

    public SoundEvent getHurtSound() {
        return ModSounds.PEARL_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.PEARL_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.PEARL_DEATH;
    }
}

