/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIAlignGems;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.EntityAmethyst;
import mod.akrivus.kagic.entity.gem.EntityPearl;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityBlueDiamond
extends EntityGem {
    public static final HashMap<Block, Double> BLUE_DIAMOND_YIELDS = new HashMap();
    private static final DataParameter<Boolean> HOODED = EntityDataManager.func_187226_a(EntityBlueDiamond.class, (DataSerializer)DataSerializers.field_187198_h);
    private BossInfoServer healthBar = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private int hoodTimer = 0;
    private int lastSpecialAttack = 0;
    private int lastRecruitAttack = 0;

    public EntityBlueDiamond(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 13.8f);
        this.field_70138_W = 2.0f;
        this.setCutPlacement(GemCuts.DIAMOND, GemPlacements.CHEST);
        this.field_70728_aV = 12000;
        this.field_70178_ae = true;
        this.isDiamond = true;
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAlignGems(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase input) {
                if (input instanceof EntityGem) {
                    return ((EntityGem)input).getServitude() == 1 || input instanceof EntityBlueDiamond;
                }
                return input instanceof EntityPlayer;
            }
        }));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(800.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(4.0);
        this.droppedGemItem = ModItems.BLUE_DIAMOND_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_DIAMOND_GEM;
        this.field_70180_af.func_187214_a(HOODED, (Object)true);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("hooded", this.isHooded());
        compound.func_74768_a("lastSpecialAttack", this.lastSpecialAttack);
        compound.func_74768_a("lastRecruitAttack", this.lastRecruitAttack);
        this.setServitude(3);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHooded(compound.func_74767_n("hooded"));
        this.lastSpecialAttack = compound.func_74762_e("lastSpecialAttack");
        this.lastRecruitAttack = compound.func_74762_e("lastRecruitAttack");
        this.setServitude(3);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setServitude(3);
        EntityPearl pearl = new EntityPearl(this.field_70170_p);
        pearl.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        pearl.setServitude(3);
        pearl.setGemPlacement(GemPlacements.CHEST.id);
        pearl.setSpecialSkin(1);
        pearl.func_180482_a(difficulty, null);
        this.field_70170_p.func_72838_d((Entity)pearl);
        return super.func_180482_a(difficulty, livingdata);
    }

    public boolean isHooded() {
        return (Boolean)this.field_70180_af.func_187225_a(HOODED);
    }

    public void setHooded(boolean hooded) {
        this.field_70180_af.func_187227_b(HOODED, (Object)hooded);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.healthBar.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_70638_az() == null) {
            if (this.isHooded() && this.hoodTimer > 200 && this.field_70146_Z.nextInt(20) == 0) {
                this.setHooded(false);
                this.hoodTimer = 0;
            }
        } else {
            this.setHooded(true);
        }
        ++this.hoodTimer;
        if (this.func_70638_az() != null) {
            if (this.field_70172_ad > 0 && this.lastRecruitAttack < 200 && this.lastRecruitAttack % 10 == 0 && this.field_70146_Z.nextBoolean()) {
                EntityAmethyst amethyst = new EntityAmethyst(this.field_70170_p);
                amethyst.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                amethyst.setServitude(3);
                amethyst.func_70604_c(this.func_70638_az());
                amethyst.setCitrine(false);
                this.field_70170_p.func_72838_d((Entity)amethyst);
            }
            ++this.lastRecruitAttack;
            if (this.lastSpecialAttack < 0 && this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_72912_H().func_176142_i(0);
                this.field_70170_p.func_72912_H().func_76080_g(1200);
                this.field_70170_p.func_72912_H().func_76090_f(1200);
                this.field_70170_p.func_72912_H().func_76084_b(true);
                this.lastSpecialAttack = 2400;
            }
            --this.lastSpecialAttack;
        }
    }

    public void func_184178_b(EntityPlayerMP player) {
        this.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.RECORD_BLUE_DIAMOND, SoundCategory.MUSIC, 100.0f, 1.0f);
        this.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.BLUE_DIAMOND_INTRO, SoundCategory.HOSTILE, 10.0f, 1.0f);
        super.func_184178_b(player);
        this.healthBar.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        this.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.BLUE_DIAMOND_OUTRO, SoundCategory.HOSTILE, 10.0f, 1.0f);
        super.func_184203_c(player);
        this.healthBar.func_186761_b(player);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase && this.func_110143_aJ() / 20.0f < amount && this.field_70146_Z.nextInt(4) == 0 && !this.field_70170_p.field_72995_K) {
            EntityAmethyst amethyst = new EntityAmethyst(this.field_70170_p);
            amethyst.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            amethyst.setServitude(3);
            amethyst.func_70604_c((EntityLivingBase)source.func_76346_g());
            amethyst.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
            this.field_70170_p.func_72838_d((Entity)amethyst);
        }
        if (this.lastRecruitAttack > 800 && this.field_70146_Z.nextInt(3) == 0) {
            this.lastRecruitAttack = 0;
        }
        if (this.field_70146_Z.nextInt(30) > 0) {
            this.lastSpecialAttack = 2400;
        }
        return super.func_70097_a(source, amount);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        int divider;
        int n = divider = entityIn instanceof EntityPlayer ? 5 : 1;
        if (entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(40 + this.field_70146_Z.nextInt(40)) / (float)divider)) {
            entityIn.field_70159_w += -this.field_70159_w;
            entityIn.field_70179_y += -this.field_70179_y;
            entityIn.field_70181_x += 0.4;
        }
        return super.func_70652_k(entityIn);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_145779_a((Item)ModItems.RECORD_BLUE_DIAMOND, 1);
            if (cause.func_76346_g() instanceof EntityPlayer) {
                List list = this.field_70170_p.func_72872_a(EntityGem.class, this.func_174813_aQ().func_72314_b(24.0, 8.0, 24.0));
                EntityPlayer player = (EntityPlayer)cause.func_76346_g();
                for (EntityGem gem : list) {
                    if (gem.getServitude() != 3 || gem.equals((Object)this)) continue;
                    gem.setOwnerId(player.func_110124_au());
                    gem.setLeader(player);
                    gem.setServitude(1);
                    gem.func_70661_as().func_75499_g();
                    gem.func_70624_b(null);
                    gem.func_70606_j(gem.func_110138_aP());
                    gem.playTameEffect();
                    gem.field_70170_p.func_72960_a((Entity)gem, (byte)7);
                    gem.playObeySound();
                }
            }
        }
        super.func_70645_a(cause);
    }

    public SoundEvent func_184639_G() {
        return ModSounds.BLUE_DIAMOND_LIVING;
    }

    public SoundEvent getHurtSound() {
        return ModSounds.BLUE_DIAMOND_HURT;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.BLUE_DIAMOND_DEATH;
    }
}

