/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtByTarget;
import mod.akrivus.kagic.entity.ai.EntityAIDiamondHurtTarget;
import mod.akrivus.kagic.entity.ai.EntityAIFollowDiamond;
import mod.akrivus.kagic.entity.ai.EntityAIScareMobs;
import mod.akrivus.kagic.entity.ai.EntityAISitStill;
import mod.akrivus.kagic.entity.ai.EntityAIStay;
import mod.akrivus.kagic.entity.gem.GemCuts;
import mod.akrivus.kagic.entity.gem.GemPlacements;
import mod.akrivus.kagic.init.ModItems;
import mod.akrivus.kagic.init.ModSounds;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityAgate
extends EntityGem {
    public static final HashMap<Block, Double> AGATE_YIELDS = new HashMap();
    public static final ArrayList<ResourceLocation> AGATE_HAIR_STYLES = new ArrayList();
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntityAgate.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityAgate(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 2.3f);
        this.isSoldier = true;
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK_OF_HEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.FOREHEAD);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_EYE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_CHEEK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_CHEEK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_SHOULDER);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_SHOULDER);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_HAND);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_HAND);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BACK);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.CHEST);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.BELLY);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_THIGH);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_THIGH);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.LEFT_KNEE);
        this.setCutPlacement(GemCuts.TEARDROP, GemPlacements.RIGHT_KNEE);
        this.stayAI = new EntityAIStay(this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowDiamond(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISitStill(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIScareMobs(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 16.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 16.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIDiamondHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIDiamondHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.droppedGemItem = ModItems.AGATE_GEM;
        this.droppedCrackedGemItem = ModItems.CRACKED_AGATE_GEM;
        this.field_70180_af.func_187214_a(COLOR, (Object)new Random().nextInt(15));
    }

    @Override
    public float[] getGemColor() {
        if (this.isHolly()) {
            return new float[]{0.5764706f, 0.40392157f, 0.972549f};
        }
        return EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.values()[this.getColor()]);
    }

    @Override
    public void convertGems(int placement) {
        this.setGemCut(GemCuts.TEARDROP.id);
        switch (placement) {
            case 0: {
                this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
                break;
            }
            case 1: {
                this.setGemPlacement(GemPlacements.FOREHEAD.id);
                break;
            }
            case 2: {
                this.setGemPlacement(GemPlacements.RIGHT_SHOULDER.id);
                break;
            }
            case 3: {
                this.setGemPlacement(GemPlacements.LEFT_SHOULDER.id);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("color", ((Integer)this.field_70180_af.func_187225_a(COLOR)).intValue());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74762_e("color"));
        if (compound.func_74764_b("holly")) {
            this.setSpecial(compound.func_74767_n("holly") ? 1 : 0);
            this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
            this.setGemCut(GemCuts.TEARDROP.id);
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        boolean holly = this.field_70146_Z.nextInt(9) == 0;
        this.setHairStyle(this.field_70146_Z.nextInt(AGATE_HAIR_STYLES.size()));
        this.func_96094_a(new TextComponentTranslation(String.format("entity.kagic.agate_%1$d.name", this.getColor()), new Object[0]).func_150261_e());
        if (holly) {
            this.func_96094_a(new TextComponentTranslation("entity.kagic.agate_16.name", new Object[0]).func_150261_e());
            this.setGemPlacement(GemPlacements.BACK_OF_HEAD.id);
            this.setGemCut(GemCuts.TEARDROP.id);
            this.setSpecial(1);
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public int getColor() {
        if (this.isHolly()) {
            return 3;
        }
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public boolean isHolly() {
        return this.getSpecial() == 1 || this.func_70005_c_().toLowerCase().contains("holly");
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        switch (this.getColor()) {
            case 0: {
                this.droppedGemItem = ModItems.WHITE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_WHITE_AGATE_GEM;
                break;
            }
            case 1: {
                this.droppedGemItem = ModItems.ORANGE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_ORANGE_AGATE_GEM;
                break;
            }
            case 2: {
                this.droppedGemItem = ModItems.MAGENTA_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_MAGENTA_AGATE_GEM;
                break;
            }
            case 3: {
                this.droppedGemItem = ModItems.LIGHT_BLUE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_BLUE_AGATE_GEM;
                break;
            }
            case 4: {
                this.droppedGemItem = ModItems.YELLOW_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_YELLOW_AGATE_GEM;
                break;
            }
            case 5: {
                this.droppedGemItem = ModItems.LIME_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIME_AGATE_GEM;
                break;
            }
            case 6: {
                this.droppedGemItem = ModItems.PINK_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PINK_AGATE_GEM;
                break;
            }
            case 7: {
                this.droppedGemItem = ModItems.GRAY_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GRAY_AGATE_GEM;
                break;
            }
            case 8: {
                this.droppedGemItem = ModItems.LIGHT_GRAY_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_LIGHT_GRAY_AGATE_GEM;
                break;
            }
            case 9: {
                this.droppedGemItem = ModItems.CYAN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_CYAN_AGATE_GEM;
                break;
            }
            case 10: {
                this.droppedGemItem = ModItems.PURPLE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_PURPLE_AGATE_GEM;
                break;
            }
            case 11: {
                this.droppedGemItem = ModItems.BLUE_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLUE_AGATE_GEM;
                break;
            }
            case 12: {
                this.droppedGemItem = ModItems.BROWN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BROWN_AGATE_GEM;
                break;
            }
            case 13: {
                this.droppedGemItem = ModItems.GREEN_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_GREEN_AGATE_GEM;
                break;
            }
            case 14: {
                this.droppedGemItem = ModItems.RED_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_RED_AGATE_GEM;
                break;
            }
            case 15: {
                this.droppedGemItem = ModItems.BLACK_AGATE_GEM;
                this.droppedCrackedGemItem = ModItems.CRACKED_BLACK_AGATE_GEM;
            }
        }
        if (this.isHolly()) {
            this.droppedGemItem = ModItems.HOLLY_BLUE_AGATE_GEM;
            this.droppedCrackedGemItem = ModItems.CRACKED_HOLLY_BLUE_AGATE_GEM;
        }
        super.func_70645_a(cause);
    }

    public SoundEvent getHurtSound() {
        return ModSounds.AGATE_HURT;
    }

    @Override
    public SoundEvent getObeySound() {
        return ModSounds.AGATE_OBEY;
    }

    public SoundEvent func_184615_bR() {
        return ModSounds.AGATE_DEATH;
    }
}

