/*
 * Decompiled with CFR 0.152.
 */
package mod.akrivus.kagic.entity;

import mod.akrivus.kagic.entity.EntityGem;
import mod.akrivus.kagic.entity.ai.EntityAISlagEatGems;
import mod.akrivus.kagic.entity.ai.EntityAISlagFuse;
import mod.akrivus.kagic.entity.ai.EntityAISlagHateLight;
import mod.akrivus.kagic.init.ModItems;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;

public class EntitySlag
extends EntityMob {
    protected static final DataParameter<Integer> COUNT = EntityDataManager.func_187226_a(EntitySlag.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntitySlag.class, (DataSerializer)DataSerializers.field_187192_b);
    private BossInfoServer healthBar = new BossInfoServer((ITextComponent)new TextComponentTranslation("entity.kagic.slag.super", new Object[0]), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);
    public int compatIndex = 0;

    public EntitySlag(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.3f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISlagFuse(this, 0.8f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISlagHateLight(this, 1.2, 8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISlagEatGems(this, 1.8));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityGem.class, true));
        this.field_70180_af.func_187214_a(COUNT, (Object)1);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.compatIndex = worldIn.field_73012_v.nextInt(4);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("count", ((Integer)this.field_70180_af.func_187225_a(COUNT)).intValue());
        compound.func_74768_a("age", ((Integer)this.field_70180_af.func_187225_a(AGE)).intValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(AGE, (Object)compound.func_74762_e("age"));
        this.setCount(compound.func_74762_e("count"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_70105_a(0.4f * (float)this.getCount(), 0.3f * (float)this.getCount());
        if (this.getStage() < 4) {
            this.addAge();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.healthBar.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public int getStage() {
        return (Integer)this.field_70180_af.func_187225_a(AGE) / (18000 + this.field_70146_Z.nextInt(6000));
    }

    public int getAge() {
        return (Integer)this.field_70180_af.func_187225_a(AGE);
    }

    public void setAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
    }

    public void addAge() {
        this.field_70180_af.func_187227_b(AGE, (Object)((Integer)this.field_70180_af.func_187225_a(AGE) + 1));
    }

    public int getCount() {
        return (Integer)this.field_70180_af.func_187225_a(COUNT);
    }

    public void setCount(int count) {
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0 * (double)count);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0 * (double)count);
        this.func_70105_a(0.4f * (float)count, 0.3f * (float)count);
        this.field_70180_af.func_187227_b(COUNT, (Object)count);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && source == DamageSource.field_76368_d) {
            AxisAlignedBB bounds = this.func_174813_aQ();
            for (double x = bounds.field_72340_a; x < bounds.field_72336_d; x += 1.0) {
                for (double y = bounds.field_72338_b; y < bounds.field_72337_e; y += 1.0) {
                    for (double z = bounds.field_72339_c; z < bounds.field_72334_f; z += 1.0) {
                        BlockPos blockPos = new BlockPos(x, y, z);
                        BlockPos blockPos2 = new BlockPos(x, y, z);
                        if (!(this.field_70170_p.func_180495_p(blockPos).func_185887_b(this.field_70170_p, blockPos2) > -1.0f)) continue;
                        this.field_70170_p.func_175655_b(new BlockPos(x, y, z), true);
                    }
                }
            }
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.getCount(); ++i) {
                this.func_70099_a(new ItemStack((Item)ModItems.ACTIVATED_GEM_SHARD), 0.0f);
            }
        }
        super.func_70645_a(cause);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        if (this.getCount() > 3) {
            this.healthBar.func_186760_a(player);
        }
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.healthBar.func_186761_b(player);
    }

    public boolean canFuse() {
        return this.getCount() < 10 && ((double)(this.func_110143_aJ() / this.func_110138_aP()) <= 0.9 || this.func_70638_az() != null || this.func_70643_av() != null);
    }

    public EntitySlag fuse(EntitySlag other) {
        EntitySlag newSlag = new EntitySlag(this.field_70170_p);
        newSlag.setCount(this.getCount() + other.getCount());
        newSlag.setAge(this.getAge() + other.getAge());
        newSlag.func_70606_j(newSlag.func_110138_aP());
        newSlag.func_70012_b((this.field_70165_t + other.field_70165_t) / 2.0, (this.field_70163_u + other.field_70163_u) / 2.0, (this.field_70161_v + other.field_70161_v) / 2.0, (this.field_70177_z + other.field_70177_z) / 2.0f, (this.field_70125_A + other.field_70125_A) / 2.0f);
        return newSlag;
    }
}

