/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.util.itemwrapper;

import com.cjm721.overloaded.storage.LongEnergyStack;
import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.storage.energy.LongEnergyStorage;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class LongEnergyWrapper
implements ICapabilityProvider,
IEnergyStorage,
IHyperHandlerEnergy,
IDataUpdate {
    private final ItemStack stack;

    public LongEnergyWrapper(ItemStack stack) {
        this.stack = stack;
        NBTTagCompound tagCompound = this.stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (!tagCompound.func_74764_b("EnergyStorage")) {
            LongEnergyStorage storage = new LongEnergyStorage(this);
            NBTTagCompound storageTag = storage.serializeNBT();
            tagCompound.func_74782_a("EnergyStorage", (NBTBase)storageTag);
            this.stack.func_77982_d(tagCompound);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || capability == CapabilityHyperEnergy.HYPER_ENERGY_HANDLER;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }

    @Override
    @Nonnull
    public LongEnergyStack status() {
        return this.getStorage().status();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public LongEnergyStack take(@Nonnull LongEnergyStack stack, boolean doAction) {
        LongEnergyStorage storage = this.getStorage();
        try {
            LongEnergyStack longEnergyStack = storage.take(stack, doAction);
            return longEnergyStack;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public LongEnergyStack give(@Nonnull LongEnergyStack stack, boolean doAction) {
        LongEnergyStorage storage = this.getStorage();
        try {
            LongEnergyStack longEnergyStack = storage.give(stack, doAction);
            return longEnergyStack;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveEnergy(int maxReceive, boolean simulate) {
        LongEnergyStorage storage = this.getStorage();
        try {
            int n = storage.receiveEnergy(maxReceive, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extractEnergy(int maxExtract, boolean simulate) {
        LongEnergyStorage storage = this.getStorage();
        try {
            int n = storage.extractEnergy(maxExtract, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    public int getEnergyStored() {
        return this.getStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getStorage().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getStorage().canExtract();
    }

    public boolean canReceive() {
        return this.getStorage().canReceive();
    }

    @Nonnull
    private LongEnergyStorage getStorage() {
        NBTTagCompound compound = this.stack.func_77978_p().func_74775_l("EnergyStorage");
        LongEnergyStorage storage = new LongEnergyStorage(this);
        storage.deserializeNBT(compound);
        return storage;
    }

    private void setStorage(@Nonnull LongEnergyStorage storage) {
        NBTTagCompound compound = storage.serializeNBT();
        this.stack.func_77978_p().func_74782_a("EnergyStorage", (NBTBase)compound);
    }

    @Override
    public void dataUpdated() {
    }
}

