/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.util.itemwrapper;

import com.cjm721.overloaded.storage.energy.LongEnergyStorage;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class IntEnergyWrapper
implements ICapabilityProvider,
IEnergyStorage,
IDataUpdate {
    private final ItemStack stack;

    public IntEnergyWrapper(ItemStack stack) {
        this.stack = stack;
        NBTTagCompound tagCompound = this.stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (!tagCompound.func_74764_b("IntEnergyStorage")) {
            LongEnergyStorage storage = new LongEnergyStorage(this);
            NBTTagCompound storageTag = storage.serializeNBT();
            tagCompound.func_74782_a("IntEnergyStorage", (NBTBase)storageTag);
            this.stack.func_77982_d(tagCompound);
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveEnergy(int maxReceive, boolean simulate) {
        EnergyStorage storage = this.getStorage();
        try {
            int n = storage.receiveEnergy(maxReceive, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extractEnergy(int maxExtract, boolean simulate) {
        EnergyStorage storage = this.getStorage();
        try {
            int n = storage.extractEnergy(maxExtract, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    public int getEnergyStored() {
        return this.getStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getStorage().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getStorage().canExtract();
    }

    public boolean canReceive() {
        return this.getStorage().canReceive();
    }

    @Nonnull
    private EnergyStorage getStorage() {
        int energy = this.stack.func_77978_p().func_74762_e("IntEnergyStorage");
        return new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, energy);
    }

    private void setStorage(@Nonnull EnergyStorage storage) {
        this.stack.func_77978_p().func_74768_a("IntEnergyStorage", storage.getEnergyStored());
    }

    @Override
    public void dataUpdated() {
    }
}

